/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.registry.EclipseBundleListener;
import org.eclipse.core.internal.registry.ExtensionLinker;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Factory;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.registry.RegistryCacheWriter;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IShutdownHook;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;

public class PlatformActivator
extends Plugin
implements BundleActivator {
    private static BundleContext context;
    private EclipseBundleListener pluginBundleListener;
    private ExtensionRegistry registry;
    private ServiceReference environmentServiceReference;
    private static File cacheFile;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        cacheFile = InternalPlatform.getDefault().getConfigurationMetadataLocation().append(".registry").toFile();
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        PlatformActivator.context = context;
        this.acquireInfoService();
        this.startInternalPlatform();
        this.startRegistry(context);
        this.installPlatformURLSupport();
        this.registerApplicationService();
        InternalPlatform.getDefault().setRuntimeInstance(this);
        super.start(context);
    }

    private void installBackwardCompatibleURLSupport() {
        try {
            Class<?> handler = Class.forName("org.eclipse.core.internal.runtime.PlatformURLPluginHandlerFactory");
            Method startupMethod = handler.getDeclaredMethod("startup", null);
            startupMethod.invoke(handler, null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void installPlatformURLSupport() {
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
        PlatformURLBaseConnection.startup(InternalPlatform.getDefault().getInstallURL());
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"platform"});
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.osgi.service.url.URLStreamHandlerService;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)new PlatformURLHandler(), properties);
    }

    private void startRegistry(BundleContext context) {
        Class<?> clazz;
        boolean fromCache = true;
        if (InternalPlatform.cacheRegistry) {
            MultiStatus problems = new MultiStatus("org.eclipse.core.runtime", 1, "Registry cache problems", null);
            Factory factory = new Factory(problems);
            long start = 0L;
            if (InternalPlatform.DEBUG) {
                start = System.currentTimeMillis();
            }
            this.registry = new RegistryCacheReader(cacheFile, factory, InternalPlatform.lazyRegistryCacheLoading).loadCache();
            if (InternalPlatform.DEBUG && this.registry != null) {
                System.out.println("Reading registry cache: " + (System.currentTimeMillis() - start));
            }
            if (InternalPlatform.DEBUG_REGISTRY) {
                if (this.registry == null) {
                    System.out.println("Reloading registry from manifest files...");
                } else {
                    System.out.println("Using registry cache " + (InternalPlatform.lazyRegistryCacheLoading ? "with" : "without") + " lazy element loading...");
                }
            }
            if (!problems.isOK()) {
                System.out.println(problems);
            }
        }
        if (this.registry == null) {
            fromCache = false;
            this.registry = new ExtensionRegistry(new ExtensionLinker());
        }
        this.pluginBundleListener = new EclipseBundleListener(this.registry);
        context.addBundleListener((BundleListener)this.pluginBundleListener);
        if (!fromCache) {
            this.pluginBundleListener.processBundles(context.getBundles());
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.runtime.IExtensionRegistry;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)this.registry, new Hashtable());
        InternalPlatform.getDefault().setExtensionRegistry(this.registry);
    }

    public void stop(BundleContext context) throws Exception {
        this.stopRegistry(context);
        this.environmentInfoServiceReleased(this.environmentServiceReference);
        InternalPlatform.getDefault().stop(context);
        InternalPlatform.getDefault().setRuntimeInstance(null);
    }

    private void stopRegistry(BundleContext context) {
        context.removeBundleListener((BundleListener)this.pluginBundleListener);
        if (this.registry != null && this.registry.isDirty()) {
            new RegistryCacheWriter(cacheFile).saveCache(this.registry);
            this.registry = null;
        }
    }

    private void acquireInfoService() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.eclipse.osgi.service.environment.EnvironmentInfo;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.environmentServiceReference = context.getServiceReference(clazz.getName());
        if (this.environmentServiceReference == null) {
            return;
        }
        InternalPlatform.infoService = (EnvironmentInfo)context.getService(this.environmentServiceReference);
    }

    private void startInternalPlatform() throws Exception {
        InternalPlatform.getDefault().start(context);
    }

    private void environmentInfoServiceReleased(ServiceReference reference) {
        if (this.environmentServiceReference == null) {
            return;
        }
        if (this.environmentServiceReference != reference) {
            return;
        }
        InternalPlatform.infoService = null;
        context.ungetService(this.environmentServiceReference);
        this.environmentServiceReference = null;
    }

    private void registerApplicationService() {
        Runnable work = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object var5_9;
                IPlatformRunnable application = null;
                String applicationId = null;
                try {
                    applicationId = System.getProperty("eclipse.application");
                    IExtension applicationExtension = PlatformActivator.this.registry.getExtension("org.eclipse.core.runtime", "applications", applicationId);
                    if (applicationExtension == null) {
                        throw new RuntimeException("Unable to locate application extension: " + applicationId);
                    }
                    IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
                    if (configs.length == 0) {
                        throw new RuntimeException("Invalid (empty) application extension: " + applicationId);
                    }
                    IConfigurationElement config = configs[0];
                    application = (IPlatformRunnable)config.createExecutableExtension("run");
                    if (application == null) {
                        throw new IllegalArgumentException(Policy.bind("application.notFound", applicationId));
                    }
                }
                catch (Exception e) {
                    IStatus status = null;
                    status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, "org.eclipse.core.runtime", 13, e.getMessage(), e);
                    InternalPlatform.getDefault().getLog(context.getBundle()).log(status);
                    return;
                }
                try {
                    try {
                        Object result = application.run(InternalPlatform.getDefault().getAppArgs());
                        int exitCode = result instanceof Integer ? (Integer)result : 0;
                        System.setProperty("eclipse.exitcode", Integer.toString(exitCode));
                        if (InternalPlatform.DEBUG) {
                            System.out.println(Policy.bind("application.returned", new String[]{applicationId, Integer.toString(exitCode)}));
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof RuntimeException)) throw new RuntimeException("Error running application", e);
                        throw (RuntimeException)e;
                    }
                }
                catch (Throwable throwable) {
                    var5_9 = null;
                    PlatformActivator.this.stopLegacyBundles(context);
                    throw throwable;
                }
                {
                    var5_9 = null;
                    PlatformActivator.this.stopLegacyBundles(context);
                    return;
                }
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put("eclipse.application", "default");
        context.registerService("java.lang.Runnable", (Object)work, properties);
    }

    protected void stopLegacyBundles(BundleContext context) {
        IExtensionPoint shutdownHooksExtPt = this.registry.getExtensionPoint("org.eclipse.core.runtime", "applicationShutdownHook");
        IExtension[] shutdownHooksExts = shutdownHooksExtPt.getExtensions();
        int i = 0;
        while (i < shutdownHooksExts.length) {
            if (shutdownHooksExts[i].getParentIdentifier().equals("org.eclipse.core.runtime.compatibility")) {
                IConfigurationElement[] configEls = shutdownHooksExts[i].getConfigurationElements();
                try {
                    IShutdownHook shutdownHook = (IShutdownHook)configEls[0].createExecutableExtension("run");
                    shutdownHook.run();
                }
                catch (CoreException e) {
                    InternalPlatform.getDefault().getLog(context.getBundle()).log(e.getStatus());
                }
                break;
            }
            ++i;
        }
    }
}

