/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.Tokenizer;
import org.osgi.framework.BundleException;

public class ManifestElement {
    protected String value;
    protected Hashtable attributes;

    public ManifestElement() {
        this(null);
    }

    public ManifestElement(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(key);
    }

    public Enumeration getKeys() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keys();
    }

    protected void setValue(String value) {
        this.value = value;
    }

    protected void addAttribute(String key, String value) {
        String curValue;
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        if ((curValue = (String)this.attributes.get(key)) != null) {
            value = String.valueOf(curValue) + ";" + value;
        }
        this.attributes.put(key, value);
    }

    public static ManifestElement[] parseClassPath(String value) throws BundleException {
        char c;
        if (value == null) {
            return null;
        }
        Vector<ManifestElement> classpaths = new Vector<ManifestElement>(10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String path;
            if ((path = tokenizer.getToken(",")) == null) {
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-ClassPath", value));
            }
            if (Debug.DEBUG_MANIFEST) {
                Debug.println("Classpath entry: " + path);
            }
            ManifestElement classpath = new ManifestElement(path);
            int index = path.indexOf(";");
            if (index != -1) {
                if (index + 1 >= path.length()) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-ClassPath", value));
                }
                String filterString = path.substring(index + 1);
                if (!filterString.endsWith(")")) {
                    char nextChar;
                    StringBuffer buf = new StringBuffer(filterString);
                    buf.append(' ');
                    do {
                        if ((nextChar = tokenizer.getChar()) == '\uffffffff') {
                            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-ClassPath", value));
                        }
                        buf.append(nextChar);
                    } while (nextChar != ')');
                    filterString = buf.toString();
                }
                classpath.addAttribute("filter", filterString);
            }
            classpaths.addElement(classpath);
        } while ((c = tokenizer.getChar()) == ',');
        if (c != '\u0000') {
            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-ClassPath", value));
        }
        int size = classpaths.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ManifestElement[size];
        classpaths.copyInto(result);
        return result;
    }

    public static ManifestElement[] parsePackageDescription(String value) throws BundleException {
        char c;
        if (value == null) {
            return null;
        }
        Vector<ManifestElement> pkgvec = new Vector<ManifestElement>(10, 10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String pkgname;
            if ((pkgname = tokenizer.getToken(";,")) == null) {
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
            }
            ManifestElement pkgdes = new ManifestElement(pkgname);
            if (Debug.DEBUG_MANIFEST) {
                Debug.print("PackageDescription: " + pkgname);
            }
            c = tokenizer.getChar();
            while (c == ';') {
                String key = tokenizer.getToken(";,=");
                if (key == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
                }
                c = tokenizer.getChar();
                if (c == '=') {
                    String val = tokenizer.getString(";,");
                    if (val == null) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
                    }
                    if (Debug.DEBUG_MANIFEST) {
                        Debug.print(";" + key + "=" + val);
                    }
                    try {
                        pkgdes.addAttribute(key, val);
                    }
                    catch (Exception e) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value), (Throwable)e);
                    }
                    c = tokenizer.getChar();
                    continue;
                }
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
            }
            pkgvec.addElement(pkgdes);
            if (!Debug.DEBUG_MANIFEST) continue;
            Debug.println("");
        } while (c == ',');
        if (c != '\u0000') {
            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
        }
        int size = pkgvec.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ManifestElement[size];
        pkgvec.copyInto(result);
        return result;
    }

    public static ManifestElement[] parseBundleDescriptions(String value) throws BundleException {
        char c;
        if (value == null) {
            return null;
        }
        Vector<ManifestElement> bundlevec = new Vector<ManifestElement>(10, 10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String bundleUID;
            if ((bundleUID = tokenizer.getToken(";,")) == null) {
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
            }
            ManifestElement bundledes = new ManifestElement(bundleUID);
            if (Debug.DEBUG_MANIFEST) {
                Debug.print("BundleDescription: " + bundleUID);
            }
            c = tokenizer.getChar();
            while (c == ';') {
                String key = tokenizer.getToken(";,=");
                if (key == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
                }
                c = tokenizer.getChar();
                if (c == '=') {
                    String val = tokenizer.getString(";,");
                    if (val == null) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
                    }
                    if (Debug.DEBUG_MANIFEST) {
                        Debug.print(";" + key + "=" + val);
                    }
                    try {
                        bundledes.addAttribute(key, val);
                    }
                    catch (Exception e) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value), (Throwable)e);
                    }
                    c = tokenizer.getChar();
                    continue;
                }
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
            }
            bundlevec.addElement(bundledes);
            if (!Debug.DEBUG_MANIFEST) continue;
            Debug.println("");
        } while (c == ',');
        if (c != '\u0000') {
            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
        }
        int size = bundlevec.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ManifestElement[size];
        bundlevec.copyInto(result);
        return result;
    }

    public static ManifestElement[] parseNativeCodeDescription(String value) throws BundleException {
        char c;
        if (value == null) {
            return null;
        }
        Vector<ManifestElement> nativevec = new Vector<ManifestElement>(10, 10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String next;
            if ((next = tokenizer.getToken(";,")) == null) {
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-NativeCode", value));
            }
            StringBuffer codepaths = new StringBuffer(next);
            if (Debug.DEBUG_MANIFEST) {
                Debug.print("NativeCodeDescription: " + next);
            }
            c = tokenizer.getChar();
            while (c == ';') {
                next = tokenizer.getToken(";,=");
                if (next == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-NativeCode", value));
                }
                c = tokenizer.getChar();
                if (c != ';') continue;
                codepaths.append(";").append(next);
                if (!Debug.DEBUG_MANIFEST) continue;
                Debug.print(";" + next);
            }
            ManifestElement nativedes = new ManifestElement(codepaths.toString());
            while (c == '=') {
                String val = tokenizer.getString(";,");
                if (val == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-NativeCode", value));
                }
                if (Debug.DEBUG_MANIFEST) {
                    Debug.print(";" + next + "=" + val);
                }
                try {
                    nativedes.addAttribute(next, val);
                }
                catch (Exception e) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-NativeCode", value), (Throwable)e);
                }
                c = tokenizer.getChar();
                if (c != ';') continue;
                next = tokenizer.getToken("=");
                if (next == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-NativeCode", value));
                }
                c = tokenizer.getChar();
            }
            nativevec.addElement(nativedes);
            if (!Debug.DEBUG_MANIFEST) continue;
            Debug.println("");
        } while (c == ',');
        if (c != '\u0000') {
            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", "Bundle-NativeCode", value));
        }
        int size = nativevec.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ManifestElement[size];
        nativevec.copyInto(result);
        return result;
    }

    public static ManifestElement[] parseBasicCommaSeparation(String header, String value) throws BundleException {
        char c;
        if (value == null) {
            return null;
        }
        Vector<ManifestElement> bundlevec = new Vector<ManifestElement>(10, 10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String elementname;
            if ((elementname = tokenizer.getToken(";,")) == null) {
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
            }
            ManifestElement element = new ManifestElement(elementname);
            if (Debug.DEBUG_MANIFEST) {
                Debug.print("ManifestElement: " + elementname);
            }
            c = tokenizer.getChar();
            while (c == ';') {
                String key = tokenizer.getToken(";,=");
                if (key == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
                }
                c = tokenizer.getChar();
                if (c == '=') {
                    String val = tokenizer.getString(";,");
                    if (val == null) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value));
                    }
                    if (Debug.DEBUG_MANIFEST) {
                        Debug.print(";" + key + "=" + val);
                    }
                    try {
                        element.addAttribute(key, val);
                    }
                    catch (Exception e) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_PACKAGE_EXCEPTION", value), (Throwable)e);
                    }
                    c = tokenizer.getChar();
                    continue;
                }
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", value));
            }
            bundlevec.addElement(element);
            if (!Debug.DEBUG_MANIFEST) continue;
            Debug.println("");
        } while (c == ',');
        if (c != '\u0000') {
            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", value));
        }
        int size = bundlevec.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ManifestElement[size];
        bundlevec.copyInto(result);
        return result;
    }
}

