/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.tracker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    private static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    private Tracked tracked;
    private ServiceTrackerCustomizer customizer;

    public ServiceTracker(BundleContext context, ServiceReference reference, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.customizer = customizer == null ? this : customizer;
        try {
            this.filter = context.createFilter("(service.id=" + reference.getProperty("service.id").toString() + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.customizer = customizer == null ? this : customizer;
        try {
            this.filter = context.createFilter("(objectClass=" + clazz + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
    }

    public ServiceTracker(BundleContext context, Filter filter, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public synchronized void open() {
        if (this.tracked == null) {
            ServiceReference[] references;
            Tracked tracked = this.tracked = new Tracked(this.customizer, this.filter);
            synchronized (tracked) {
                this.context.addServiceListener((ServiceListener)this.tracked);
                try {
                    references = this.context.getServiceReferences(null, this.filter.toString());
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    throw new RuntimeException("unexpected InvalidSyntaxException");
                }
            }
            if (references != null) {
                int size = references.length;
                int i = 0;
                while (i < size) {
                    ServiceReference reference = references[i];
                    if (reference.getBundle() != null) {
                        this.tracked.track(reference);
                    }
                    ++i;
                }
            }
        }
    }

    public synchronized void close() {
        if (this.tracked != null) {
            this.tracked.close();
            ServiceReference[] references = this.getServiceReferences();
            Tracked outgoing = this.tracked;
            this.tracked = null;
            try {
                this.context.removeServiceListener((ServiceListener)outgoing);
            }
            catch (IllegalStateException illegalStateException) {}
            if (references != null) {
                int i = 0;
                while (i < references.length) {
                    outgoing.untrack(references[i]);
                    ++i;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object object) {
        this.context.ungetService(reference);
    }

    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.tracked;
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int size = tracked.size();
            if (size == 0) {
                return null;
            }
            ServiceReference[] references = new ServiceReference[size];
            Enumeration enumeration = tracked.keys();
            int i = 0;
            while (i < size) {
                references[i] = (ServiceReference)enumeration.nextElement();
                ++i;
            }
            return references;
        }
    }

    public Object[] getServices() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int size = tracked.size();
            if (size == 0) {
                return null;
            }
            Object[] objects = new Object[size];
            Enumeration enumeration = tracked.elements();
            int i = 0;
            while (i < size) {
                objects[i] = enumeration.nextElement();
                ++i;
            }
            return objects;
        }
    }

    public ServiceReference getServiceReference() {
        int length;
        ServiceReference[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length > 0) {
            int index = 0;
            if (length > 1) {
                int[] rankings = new int[length];
                int count = 0;
                int maxRanking = Integer.MIN_VALUE;
                int i = 0;
                while (i < length) {
                    int ranking;
                    Object property = references[i].getProperty("service.ranking");
                    rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                    if (ranking > maxRanking) {
                        index = i;
                        maxRanking = ranking;
                        count = 1;
                    } else if (ranking == maxRanking) {
                        ++count;
                    }
                    ++i;
                }
                if (count > 1) {
                    long minId = Long.MAX_VALUE;
                    int i2 = 0;
                    while (i2 < length) {
                        long id;
                        if (rankings[i2] == maxRanking && (id = ((Long)references[i2].getProperty("service.id")).longValue()) < minId) {
                            index = i2;
                            minId = id;
                        }
                        ++i2;
                    }
                }
            }
            return references[index];
        }
        return null;
    }

    public Object getService(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        return tracked.get(reference);
    }

    public Object getService() {
        ServiceReference reference = this.getServiceReference();
        if (reference != null) {
            return this.getService(reference);
        }
        return null;
    }

    public void remove(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(reference);
    }

    public int size() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return 0;
        }
        return tracked.size();
    }

    public int getTrackingCount() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return -1;
        }
        return tracked.getTrackingCount();
    }

    static class Tracked
    extends Hashtable
    implements ServiceListener {
        private ServiceTrackerCustomizer customizer;
        private Filter filter;
        private Vector adding;
        private boolean closed;
        private int trackingCount;

        protected Tracked(ServiceTrackerCustomizer customizer, Filter filter) {
            this.customizer = customizer;
            this.filter = filter;
            this.closed = false;
            this.trackingCount = 0;
            this.adding = new Vector(10, 10);
        }

        protected void close() {
            this.closed = true;
        }

        protected int getTrackingCount() {
            return this.trackingCount;
        }

        public void serviceChanged(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (this.filter.match(reference)) {
                        this.track(reference);
                        break;
                    }
                    this.untrack(reference);
                    break;
                }
                case 4: {
                    this.untrack(reference);
                }
            }
        }

        /*
         * Exception decompiling
         */
        protected void track(ServiceReference reference) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 142->145)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void untrack(ServiceReference reference) {
            Object object;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.adding.removeElement(reference)) {
                    return;
                }
                object = this.remove(reference);
                if (object == null) {
                    return;
                }
                ++this.trackingCount;
            }
            this.customizer.removedService(reference, object);
        }
    }
}

