/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.framework.internal.protocol.NullURLStreamHandlerService;
import org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerSetter;
import org.eclipse.osgi.framework.tracker.ServiceTracker;
import org.eclipse.osgi.framework.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

public class URLStreamHandlerProxy
extends URLStreamHandler
implements ServiceTrackerCustomizer {
    protected URLStreamHandlerService realHandlerService;
    protected URLStreamHandlerSetter urlSetter;
    protected ServiceTracker urlStreamHandlerServiceTracker;
    protected boolean handlerRegistered = true;
    protected BundleContext context;
    protected ServiceReference urlStreamServiceReference;
    protected String protocol;
    protected int ranking = -1;

    public URLStreamHandlerProxy(String protocol, ServiceReference reference, BundleContext context) {
        this.context = context;
        this.protocol = protocol;
        this.urlSetter = new URLStreamHandlerSetter(this);
        Object property = reference.getProperty("service.ranking");
        this.ranking = property instanceof Integer ? (Integer)property : 0;
        this.realHandlerService = (URLStreamHandlerService)context.getService(reference);
        this.urlStreamServiceReference = reference;
        this.urlStreamHandlerServiceTracker = new ServiceTracker(context, "org.osgi.service.url.URLStreamHandlerService", (ServiceTrackerCustomizer)this);
        this.urlStreamHandlerServiceTracker.open();
    }

    private void setNewHandler(ServiceReference reference, int rank) {
        this.urlStreamServiceReference = reference;
        this.ranking = rank;
        this.realHandlerService = (URLStreamHandlerService)this.context.getService(reference);
    }

    protected boolean equals(URL url1, URL url2) {
        return this.realHandlerService.equals(url1, url2);
    }

    protected int getDefaultPort() {
        return this.realHandlerService.getDefaultPort();
    }

    protected InetAddress getHostAddress(URL url) {
        return this.realHandlerService.getHostAddress(url);
    }

    protected int hashCode(URL url) {
        return this.realHandlerService.hashCode(url);
    }

    protected boolean hostsEqual(URL url1, URL url2) {
        return this.realHandlerService.hostsEqual(url1, url2);
    }

    protected URLConnection openConnection(URL url) throws IOException {
        return this.realHandlerService.openConnection(url);
    }

    protected void parseURL(URL url, String str, int start, int end) {
        this.realHandlerService.parseURL((org.osgi.service.url.URLStreamHandlerSetter)this.urlSetter, url, str, start, end);
    }

    protected boolean sameFile(URL url1, URL url2) {
        return this.realHandlerService.sameFile(url1, url2);
    }

    protected String toExternalForm(URL url) {
        return this.realHandlerService.toExternalForm(url);
    }

    public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String file, String query, String ref) {
        super.setURL(u, protocol, host, port, authority, userInfo, file, query, ref);
    }

    public void setURL(URL url, String protocol, String host, int port, String file, String ref) {
        super.setURL(url, protocol, host, port, null, null, file, null, ref);
    }

    public Object addingService(ServiceReference reference) {
        String[] protocols = (String[])reference.getProperty("url.handler.protocol");
        int i = 0;
        while (i < protocols.length) {
            if (protocols[i].equals(this.protocol)) {
                int newServiceRanking;
                Object property = reference.getProperty("service.ranking");
                int n = newServiceRanking = property instanceof Integer ? (Integer)property : 0;
                if (!this.handlerRegistered) {
                    this.setNewHandler(reference, newServiceRanking);
                    this.handlerRegistered = true;
                }
                if (newServiceRanking > this.ranking) {
                    this.setNewHandler(reference, newServiceRanking);
                }
                return reference;
            }
            ++i;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        int newrank = this.getRank(reference);
        if (reference == this.urlStreamServiceReference) {
            ServiceReference newReference;
            if (newrank < this.ranking && (newReference = this.urlStreamHandlerServiceTracker.getServiceReference()) != this.urlStreamServiceReference && newReference != null) {
                this.setNewHandler(newReference, (Integer)newReference.getProperty("service.ranking"));
            }
        } else if (newrank > this.ranking) {
            this.setNewHandler(reference, newrank);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        if (reference == this.urlStreamServiceReference) {
            ServiceReference newReference = this.urlStreamHandlerServiceTracker.getServiceReference();
            if (newReference != null) {
                this.setNewHandler(newReference, this.getRank(newReference));
            } else {
                this.handlerRegistered = false;
                this.realHandlerService = new NullURLStreamHandlerService();
                this.ranking = -1;
            }
        }
    }

    private int getRank(ServiceReference reference) {
        return (Integer)reference.getProperty("service.ranking");
    }
}

