/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SystemBundleActivator
implements BundleActivator {
    protected BundleContext context;
    protected SystemBundle bundle;
    protected Framework framework;
    protected ServiceRegistration packageAdmin;
    protected ServiceRegistration permissionAdmin;
    protected ServiceRegistration startLevel;
    protected ServiceRegistration debugOptions;
    static /* synthetic */ Class class$0;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.bundle = (SystemBundle)context.getBundle();
        this.framework = this.bundle.framework;
        if (this.framework.packageAdmin != null) {
            this.packageAdmin = this.register("org.osgi.service.packageadmin.PackageAdmin", this.framework.packageAdmin);
        }
        if (this.framework.permissionAdmin != null) {
            this.permissionAdmin = this.register("org.osgi.service.permissionadmin.PermissionAdmin", this.framework.permissionAdmin);
        }
        if (this.framework.startLevelImpl != null) {
            this.startLevel = this.register("org.osgi.service.startlevel.StartLevel", this.framework.startLevelFactory);
        }
        DebugOptions dbgOptions = null;
        dbgOptions = DebugOptions.getDefault();
        if (dbgOptions != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.osgi.service.debug.DebugOptions;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.debugOptions = this.register(clazz.getName(), dbgOptions);
        }
        this.framework.adaptor.frameworkStart(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.framework.adaptor.frameworkStop(context);
        if (this.packageAdmin != null) {
            this.packageAdmin.unregister();
        }
        if (this.permissionAdmin != null) {
            this.permissionAdmin.unregister();
        }
        if (this.startLevel != null) {
            this.startLevel.unregister();
        }
        if (this.debugOptions != null) {
            this.debugOptions.unregister();
        }
        this.framework = null;
        this.bundle = null;
        this.context = null;
    }

    protected ServiceRegistration register(String name, Object service) {
        Hashtable properties = new Hashtable(7);
        Dictionary headers = this.bundle.getHeaders();
        properties.put("service.vendor", headers.get("Bundle-Vendor"));
        properties.put("service.ranking", new Integer(Integer.MAX_VALUE));
        properties.put("service.pid", String.valueOf(this.bundle.getBundleId()) + "." + service.getClass().getName());
        return this.context.registerService(name, service, properties);
    }
}

