/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.Hashtable;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.SystemBundleData;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.BundleException;

public class SystemBundle
extends BundleHost {
    protected SystemBundle(Headers manifest, Framework framework) throws BundleException {
        this(new SystemBundleData(manifest), "System Bundle", framework);
    }

    private SystemBundle(BundleData bundledata, String location, Framework framework) throws BundleException {
        super(bundledata, location, framework, 0);
        this.state = 8;
        this.context = this.createContext();
    }

    public BundleLoader getBundleLoader() {
        if (this.loader == null) {
            SystemBundle systemBundle = this;
            synchronized (systemBundle) {
                if (this.loader == null) {
                    try {
                        this.loader = new SystemBundleLoader(this, this.getBundleDescription());
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }
        return this.loader;
    }

    protected void load() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.domain = this.getClass().getProtectionDomain();
        }
    }

    protected boolean reload(Bundle newBundle) throws BundleException {
        return false;
    }

    protected void refresh() throws BundleException {
    }

    protected boolean unload() {
        return false;
    }

    protected void close() {
        this.context.close();
        this.context = null;
        this.state = 1;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            this.framework.checkAdminPermission();
            this.checkValid();
        }
        return Class.forName(name);
    }

    public URL getResource(String name) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    public void start() throws BundleException {
        this.framework.checkAdminPermission();
    }

    protected void resume() throws BundleException {
        this.framework.startLevelImpl.initialize();
        this.framework.startLevelImpl.launch(this.framework.startLevelImpl.getFrameworkStartLevel());
    }

    public void stop() throws BundleException {
        this.framework.checkAdminPermission();
        if (this.state == 32) {
            Thread shutdown = this.framework.createThread(new Runnable(){

                public void run() {
                    SystemBundle.this.framework.shutdown();
                }
            }, "System Bundle Shutdown");
            shutdown.start();
        }
    }

    protected void suspend() throws BundleException {
        this.framework.startLevelImpl.shutdown();
        this.framework.startLevelImpl.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
    }

    public void update() throws BundleException {
        this.framework.checkAdminPermission();
        if (this.state == 32) {
            Thread restart = this.framework.createThread(new Runnable(){

                public void run() {
                    SystemBundle.this.framework.shutdown();
                    SystemBundle.this.framework.launch();
                }
            }, "System Bundle Update");
            restart.start();
        }
    }

    public void update(InputStream in) throws BundleException {
        this.update();
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public void uninstall() throws BundleException {
        this.framework.checkAdminPermission();
        throw new BundleException(Msg.formatter.getString("BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION"));
    }

    public boolean hasPermission(Object permission) {
        if (this.domain != null) {
            if (permission instanceof Permission) {
                return this.domain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    protected void unresolvePermissions(Hashtable unresolvedPackages) {
    }
}

