/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleCombinedPermissions;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundlePermissions;
import org.eclipse.osgi.framework.internal.core.BundleResourcePermission;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.UnresolvedPermission;
import org.eclipse.osgi.framework.security.action.PermissionStorage;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionAdmin
implements org.osgi.service.permissionadmin.PermissionAdmin {
    protected Framework framework;
    protected org.eclipse.osgi.framework.adaptor.PermissionStorage storage;
    protected PermissionInfo[] defaultDefaultPermissionInfos;
    protected PermissionInfo[] baseImpliedPermissionInfos;
    protected BundleCombinedPermissions defaultAssignedPermissions;

    protected PermissionAdmin(Framework framework, org.eclipse.osgi.framework.adaptor.PermissionStorage storage) {
        this.framework = framework;
        this.storage = storage;
        this.defaultDefaultPermissionInfos = this.getPermissionInfos("default.permissions");
        this.baseImpliedPermissionInfos = this.getPermissionInfos("implied.permissions");
        if (Debug.DEBUG_SECURITY) {
            int i;
            Debug.println("Default default assigned bundle permissions");
            if (this.defaultDefaultPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                i = 0;
                while (i < this.defaultDefaultPermissionInfos.length) {
                    Debug.println("  " + this.defaultDefaultPermissionInfos[i]);
                    ++i;
                }
            }
            Debug.println("Base implied bundle permissions");
            if (this.baseImpliedPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                i = 0;
                while (i < this.baseImpliedPermissionInfos.length) {
                    Debug.println("  " + this.baseImpliedPermissionInfos[i]);
                    ++i;
                }
            }
        }
        this.defaultAssignedPermissions = new BundleCombinedPermissions(null);
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(this.getDefaultPermissions()));
    }

    public PermissionInfo[] getPermissions(String location) {
        if (location == null) {
            throw new NullPointerException();
        }
        PermissionStorage storage = new PermissionStorage(this.storage);
        try {
            String[] data = storage.getPermissionData(location);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting permissions for location: " + location);
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            return this.makePermissionInfo(data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public void setPermissions(String location, PermissionInfo[] permissions) {
        ProtectionDomain domain;
        this.framework.checkAdminPermission();
        if (location == null) {
            throw new NullPointerException();
        }
        PermissionStorage storage = new PermissionStorage(this.storage);
        try {
            String[] data = this.makePermissionData(permissions);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting permissions for location: " + location);
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            storage.setPermissionData(location, data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return;
        }
        Bundle bundle = this.framework.getBundleByLocation(location);
        if (bundle != null && bundle.getBundleId() != 0L && (domain = bundle.getProtectionDomain()) != null) {
            BundleCombinedPermissions combined = (BundleCombinedPermissions)domain.getPermissions();
            if (permissions == null) {
                combined.setAssignedPermissions(this.defaultAssignedPermissions);
            } else {
                combined.setAssignedPermissions(this.createPermissions(permissions, bundle));
            }
        }
    }

    public String[] getLocations() {
        PermissionStorage storage = new PermissionStorage(this.storage);
        try {
            String[] locations = storage.getLocations();
            return locations;
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public PermissionInfo[] getDefaultPermissions() {
        PermissionStorage storage = new PermissionStorage(this.storage);
        try {
            String[] data = storage.getPermissionData(null);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting default permissions");
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            return this.makePermissionInfo(data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public void setDefaultPermissions(PermissionInfo[] permissions) {
        this.framework.checkAdminPermission();
        PermissionStorage storage = new PermissionStorage(this.storage);
        try {
            String[] data = this.makePermissionData(permissions);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting default permissions");
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            storage.setPermissionData(null, data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return;
        }
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(permissions));
    }

    protected PermissionInfo[] makePermissionInfo(String[] data) {
        if (data == null) {
            return null;
        }
        int size = data.length;
        PermissionInfo[] permissions = new PermissionInfo[size];
        int i = 0;
        while (i < size) {
            permissions[i] = new PermissionInfo(data[i]);
            ++i;
        }
        return permissions;
    }

    protected String[] makePermissionData(PermissionInfo[] permissions) {
        if (permissions == null) {
            return null;
        }
        int size = permissions.length;
        String[] data = new String[size];
        int i = 0;
        while (i < size) {
            data[i] = permissions[i].getEncoded();
            ++i;
        }
        return data;
    }

    protected PermissionCollection createPermissionCollection(Bundle bundle) {
        BundlePermissionCollection implied = this.getImpliedPermissions(bundle);
        BundleCombinedPermissions combined = new BundleCombinedPermissions(implied);
        BundlePermissionCollection assigned = this.getAssignedPermissions(bundle);
        combined.setAssignedPermissions(assigned);
        return combined;
    }

    protected BundlePermissionCollection createDefaultAssignedPermissions(PermissionInfo[] info) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating default assigned permissions");
        }
        if (info == null) {
            info = this.defaultDefaultPermissionInfos;
        }
        return this.createPermissions(info, null);
    }

    protected BundlePermissionCollection getAssignedPermissions(Bundle bundle) {
        String location = bundle.getLocation();
        PermissionInfo[] info = this.getPermissions(location);
        if (info == null) {
            return this.defaultAssignedPermissions;
        }
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating assigned permissions for " + bundle);
        }
        return this.createPermissions(info, bundle);
    }

    protected BundlePermissionCollection getImpliedPermissions(Bundle bundle) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating implied permissions for " + bundle);
        }
        BundlePermissionCollection collection = this.createPermissions(this.baseImpliedPermissionInfos, bundle);
        BundleResourcePermission permission = new BundleResourcePermission(bundle.getBundleId());
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Created permission: " + permission);
        }
        collection.add(permission);
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PermissionInfo[] getPermissionInfos(String resource) {
        Object[] info = null;
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) return info;
        try {
            block15: {
                int size;
                BufferedReader reader;
                Vector<PermissionInfo> permissions;
                try {
                    permissions = new Vector<PermissionInfo>();
                    try {
                        reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        reader = new BufferedReader(new InputStreamReader(in));
                    }
                }
                catch (IOException iOException) {
                }
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        size = permissions.size();
                        if (size > 0) {
                            break;
                        }
                        break block15;
                    }
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                    try {
                        permissions.addElement(new PermissionInfo(line));
                    }
                    catch (IllegalArgumentException iae) {
                        this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iae);
                    }
                }
                info = new PermissionInfo[size];
                permissions.copyInto(info);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return info;
        }
        in.close();
        return info;
    }

    protected BundlePermissionCollection createPermissions(PermissionInfo[] info, Bundle bundle) {
        BundlePermissions collection = new BundlePermissions(this.framework.packageAdmin);
        int size = info.length;
        int i = 0;
        while (i < size) {
            block4: {
                PermissionInfo perm;
                block3: {
                    File target;
                    File file;
                    String name;
                    perm = info[i];
                    String type = perm.getType();
                    if (!type.equals("java.io.FilePermission") || (name = perm.getName()).equals("<<ALL FILES>>") || (file = new File(name)).isAbsolute()) break block3;
                    if (bundle == null || (target = this.framework.getDataFile(bundle, name)) == null) break block4;
                    perm = new PermissionInfo(type, target.getPath(), perm.getActions());
                }
                ((PermissionCollection)collection).add(this.createPermission(perm));
            }
            ++i;
        }
        return collection;
    }

    protected Permission createPermission(PermissionInfo info) {
        String type = info.getType();
        String name = info.getName();
        String actions = info.getActions();
        UnresolvedPermission permission = new UnresolvedPermission(type, name, actions);
        try {
            Class<?> clazz = Class.forName(type);
            Permission resolved = permission.resolve(clazz);
            if (resolved != null) {
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("Created permission: " + resolved);
                }
                return resolved;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Created permission: " + permission);
        }
        return permission;
    }
}

