/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.ExportedPackage;

public class PackageAdmin
implements org.osgi.service.packageadmin.PackageAdmin {
    protected Framework framework;
    protected Vector removalPending;
    protected KeyedHashSet exportedPackages;
    protected KeyedHashSet exportedBundles;
    private long cumulativeTime;

    protected PackageAdmin(Framework framework) {
        this.framework = framework;
    }

    protected void initialize() {
        this.removalPending = new Vector(10, 10);
        State state = this.framework.adaptor.getState();
        if (!state.isResolved()) {
            state.resolve(false);
        }
        this.exportedPackages = new KeyedHashSet(false);
        this.exportedPackages = this.getExportedPackages(this.exportedPackages);
        this.exportedBundles = new KeyedHashSet(false);
        this.exportedBundles = this.getExportedBundles(this.exportedBundles);
    }

    private KeyedHashSet getExportedPackages(KeyedHashSet packageSet) {
        State state = this.framework.adaptor.getState();
        PackageSpecification[] packageSpecs = state.getExportedPackages();
        int i = 0;
        while (i < packageSpecs.length) {
            BundleDescription bundleSpec = packageSpecs[i].getSupplier();
            if (bundleSpec != null) {
                BundleHost bundle;
                HostSpecification hostSpec = bundleSpec.getHost();
                if (hostSpec != null) {
                    bundleSpec = hostSpec.getSupplier();
                }
                if ((bundle = (BundleHost)this.framework.getBundle(bundleSpec.getBundleId())) != null) {
                    ExportedPackageImpl packagesource = new ExportedPackageImpl(packageSpecs[i], bundle.getLoaderProxy());
                    packageSet.add(packagesource);
                }
            }
            ++i;
        }
        return packageSet;
    }

    private KeyedHashSet getExportedBundles(KeyedHashSet bundleSet) {
        State state = this.framework.adaptor.getState();
        BundleDescription[] bundleDescripts = state.getResolvedBundles();
        int i = 0;
        while (i < bundleDescripts.length) {
            BundleHost bundle;
            BundleDescription bundledes = bundleDescripts[i];
            HostSpecification hostSpec = bundledes.getHost();
            if (hostSpec != null) {
                bundledes = hostSpec.getSupplier();
            }
            if ((bundle = (BundleHost)this.framework.getBundle(bundledes.getBundleId())) != null && bundle instanceof BundleHost) {
                BundleLoaderProxy loaderProxy = bundle.getLoaderProxy();
                bundleSet.add(loaderProxy);
            }
            ++i;
        }
        return bundleSet;
    }

    protected void cleanup() {
        this.removalPending = null;
        this.exportedPackages = null;
        this.exportedBundles = null;
    }

    protected void addRemovalPending(BundleLoaderProxy loaderProxy) {
        this.removalPending.addElement(loaderProxy);
    }

    protected void deleteRemovalPending(BundleLoaderProxy loaderProxy) throws BundleException {
        boolean exporting = loaderProxy.inUse();
        if (exporting) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("BundleLoader.unexportPackager returned true! " + loaderProxy);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            throw new BundleException(Msg.formatter.getString("OSGI_INTERNAL_ERROR"));
        }
        this.unexportResources(loaderProxy);
        BundleLoader loader = loaderProxy.getBundleLoader();
        loader.clear();
        loader.close();
        this.removalPending.remove(loaderProxy);
    }

    public ExportedPackage[] getExportedPackages(org.osgi.framework.Bundle bundle) {
        this.framework.bundles.markDependancies();
        KeyedElement[] elements = this.exportedPackages.elements();
        if (bundle != null) {
            Vector<ExportedPackageImpl> result = new Vector<ExportedPackageImpl>();
            int i = 0;
            while (i < elements.length) {
                ExportedPackageImpl pkgElement = (ExportedPackageImpl)elements[i];
                if (pkgElement.supplier.getBundle() == bundle) {
                    result.add(pkgElement);
                }
                ++i;
            }
            if (result.size() == 0) {
                return null;
            }
            ExportedPackageImpl[] pkgElements = new ExportedPackageImpl[result.size()];
            return result.toArray(pkgElements);
        }
        if (elements.length == 0) {
            return null;
        }
        ExportedPackage[] pkgElements = new ExportedPackageImpl[elements.length];
        System.arraycopy(elements, 0, pkgElements, 0, pkgElements.length);
        return pkgElements;
    }

    public ExportedPackage getExportedPackage(String packageName) {
        this.framework.bundles.markDependancies();
        return (ExportedPackageImpl)this.exportedPackages.getByKey(packageName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(org.osgi.framework.Bundle[] input) {
        this.framework.checkAdminPermission();
        Bundle[] copy = null;
        if (input != null) {
            org.osgi.framework.Bundle[] bundleArray = input;
            // MONITORENTER : input
            int size = input.length;
            copy = new Bundle[size];
            System.arraycopy(input, 0, copy, 0, size);
            // MONITOREXIT : bundleArray
        }
        final Bundle[] bundles = copy;
        Thread refresh = this.framework.createThread(new Runnable(){

            public void run() {
                PackageAdmin.this.refreshPackages(bundles);
            }
        }, "Refresh Packages");
        refresh.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshPackages(Bundle[] refresh) {
        try {
            Vector graph = null;
            BundleRepository bundleRepository = this.framework.bundles;
            synchronized (bundleRepository) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: Initialize graph");
                }
                this.framework.bundles.markDependancies();
                graph = this.computeAffectedBundles(refresh);
                State state = this.framework.adaptor.getState();
                state.resolve(false);
                this.processDelta(graph);
            }
            this.resumeBundles(graph);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            return;
        }
    }

    private void resumeBundles(Vector graph) {
        Object[] refresh = new Bundle[graph.size()];
        boolean[] cfr_ignored_0 = new boolean[graph.size()];
        graph.copyInto(refresh);
        Util.sort(refresh, 0, graph.size());
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: restart the bundles");
        }
        int i = 0;
        while (i < refresh.length) {
            Object bundle = refresh[i];
            if (((Bundle)bundle).isResolved() && !((Bundle)bundle).isFragment()) {
                this.framework.resumeBundle((Bundle)bundle);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processDelta(Vector graph) {
        refresh = new Bundle[graph.size()];
        previouslyResolved = new boolean[graph.size()];
        graph.copyInto(refresh);
        Util.sort(refresh, 0, graph.size());
        notify = new Vector<Object>();
        try {
            block37: {
                try {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                    }
                    i = refresh.length - 1;
                    while (i >= 0) {
                        changedBundle = refresh[i];
                        previouslyResolved[i] = changedBundle.isResolved();
                        if (changedBundle.isActive() && !changedBundle.isFragment()) {
                            suspended = this.framework.suspendBundle((Bundle)changedBundle, true);
                            if (!suspended) {
                                throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION"));
                            }
                        } else {
                            changedBundle.beginStateChange();
                        }
                        if (Debug.DEBUG_PACKAGEADMIN && changedBundle.stateChanging == null) {
                            Debug.println("Bundle state change lock is clear! " + changedBundle);
                            Debug.printStackTrace(new Exception("Stack trace"));
                        }
                        --i;
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: refresh the bundles");
                    }
                    i = this.removalPending.size() - 1;
                    while (i >= 0) {
                        loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                        if (graph.contains(loaderProxy.getBundle())) {
                            this.framework.bundles.unMarkDependancies(loaderProxy);
                        }
                        --i;
                    }
                    i = 0;
                    while (i < refresh.length) {
                        changedBundle = refresh[i];
                        changedBundle.refresh();
                        ++i;
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: unexport the removal pending packages");
                    }
                    i = this.removalPending.size() - 1;
                    while (i >= 0) {
                        loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                        removedBundle = loaderProxy.getBundle();
                        if (graph.contains(removedBundle)) {
                            this.deleteRemovalPending(loaderProxy);
                        }
                        --i;
                    }
                    this.exportedPackages = this.getExportedPackages(this.exportedPackages);
                    this.exportedBundles = this.getExportedBundles(this.exportedBundles);
                    i = 0;
                    while (i < refresh.length) {
                        changedBundle = refresh[i];
                        bundleDes = changedBundle.getBundleDescription();
                        if (bundleDes != null) {
                            if (bundleDes.isResolved()) {
                                if (changedBundle.isFragment()) {
                                    host = (BundleHost)this.framework.getBundle(bundleDes.getHost().getSupplier().getBundleId());
                                    if (((BundleFragment)changedBundle).setHost(host) && !changedBundle.isActive()) {
                                        changedBundle.resolve();
                                    }
                                } else {
                                    changedBundle.resolve();
                                }
                                if (!previouslyResolved[i]) {
                                    notify.addElement(changedBundle);
                                }
                            } else if (previouslyResolved[i]) {
                                notify.addElement(changedBundle);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable var10_14) {
                    var9_15 = null;
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    i = 0;
                    if (true) ** GOTO lbl113
                }
                {
                    var9_16 = null;
                    if (!Debug.DEBUG_PACKAGEADMIN) break block37;
                }
                Debug.println("refreshPackages: release the state change locks");
            }
            i = 0;
            while (true) {
                if (i >= refresh.length) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: clean up adaptor storage");
                    }
                    ** try [egrp 3[TRYBLOCK] [2 : 595->610)] { 
lbl89:
                    // 1 sources

                    break;
                }
                changedBundle = refresh[i];
                changedBundle.completeStateChange();
                ++i;
            }
            {
                this.framework.adaptor.compactStorage();
            }
lbl96:
            // 1 sources

            catch (IOException e) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages exception: " + e.getMessage());
                    Debug.printStackTrace(e);
                }
                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), (Throwable)e));
            }
        }
        catch (BundleException e) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + e.getMessage());
                Debug.printStackTrace(e.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), (Throwable)e));
        }
        i = 0;
        if (true) ** GOTO lbl118
        do {
            changedBundle = refresh[i];
            changedBundle.completeStateChange();
            ++i;
lbl113:
            // 2 sources

        } while (i < refresh.length);
        throw var10_14;
        do {
            this.framework.publishBundleEvent((changedBundle = (Bundle)notify.elementAt(i)).isResolved() != false ? 32 : 64, (org.osgi.framework.Bundle)changedBundle);
            ++i;
lbl118:
            // 2 sources

        } while (i < notify.size());
    }

    private void unresolvePermissions(Vector bundles, Hashtable packages) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: unresolve permissions");
        }
        int size = bundles.size();
        int i = 0;
        while (i < size) {
            Bundle bundle = (Bundle)bundles.elementAt(i);
            bundle.unresolvePermissions(packages);
            ++i;
        }
    }

    private Vector computeAffectedBundles(Bundle[] refresh) {
        boolean changed;
        Bundle bundle;
        Vector<org.osgi.framework.Bundle> graph = new Vector<org.osgi.framework.Bundle>();
        if (refresh == null) {
            int size = this.removalPending.size();
            int i = 0;
            while (i < size) {
                BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                bundle = loaderProxy.getBundle();
                if (!graph.contains(bundle)) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println(" refresh: " + bundle);
                    }
                    graph.addElement(bundle);
                    Bundle[] dependents = loaderProxy.getDependentBundles();
                    int j = 0;
                    while (j < dependents.length) {
                        if (!graph.contains(dependents[j])) {
                            graph.addElement(dependents[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < refresh.length) {
                Bundle bundle2 = refresh[i];
                if (bundle2 != this.framework.systemBundle) {
                    BundleHost host;
                    if (bundle2.isFragment() && (host = (BundleHost)bundle2.getHost()) != null && !graph.contains(host)) {
                        graph.addElement(host);
                    }
                    if (!graph.contains(bundle2)) {
                        if (Debug.DEBUG_PACKAGEADMIN) {
                            Debug.println(" refresh: " + bundle2);
                        }
                        graph.addElement(bundle2);
                    }
                }
                ++i;
            }
        }
        if (graph.size() == 0) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages: Empty graph");
            }
            return graph;
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: Complete graph");
        }
        do {
            changed = false;
            int size = graph.size();
            int i = size - 1;
            while (i >= 0) {
                bundle = (Bundle)graph.elementAt(i);
                if (!bundle.isFragment()) {
                    org.osgi.framework.Bundle[] frags;
                    int j;
                    BundleLoaderProxy loaderProxy = ((BundleHost)bundle).getLoaderProxy();
                    if (loaderProxy != null) {
                        Bundle[] dependents = loaderProxy.getDependentBundles();
                        j = 0;
                        while (j < dependents.length) {
                            if (!graph.contains(dependents[j])) {
                                graph.addElement(dependents[j]);
                                changed = true;
                            }
                            ++j;
                        }
                    }
                    if ((frags = bundle.getFragments()) != null) {
                        j = 0;
                        while (j < frags.length) {
                            if (!graph.contains(frags[j])) {
                                graph.addElement(frags[j]);
                                changed = true;
                            }
                            ++j;
                        }
                    }
                } else {
                    Bundle host = (Bundle)bundle.getHost();
                    if (host != null && !graph.contains(host)) {
                        graph.addElement(host);
                        changed = true;
                    }
                }
                --i;
            }
            i = this.removalPending.size() - 1;
            while (i >= 0) {
                BundleLoaderProxy removedLoaderProxy = (BundleLoaderProxy)this.removalPending.elementAt(i);
                Bundle removedBundle = removedLoaderProxy.getBundle();
                if (graph.contains(removedBundle)) {
                    Bundle[] dependents = removedLoaderProxy.getDependentBundles();
                    int k = 0;
                    while (k < dependents.length) {
                        if (!graph.contains(dependents[k])) {
                            graph.addElement(dependents[k]);
                            changed = true;
                        }
                        ++k;
                    }
                }
                --i;
            }
        } while (changed);
        return graph;
    }

    protected void setResolvedBundles() {
        State state = this.framework.adaptor.getState();
        BundleDescription[] descriptions = state.getBundles();
        int i = 0;
        while (i < descriptions.length) {
            long bundleId = descriptions[i].getBundleId();
            Bundle bundle = this.framework.getBundle(bundleId);
            if (bundle != null && bundle != this.framework.systemBundle && descriptions[i].isResolved()) {
                if (bundle.isFragment()) {
                    BundleHost host = (BundleHost)this.framework.getBundle(descriptions[i].getHost().getSupplier().getBundleId());
                    if (((BundleFragment)bundle).setHost(host)) {
                        bundle.resolve();
                    }
                } else {
                    bundle.resolve();
                }
            }
            ++i;
        }
    }

    protected void resolveBundles() {
        long start = 0L;
        if (Debug.DEBUG_PACKAGEADMIN_TIMING) {
            start = System.currentTimeMillis();
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: resolve bundles");
        }
        State state = this.framework.adaptor.getState();
        state.resolve(false);
        Vector<Bundle> notify = new Vector<Bundle>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.framework.bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                Bundle bundle = (Bundle)allBundles.get(i);
                BundleDescription changedBundleDes = bundle.getBundleDescription();
                boolean previouslyResolved = bundle.isResolved();
                if (bundle != this.framework.systemBundle && changedBundleDes != null) {
                    if (changedBundleDes.isResolved() && !previouslyResolved) {
                        if (bundle.isFragment()) {
                            BundleHost host = (BundleHost)this.framework.getBundle(changedBundleDes.getHost().getSupplier().getBundleId());
                            if (((BundleFragment)bundle).setHost(host)) {
                                bundle.resolve();
                                notify.add(bundle);
                            }
                        } else {
                            bundle.resolve();
                            notify.add(bundle);
                        }
                    } else if (!changedBundleDes.isResolved() && previouslyResolved) {
                        this.framework.publishFrameworkEvent(2, bundle, new BundleException(Msg.formatter.getString("STATE_UNRESOLVED_WRONG_BUNDLE", bundle.getLocation())));
                    }
                } else if (bundle != this.framework.systemBundle) {
                    this.framework.publishFrameworkEvent(2, bundle, new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_STATE", bundle.getLocation())));
                }
                ++i;
            }
            this.exportedPackages = this.getExportedPackages(this.exportedPackages);
            this.exportedBundles = this.getExportedBundles(this.exportedBundles);
        }
        int i = 0;
        while (i < notify.size()) {
            Bundle bundle = (Bundle)notify.elementAt(i);
            if (bundle != null) {
                this.framework.publishBundleEvent(bundle.isResolved() ? 32 : 64, bundle);
            }
            ++i;
        }
        if (Debug.DEBUG_PACKAGEADMIN_TIMING) {
            this.cumulativeTime = this.cumulativeTime + System.currentTimeMillis() - start;
            DebugOptions.getDefault().setOption("debug.packageadmin/timing/value", Long.toString(this.cumulativeTime));
        }
    }

    protected void unexportResources(BundleLoaderProxy proxy) {
        KeyedElement[] bundles = this.exportedBundles.elements();
        int i = 0;
        while (i < bundles.length) {
            BundleLoaderProxy loaderProxy = (BundleLoaderProxy)bundles[i];
            if (loaderProxy == proxy) {
                this.exportedBundles.remove(proxy);
            }
            ++i;
        }
        KeyedElement[] packages = this.exportedPackages.elements();
        int i2 = 0;
        while (i2 < packages.length) {
            PackageSource source = (PackageSource)packages[i2];
            BundleLoaderProxy sourceProxy = source.getSupplier();
            if (sourceProxy == proxy) {
                this.exportedPackages.remove(source);
            }
            ++i2;
        }
        proxy.setStale();
    }

    protected BundleDescription[] getBundleDescriptions(Vector graph) {
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>();
        int size = graph.size();
        int i = 0;
        while (i < size) {
            Bundle bundle = (Bundle)graph.elementAt(i);
            BundleDescription bundleDes = bundle.getBundleDescription();
            if (bundleDes != null) {
                result.add(bundleDes);
            }
            ++i;
        }
        return result.toArray(new BundleDescription[result.size()]);
    }
}

