/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.EventQueue;
import org.eclipse.osgi.framework.eventmgr.EventSource;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleContext;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleNativeCode;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.Filter;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdmin;
import org.eclipse.osgi.framework.internal.core.PermissionAdmin;
import org.eclipse.osgi.framework.internal.core.ServiceReference;
import org.eclipse.osgi.framework.internal.core.StartLevelFactory;
import org.eclipse.osgi.framework.internal.core.StartLevelImpl;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.security.action.CreateThread;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServicePermission;

public class Framework
implements EventSource,
EventPublisher {
    protected FrameworkAdaptor adaptor;
    protected Properties properties;
    protected boolean active;
    protected BundleRepository bundles;
    protected PackageAdmin packageAdmin;
    protected PermissionAdmin permissionAdmin;
    protected StartLevelImpl startLevelImpl;
    protected StartLevelFactory startLevelFactory;
    protected ServiceRegistry serviceRegistry;
    protected long serviceid;
    protected EventListeners bundleEvent;
    protected static final int BUNDLEEVENT = 1;
    protected EventListeners bundleEventSync;
    protected static final int BUNDLEEVENTSYNC = 2;
    protected EventListeners serviceEvent;
    protected static final int SERVICEEVENT = 3;
    protected EventListeners frameworkEvent;
    protected static final int FRAMEWORKEVENT = 4;
    protected EventManager eventManager;
    protected Hashtable installLock;
    protected SystemBundle systemBundle;
    protected AdminPermission adminPermission;

    public Framework(FrameworkAdaptor adaptor) {
        this.initialize(adaptor);
    }

    protected void initialize(FrameworkAdaptor adaptor) {
        long start = System.currentTimeMillis();
        this.adaptor = adaptor;
        this.active = false;
        this.installSecurityManager();
        if (Debug.DEBUG_SECURITY) {
            Debug.println("SecurityManager: " + System.getSecurityManager());
            Debug.println("ProtectionDomain of Framework.class: \n" + this.getClass().getProtectionDomain());
        }
        adaptor.initialize(this);
        try {
            adaptor.initializeStorage();
            adaptor.compactStorage();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(Msg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
        this.initializeProperties(adaptor.getProperties());
        this.packageAdmin = new PackageAdmin(this);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                this.permissionAdmin = new PermissionAdmin(this, adaptor.getPermissionStorage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(Msg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
            }
        }
        this.startLevelFactory = new StartLevelFactory(this);
        this.startLevelImpl = new StartLevelImpl(this);
        this.eventManager = new EventManager("Framework Event Dispatcher");
        this.bundleEvent = new EventListeners();
        this.bundleEventSync = new EventListeners();
        this.serviceEvent = new EventListeners();
        this.frameworkEvent = new EventListeners();
        this.serviceid = 1L;
        this.serviceRegistry = adaptor.getServiceRegistry();
        this.installLock = new Hashtable(13);
        this.createSystemBundle();
        URL.setURLStreamHandlerFactory(new StreamHandlerFactory(this.systemBundle.context, adaptor));
        URLConnection.setContentHandlerFactory(new ContentHandlerFactory(this.systemBundle.context));
        Vector bundleDatas = adaptor.getInstalledBundles();
        this.bundles = new BundleRepository(bundleDatas == null ? adaptor.getVectorInitialCapacity() : bundleDatas.size() + 1, this.packageAdmin);
        this.bundles.add(this.systemBundle);
        if (bundleDatas != null) {
            int size = bundleDatas.size();
            int i = 0;
            while (i < size) {
                BundleData bundledata = (BundleData)bundleDatas.elementAt(i);
                try {
                    int absl = bundledata.getStartLevel();
                    Bundle bundle = Bundle.createBundle(bundledata, bundledata.getLocation(), this, absl);
                    this.bundles.add(bundle);
                }
                catch (BundleException be) {
                    this.publishFrameworkEvent(2, this.systemBundle, be);
                }
                ++i;
            }
        }
        this.packageAdmin.initialize();
        this.systemBundle.getBundleLoader();
        if (Debug.DEBUG_GENERAL) {
            System.out.println("Initialize the framework: " + (System.currentTimeMillis() - start));
        }
    }

    private void createSystemBundle() {
        try {
            BundleDescription newSystemBundle;
            String value;
            String resource = "/META-INF/SYSTEMBUNDLE.MF";
            InputStream in = this.getClass().getResourceAsStream(resource);
            if (Debug.DEBUG_GENERAL && in == null) {
                Debug.println("Unable to find system bundle manifest " + resource);
            }
            String exportPackages = this.adaptor.getExportPackages();
            String exportServices = this.adaptor.getExportServices();
            Headers manifest = Headers.parseManifest(in);
            if (exportPackages != null) {
                value = (String)manifest.get("Export-Package");
                value = value == null ? exportPackages : String.valueOf(value) + "," + exportPackages;
                manifest.set("Export-Package", null);
                manifest.set("Export-Package", value);
            }
            if (exportServices != null) {
                value = (String)manifest.get("Export-Service");
                value = value == null ? exportServices : String.valueOf(value) + "," + exportServices;
                manifest.set("Export-Service", null);
                manifest.set("Export-Service", value);
            }
            if ((newSystemBundle = this.adaptor.getPlatformAdmin().getFactory().createBundleDescription((Dictionary)manifest, "System Bundle", 0L)) == null) {
                throw new BundleException(Msg.formatter.getString("OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR"));
            }
            State state = this.adaptor.getState();
            BundleDescription oldSystemBundle = state.getBundle(0L);
            if (oldSystemBundle != null) {
                PackageSpecification[] oldPackages = oldSystemBundle.getPackages();
                PackageSpecification[] newPackages = newSystemBundle.getPackages();
                boolean different = false;
                if (oldPackages.length == newPackages.length) {
                    int i = 0;
                    while (i < oldPackages.length) {
                        if (oldPackages[i].getName().equals(newPackages[i].getName())) {
                            Version oldVersion = oldPackages[i].getVersionSpecification();
                            Version newVersion = newPackages[i].getVersionSpecification();
                            if (oldVersion == null) {
                                if (newVersion != null) {
                                    different = true;
                                    break;
                                }
                            } else if (!oldVersion.equals(newVersion)) {
                                different = true;
                                break;
                            }
                        } else {
                            different = true;
                            break;
                        }
                        ++i;
                    }
                } else {
                    different = true;
                }
                if (different) {
                    state.removeBundle(0L);
                    state.addBundle(newSystemBundle);
                    state.resolve(false);
                }
            } else {
                state.addBundle(newSystemBundle);
                state.resolve(false);
            }
            this.systemBundle = this.createSystemBundle(manifest);
            SystemBundleLoader.clearSystemPackages();
            PackageSpecification[] packages = newSystemBundle.getPackages();
            if (packages != null) {
                String[] systemPackages = new String[packages.length];
                int i = 0;
                while (i < packages.length) {
                    String version;
                    PackageSpecification spec = packages[i];
                    if (spec.getName().equals("org.osgi.framework") && (version = spec.getVersionSpecification().toString()) != null) {
                        this.properties.put("org.osgi.framework.version", version);
                    }
                    systemPackages[i] = spec.getName();
                    ++i;
                }
                if (System.getProperty("osgi.autoExportSystemPackages") != null) {
                    SystemBundleLoader.setSystemPackages(systemPackages);
                }
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
            throw new RuntimeException(Msg.formatter.getString("OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION", e.getMessage()));
        }
    }

    protected void initializeProperties(Properties adaptorProperties) {
        int ic;
        this.properties = System.getProperties();
        Enumeration<?> enumeration = adaptorProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (this.properties.getProperty(key) != null) continue;
            this.properties.put(key, adaptorProperties.getProperty(key));
        }
        this.properties.put("org.osgi.framework.vendor", "Eclipse");
        this.properties.put("org.osgi.framework.version", "1.2");
        this.properties.put("org.eclipse.osgi.framework.internal.core.version", "3.6.0");
        String value = this.properties.getProperty("org.osgi.framework.processor");
        if (value == null && (value = this.properties.getProperty("os.arch")) != null) {
            this.properties.put("org.osgi.framework.processor", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.name")) == null && (value = this.properties.getProperty("os.name")) != null) {
            this.properties.put("org.osgi.framework.os.name", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.version")) == null && (value = this.properties.getProperty("os.version")) != null) {
            int space = value.indexOf(32);
            if (space > 0) {
                value = value.substring(0, space);
            }
            this.properties.put("org.osgi.framework.os.version", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.windowing.system")) == null && value != null) {
            this.properties.put("org.osgi.framework.windowing.system", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.language")) == null && (value = this.properties.getProperty("user.language")) != null) {
            this.properties.put("org.osgi.framework.language", value);
            StringTokenizer tokenizer = new StringTokenizer(value, "_");
            int segments = tokenizer.countTokens();
            try {
                switch (segments) {
                    case 2: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                        break;
                    }
                    case 3: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        value = this.properties.getProperty("org.osgi.framework.executionenvironment", "");
        String j2meConfig = this.properties.getProperty("microedition.configuration");
        String j2meProfile = this.properties.getProperty("microedition.profiles");
        StringBuffer ee = new StringBuffer(value);
        if (!(j2meConfig == null || j2meConfig.length() <= 0 || j2meProfile == null || j2meProfile.length() <= 0 || (ic = value.indexOf(j2meConfig)) >= 0 && ic + j2meConfig.length() < value.length() && value.charAt(ic + j2meConfig.length()) == '/' && value.startsWith(j2meProfile, ic + j2meConfig.length() + 1))) {
            if (ee.length() > 0) {
                ee.append(",");
            }
            ee.append(j2meConfig).append('/').append(j2meProfile);
        }
        this.properties.put("org.osgi.framework.executionenvironment", ee.toString());
        value = this.properties.getProperty("org.eclipse.osgi.framework.internal.core.vm");
        if (value == null && (value = this.properties.getProperty("java.vm.name")) != null) {
            this.properties.put("org.eclipse.osgi.framework.internal.core.vm", value);
        }
        if ((value = this.properties.getProperty("org.eclipse.osgi.framework.internal.core.country")) == null && (value = this.properties.getProperty("user.region")) != null) {
            this.properties.put("org.eclipse.osgi.framework.internal.core.country", value);
        }
        if ((value = this.properties.getProperty("org.eclipse.osgi.framework.internal.core.addresslength")) == null) {
            this.properties.put("org.eclipse.osgi.framework.internal.core.addresslength", "32");
        } else if (!value.equals("32") && !value.equals("64")) {
            System.err.println(Msg.formatter.getString("PROPERTIES_INVALID_ADDRESSLENGTH", value));
        }
        value = this.properties.getProperty("org.eclipse.osgi.framework.internal.core.endian");
        if (value == null) {
            this.properties.put("org.eclipse.osgi.framework.internal.core.endian", "le");
        } else if (!value.equalsIgnoreCase("le") && !value.equalsIgnoreCase("be")) {
            System.err.println(Msg.formatter.getString("PROPERTIES_INVALID_ENDIAN", value));
        }
        value = this.properties.getProperty("org.eclipse.osgi.framework.internal.core.impltype");
        if (value == null) {
            value = this.properties.getProperty("com.ibm.oti.configuration");
            if (value != null) {
                if (value.equals("foun")) {
                    this.properties.put("org.eclipse.osgi.framework.internal.core.impltype", "JCL_Foundation_1_3");
                } else if (value.equals("max")) {
                    this.properties.put("org.eclipse.osgi.framework.internal.core.impltype", "JCL_Max_1_3");
                } else if (value.equals("rm") || value.equals("gwp")) {
                    this.properties.put("org.eclipse.osgi.framework.internal.core.impltype", "JCL_GatewayPlus_1_3");
                } else {
                    this.properties.put("org.eclipse.osgi.framework.internal.core.impltype", "");
                }
            } else {
                this.properties.put("org.eclipse.osgi.framework.internal.core.impltype", "");
            }
        }
    }

    protected boolean isActive() {
        return this.active;
    }

    public synchronized void close() {
        if (this.active) {
            this.shutdown();
        }
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                Bundle bundle = (Bundle)allBundles.get(i);
                bundle.close();
                ++i;
            }
            this.bundles.removeAllBundles();
        }
        this.serviceRegistry = null;
        if (this.bundleEvent != null) {
            this.bundleEvent.removeAllListeners();
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.bundleEventSync.removeAllListeners();
            this.bundleEventSync = null;
        }
        if (this.serviceEvent != null) {
            this.serviceEvent.removeAllListeners();
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.frameworkEvent.removeAllListeners();
            this.frameworkEvent = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        this.permissionAdmin = null;
        this.packageAdmin = null;
        this.adaptor = null;
    }

    public synchronized void launch() {
        if (this.active) {
            return;
        }
        this.active = true;
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to launch framework");
            }
            this.systemBundle.resume();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Framework launch exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, this.systemBundle, be);
        }
    }

    public synchronized void shutdown() {
        if (!this.active) {
            return;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to shutdown Framework");
            }
            this.systemBundle.suspend();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Framework shutdown exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, this.systemBundle, be);
        }
        try {
            this.adaptor.compactStorage();
        }
        catch (IOException e) {
            this.publishFrameworkEvent(2, this.systemBundle, e);
        }
        this.active = false;
    }

    public Bundle createBundle(BundleData bundledata, String location, int startlevel) throws BundleException {
        this.verifyExecutionEnvironment(bundledata.getManifest());
        return Bundle.createBundle(bundledata, location, this, startlevel);
    }

    protected SystemBundle createSystemBundle(Headers manifest) throws BundleException {
        return new SystemBundle(manifest, this);
    }

    protected boolean verifyExecutionEnvironment(Dictionary manifest) throws BundleException {
        int i;
        String headerValue = (String)manifest.get("Bundle-RequiredExecutionEnvironment");
        if (headerValue == null) {
            return true;
        }
        ManifestElement[] bundleRequiredEE = ManifestElement.parseBasicCommaSeparation("Bundle-RequiredExecutionEnvironment", headerValue);
        if (bundleRequiredEE.length == 0) {
            return true;
        }
        String systemEE = System.getProperty("org.osgi.framework.executionenvironment");
        if (systemEE != null) {
            ManifestElement[] systemEEs = ManifestElement.parseBasicCommaSeparation("Bundle-RequiredExecutionEnvironment", systemEE);
            i = 0;
            while (i < systemEEs.length) {
                int j = 0;
                while (j < bundleRequiredEE.length) {
                    if (systemEEs[i].getValue().equals(bundleRequiredEE[j].getValue())) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        StringBuffer bundleEE = new StringBuffer(25);
        i = 0;
        while (i < bundleRequiredEE.length) {
            if (i > 0) {
                bundleEE.append(",");
            }
            bundleEE.append(bundleRequiredEE[i]);
            ++i;
        }
        throw new BundleException(Msg.formatter.getString("BUNDLE_INSTALL_REQUIRED_EE_EXCEPTION", bundleEE.toString()));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    protected String getProperty(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    protected Object setProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    protected Bundle installBundle(final String location) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from location: " + location);
        }
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                URLConnection source = Framework.this.adaptor.mapLocationToURLConnection(location);
                return Framework.this.installWorkerPrivileged(location, source);
            }
        });
    }

    protected Bundle installBundle(final String location, final InputStream in) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from inputstream: " + location + ", " + in);
        }
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                BundleSource source = new BundleSource(in);
                return Framework.this.installWorkerPrivileged(location, source);
            }
        });
    }

    /*
     * Exception decompiling
     */
    protected Bundle installWorker(String location, PrivilegedExceptionAction action) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Bundle installWorkerPrivileged(String location, URLConnection source) throws BundleException {
        Bundle bundle;
        BundleOperation storage = this.adaptor.installBundle(location, source);
        try {
            Bundle installedBundle;
            BundleData bundledata = storage.begin();
            bundle = this.createBundle(bundledata, location, this.startLevelImpl.getInitialBundleStartLevel());
            if (bundle.getGlobalName() != null && (installedBundle = this.getBundleByUniqueId(bundle.getGlobalName(), bundle.getVersion().toString())) != null) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_INSTALL_SAME_UNIQUEID", bundle.getGlobalName(), bundle.getVersion().toString()));
            }
            try {
                String[] nativepaths = this.selectNativeCode(bundle);
                if (nativepaths != null) {
                    bundledata.installNativeCode(nativepaths);
                }
                bundle.load();
                storage.commit(false);
            }
            catch (BundleException be) {
                BundleRepository bundleRepository = this.bundles;
                synchronized (bundleRepository) {
                    bundle.unload();
                }
                bundle.close();
                throw be;
            }
            this.bundles.add(bundle);
        }
        catch (BundleException e) {
            this.publishFrameworkEvent(2, this.systemBundle, e);
            try {
                storage.undo();
            }
            catch (BundleException ee) {
                this.publishFrameworkEvent(2, this.systemBundle, ee);
            }
            throw e;
        }
        return bundle;
    }

    public String[] selectNativeCode(org.osgi.framework.Bundle bundle) throws BundleException {
        int result;
        org.eclipse.osgi.framework.adaptor.Version osversion;
        String headerValue = (String)((Bundle)bundle).bundledata.getManifest().get("Bundle-NativeCode");
        if (headerValue == null) {
            return null;
        }
        ManifestElement[] elements = ManifestElement.parseNativeCodeDescription(headerValue);
        BundleNativeCode[] bundleNativeCode = new BundleNativeCode[elements.length];
        String processor = this.getProperty("org.osgi.framework.processor");
        String osname = this.getProperty("org.osgi.framework.os.name");
        int[] score = new int[elements.length];
        int matches = 0;
        int maxresult = 0;
        int index = 0;
        int i = 0;
        while (i < elements.length) {
            int result2;
            bundleNativeCode[i] = new BundleNativeCode(elements[i]);
            score[i] = result2 = bundleNativeCode[i].matchProcessorOSName(processor, osname);
            if (result2 > 0) {
                ++matches;
                if (result2 > maxresult) {
                    maxresult = result2;
                    index = i;
                }
            }
            ++i;
        }
        switch (matches) {
            case 0: {
                throw new BundleException(Msg.formatter.getString("BUNDLE_NATIVECODE_MATCH_EXCEPTION"));
            }
            case 1: {
                return bundleNativeCode[index].getPaths();
            }
        }
        try {
            osversion = new org.eclipse.osgi.framework.adaptor.Version(this.getProperty("org.osgi.framework.os.version"));
        }
        catch (Exception exception) {
            osversion = org.eclipse.osgi.framework.adaptor.Version.emptyVersion;
        }
        matches = 0;
        maxresult = 0;
        org.eclipse.osgi.framework.adaptor.Version[] bestVersion = new org.eclipse.osgi.framework.adaptor.Version[elements.length];
        org.eclipse.osgi.framework.adaptor.Version maxVersion = org.eclipse.osgi.framework.adaptor.Version.emptyVersion;
        int i2 = 0;
        while (i2 < elements.length) {
            if (score[i2] > 0) {
                org.eclipse.osgi.framework.adaptor.Version result3;
                BundleNativeCode bnc = bundleNativeCode[i2];
                bestVersion[i2] = result3 = bnc.matchOSVersion(osversion);
                if (result3 != null) {
                    ++matches;
                    if (result3.compareTo(maxVersion) > 0) {
                        maxVersion = result3;
                        index = i2;
                    }
                }
            }
            ++i2;
        }
        switch (matches) {
            case 0: {
                throw new BundleException(Msg.formatter.getString("BUNDLE_NATIVECODE_MATCH_EXCEPTION"));
            }
            case 1: {
                return bundleNativeCode[index].getPaths();
            }
        }
        i2 = 0;
        while (i2 < elements.length) {
            org.eclipse.osgi.framework.adaptor.Version result4 = bestVersion[i2];
            if (result4.compareTo(maxVersion) < 0) {
                score[i2] = 0;
            }
            ++i2;
        }
        String windowingsystem = this.getProperty("org.osgi.framework.windowing.system");
        matches = 0;
        maxresult = 0;
        int[] bestMatch = new int[elements.length];
        int i3 = 0;
        while (i3 < elements.length) {
            if (score[i3] > 0) {
                BundleNativeCode bnc = bundleNativeCode[i3];
                bestMatch[i3] = result = bnc.matchWindowingSystem(windowingsystem);
                if (result > 0) {
                    ++matches;
                    if (result > maxresult) {
                        maxresult = result;
                        index = i3;
                    }
                }
            }
            switch (matches) {
                case 0: {
                    throw new BundleException(Msg.formatter.getString("BUNDLE_NATIVECODE_MATCH_EXCEPTION"));
                }
                case 1: {
                    return bundleNativeCode[index].getPaths();
                }
            }
            int j = 0;
            while (j < elements.length) {
                result = bestMatch[j];
                if (result < maxresult) {
                    score[j] = 0;
                }
                ++j;
            }
            ++i3;
        }
        String language = this.getProperty("org.osgi.framework.language");
        matches = 0;
        maxresult = 0;
        int i4 = 0;
        while (i4 < elements.length) {
            result = score[i4];
            if (result > 0) {
                BundleNativeCode bnc = bundleNativeCode[i4];
                score[i4] = result = bnc.matchLanguage(language);
                if (result > 0) {
                    ++matches;
                    if (result > maxresult) {
                        maxresult = result;
                        index = i4;
                    }
                }
            }
            ++i4;
        }
        switch (matches) {
            case 0: {
                throw new BundleException(Msg.formatter.getString("BUNDLE_NATIVECODE_MATCH_EXCEPTION"));
            }
        }
        return bundleNativeCode[index].getPaths();
    }

    public Bundle getBundle(long id) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(id);
        }
    }

    protected Bundle getBundleByUniqueId(String uniqueId, String version) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(uniqueId, version);
        }
    }

    protected BundleRepository getBundles() {
        return this.bundles;
    }

    protected void resumeBundle(Bundle bundle) {
        if (bundle.isActive() || bundle.isFragment()) {
            return;
        }
        try {
            int status = bundle.bundledata.getStatus();
            if ((status & 1) == 0) {
                return;
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to start bundle " + bundle);
            }
            bundle.resume();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle resume exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
    }

    protected boolean suspendBundle(Bundle bundle, boolean lock) {
        boolean changed = false;
        if (!bundle.isActive() || bundle.isFragment()) {
            return changed;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to suspend bundle " + bundle);
            }
            bundle.suspend(lock);
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle suspend exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
        if (!bundle.isActive()) {
            changed = true;
        }
        return changed;
    }

    protected Bundle getBundleByLocation(String location) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                Bundle bundle = (Bundle)allBundles.get(i);
                if (location.equals(bundle.getLocation())) {
                    return bundle;
                }
                ++i;
            }
        }
        return null;
    }

    protected Bundle[] getBundleByUniqueId(String uniqueId) {
        return this.bundles.getBundles(uniqueId);
    }

    protected Bundle getBundleByClassLoader(BundleClassLoader classloader) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                BundleLoader loader;
                Bundle bundle = (Bundle)allBundles.get(i);
                if (bundle instanceof BundleHost && (loader = ((BundleHost)bundle).basicGetBundleLoader()) != null && loader.getClassLoader() == classloader) {
                    return bundle;
                }
                ++i;
            }
        }
        return null;
    }

    protected ServiceReference[] getServiceReferences(String clazz, String filterstring) throws InvalidSyntaxException {
        Filter filter = filterstring == null ? null : new Filter(filterstring);
        ServiceReference[] references = null;
        if (clazz != null) {
            try {
                this.checkGetServicePermission(clazz);
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        ServiceRegistry serviceRegistry = this.serviceRegistry;
        synchronized (serviceRegistry) {
            Vector services = this.serviceRegistry.lookupServiceReferences(clazz, filter);
            if (services == null) {
                return null;
            }
            if (clazz == null) {
                int i = services.size() - 1;
                while (i >= 0) {
                    ServiceReference ref = (ServiceReference)services.elementAt(i);
                    String[] classes = ref.getClasses();
                    try {
                        this.checkGetServicePermission(classes);
                    }
                    catch (SecurityException securityException) {
                        services.removeElementAt(i);
                    }
                    --i;
                }
            }
            if (services.size() > 0) {
                references = new ServiceReference[services.size()];
                services.toArray(references);
            }
        }
        return references;
    }

    protected long getNextServiceId() {
        long id = this.serviceid++;
        return id;
    }

    protected File getDataFile(final Bundle bundle, final String filename) {
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundle.bundledata.getDataFile(filename);
            }
        });
    }

    protected void checkAdminPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.adminPermission == null) {
                this.adminPermission = new AdminPermission();
            }
            sm.checkPermission((Permission)this.adminPermission);
        }
    }

    protected void checkRegisterServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int len = names.length;
            int i = 0;
            while (i < len) {
                sm.checkPermission((Permission)new ServicePermission(names[i], "register"));
                ++i;
            }
        }
    }

    protected void checkGetServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SecurityException se = null;
            int len = names.length;
            int i = 0;
            while (i < len) {
                try {
                    sm.checkPermission((Permission)new ServicePermission(names[i], "get"));
                    return;
                }
                catch (SecurityException e) {
                    se = e;
                    ++i;
                }
            }
            throw se;
        }
    }

    protected void checkGetServicePermission(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new ServicePermission(name, "get"));
        }
    }

    protected void installSecurityManager() {
        SecurityManager sm;
        String securityManager = System.getProperty("java.security.manager");
        if (securityManager != null && (sm = System.getSecurityManager()) == null) {
            if (securityManager.length() < 1) {
                securityManager = "java.lang.SecurityManager";
            }
            try {
                Class<?> clazz = Class.forName(securityManager);
                sm = (SecurityManager)clazz.newInstance();
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("Setting SecurityManager to: " + sm);
                }
                System.setSecurityManager(sm);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            throw new NoClassDefFoundError(securityManager);
        }
    }

    protected Thread createThread(Runnable target, String name) {
        return (Thread)AccessController.doPrivileged(new CreateThread(target, name));
    }

    public void publishFrameworkEvent(int type, org.osgi.framework.Bundle bundle, Throwable throwable) {
        if (this.frameworkEvent != null) {
            final FrameworkEvent event = new FrameworkEvent(type, bundle, throwable);
            if (System.getSecurityManager() == null) {
                this.publishFrameworkEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishFrameworkEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    public void publishFrameworkEventPrivileged(FrameworkEvent event) {
        EventQueue listeners = new EventQueue(this.eventManager);
        EventQueue contexts = new EventQueue(this.eventManager);
        EventListeners eventListeners = this.frameworkEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.frameworkEvent, this);
            contexts.dispatchEventSynchronous(4, listeners);
        }
        listeners.dispatchEventAsynchronous(4, event);
    }

    public void publishBundleEvent(int type, org.osgi.framework.Bundle bundle) {
        if (this.bundleEventSync != null || this.bundleEvent != null) {
            final BundleEvent event = new BundleEvent(type, bundle);
            if (System.getSecurityManager() == null) {
                this.publishBundleEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishBundleEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    public void publishBundleEventPrivileged(BundleEvent event) {
        EventListeners eventListeners;
        EventQueue contexts;
        EventQueue listeners;
        if (this.bundleEventSync != null) {
            listeners = new EventQueue(this.eventManager);
            contexts = new EventQueue(this.eventManager);
            eventListeners = this.bundleEventSync;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEventSync, this);
                contexts.dispatchEventSynchronous(2, listeners);
            }
            listeners.dispatchEventSynchronous(2, event);
        }
        if (this.bundleEvent != null) {
            listeners = new EventQueue(this.eventManager);
            contexts = new EventQueue(this.eventManager);
            eventListeners = this.bundleEvent;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEvent, this);
                contexts.dispatchEventSynchronous(1, listeners);
            }
            listeners.dispatchEventAsynchronous(1, event);
        }
    }

    public void publishServiceEvent(int type, org.osgi.framework.ServiceReference reference) {
        if (this.serviceEvent != null) {
            final ServiceEvent event = new ServiceEvent(type, reference);
            if (System.getSecurityManager() == null) {
                this.publishServiceEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishServiceEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    public void publishServiceEventPrivileged(ServiceEvent event) {
        EventQueue listeners = new EventQueue(this.eventManager);
        EventQueue contexts = new EventQueue(this.eventManager);
        EventListeners eventListeners = this.serviceEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.serviceEvent, this);
            contexts.dispatchEventSynchronous(3, listeners);
        }
        listeners.dispatchEventSynchronous(3, event);
    }

    public void dispatchEvent(Object l, Object lo, int action, Object object) {
        block10: {
            try {
                BundleContext context = (BundleContext)l;
                if (context.bundle != null) {
                    EventQueue queue = (EventQueue)object;
                    switch (action) {
                        case 1: {
                            queue.queueListeners(context.bundleEvent, context);
                            break;
                        }
                        case 2: {
                            queue.queueListeners(context.bundleEventSync, context);
                            break;
                        }
                        case 3: {
                            queue.queueListeners(context.serviceEvent, context);
                            break;
                        }
                        case 4: {
                            queue.queueListeners(context.frameworkEvent, context);
                        }
                    }
                }
            }
            catch (Throwable t) {
                FrameworkEvent event;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in Top level event dispatcher: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) break block10;
                BundleContext context = (BundleContext)l;
                this.publishFrameworkEvent(2, context.bundle, t);
            }
        }
    }
}

