/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExportedPackageImpl
extends SingleSourcePackage
implements ExportedPackage {
    String specVersion;
    PackageSpecification packageSpec;

    public ExportedPackageImpl(PackageSpecification packageSpec, BundleLoaderProxy supplier) {
        super(packageSpec.getName(), supplier);
        this.packageSpec = packageSpec;
        Version version = this.packageSpec.getActualVersion();
        if (version != null) {
            this.specVersion = version.toString();
        }
    }

    public String getName() {
        return this.getId();
    }

    public org.osgi.framework.Bundle getExportingBundle() {
        if (this.supplier.isStale()) {
            return null;
        }
        return this.supplier.getBundle();
    }

    public org.osgi.framework.Bundle[] getImportingBundles() {
        if (this.supplier.isStale()) {
            return null;
        }
        Bundle[] dependentBundles = this.supplier.getDependentBundles();
        ArrayList<Bundle> importingBundles = new ArrayList<Bundle>();
        importingBundles.add(this.supplier.getBundle());
        int i = 0;
        while (i < dependentBundles.length) {
            Bundle bundle = dependentBundles[i];
            BundleLoader bundleLoader = bundle.getBundleLoader();
            if (bundleLoader.importedPackages != null && bundleLoader.importedPackages.getByKey(this.getId()) != null) {
                importingBundles.add(bundle);
            }
            ++i;
        }
        org.osgi.framework.Bundle[] result = new Bundle[importingBundles.size()];
        importingBundles.toArray(result);
        return result;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public boolean isRemovalPending() {
        Bundle bundle = this.supplier.getBundle();
        return bundle.framework.packageAdmin.removalPending.contains(this.supplier);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getId());
        if (this.specVersion != null) {
            result.append("; ").append("specification-version");
            result.append("=\"").append(this.specVersion).append("\"");
        }
        return result.toString();
    }
}

