/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.osgi.framework.adaptor.Version;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.PackageAdmin;

public class BundleRepository {
    private ArrayList bundlesByInstallOrder;
    private KeyedHashSet bundlesById;
    private Hashtable bundlesByGlobalName;
    private PackageAdmin packageAdmin;

    public BundleRepository(int initialCapacity, PackageAdmin packageAdmin) {
        this.bundlesByInstallOrder = new ArrayList(initialCapacity);
        this.bundlesById = new KeyedHashSet(initialCapacity, true);
        this.bundlesByGlobalName = new Hashtable(initialCapacity);
        this.packageAdmin = packageAdmin;
    }

    public List getBundles() {
        return this.bundlesByInstallOrder;
    }

    public Bundle getBundle(long bundleId) {
        Long key = new Long(bundleId);
        return (Bundle)this.bundlesById.getByKey(key);
    }

    public Bundle[] getBundles(String globalName) {
        return (Bundle[])this.bundlesByGlobalName.get(globalName);
    }

    public Bundle getBundle(String globalName, String version) {
        Bundle[] bundles = (Bundle[])this.bundlesByGlobalName.get(globalName);
        if (bundles != null) {
            Version ver = new Version(version);
            if (bundles.length > 0) {
                int i = 0;
                while (i < bundles.length) {
                    if (bundles[i].getVersion().isPerfect(ver)) {
                        return bundles[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public void add(Bundle bundle) {
        this.bundlesByInstallOrder.add(bundle);
        this.bundlesById.add(bundle);
        String globalName = bundle.getGlobalName();
        if (globalName != null) {
            Bundle[] bundles = (Bundle[])this.bundlesByGlobalName.get(globalName);
            if (bundles == null) {
                bundles = new Bundle[]{bundle};
                this.bundlesByGlobalName.put(globalName, bundles);
                return;
            }
            ArrayList<Bundle> list = new ArrayList<Bundle>(bundles.length + 1);
            Version newVersion = bundle.getVersion();
            boolean added = false;
            int i = 0;
            while (i < bundles.length) {
                Bundle oldBundle = bundles[i];
                Version oldVersion = oldBundle.getVersion();
                if (!added && newVersion.isGreaterOrEqualTo(oldVersion)) {
                    added = true;
                    list.add(bundle);
                }
                list.add(oldBundle);
                ++i;
            }
            if (!added) {
                list.add(bundle);
            }
            bundles = new Bundle[list.size()];
            list.toArray(bundles);
            this.bundlesByGlobalName.put(globalName, bundles);
        }
    }

    public boolean remove(Bundle bundle) {
        boolean removed = this.bundlesById.remove(bundle);
        if (removed) {
            Bundle[] bundles;
            this.bundlesByInstallOrder.remove(bundle);
            String globalName = bundle.getGlobalName();
            if (globalName != null && (bundles = (Bundle[])this.bundlesByGlobalName.get(globalName)) != null) {
                int numRemoved = 0;
                int i = 0;
                while (i < bundles.length) {
                    if (bundle == bundles[i]) {
                        ++numRemoved;
                        bundles[i] = null;
                    }
                    ++i;
                }
                if (numRemoved > 0) {
                    if (bundles.length - numRemoved <= 0) {
                        this.bundlesByGlobalName.remove(globalName);
                    } else {
                        Bundle[] newBundles = new Bundle[bundles.length - numRemoved];
                        int indexCnt = 0;
                        int i2 = 0;
                        while (i2 < bundles.length) {
                            if (bundles[i2] != null) {
                                newBundles[indexCnt] = bundles[i2];
                                ++indexCnt;
                            }
                            ++i2;
                        }
                        this.bundlesByGlobalName.put(globalName, newBundles);
                    }
                }
            }
        }
        return removed;
    }

    public void removeAllBundles() {
        this.bundlesByInstallOrder.clear();
        this.bundlesById = new KeyedHashSet();
        this.bundlesByGlobalName.clear();
    }

    public synchronized void markDependancies() {
        KeyedElement[] elements = this.bundlesById.elements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof BundleHost) {
                ((BundleHost)elements[i]).getLoaderProxy().markDependencies();
            }
            ++i;
        }
    }

    public synchronized void unMarkDependancies(BundleLoaderProxy user) {
        KeyedElement[] elements = this.bundlesById.elements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof BundleHost) {
                BundleLoaderProxy loaderProxy = ((BundleHost)elements[i]).getLoaderProxy();
                loaderProxy.unMarkUsed(user);
            }
            ++i;
        }
        int size = this.packageAdmin.removalPending.size();
        int i2 = 0;
        while (i2 < size) {
            BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.packageAdmin.removalPending.elementAt(i2);
            loaderProxy.unMarkUsed(user);
            ++i2;
        }
        user.markedUsedDependencies = false;
    }
}

