/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.Version;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.util.ManifestElement;

public class BundleNativeCode {
    private Attribute nativepaths;
    private Attribute processor;
    private Attribute osname;
    private Attribute language;
    private Attribute osversion;
    private Attribute windowingsystem;
    private static AliasMapper aliasMapper = new AliasMapper();

    protected BundleNativeCode(ManifestElement element) {
        StringTokenizer attrSt;
        StringTokenizer st = new StringTokenizer(element.getValue(), ";");
        while (st.hasMoreTokens()) {
            this.addPath(st.nextToken());
        }
        String attrValue = element.getAttribute("osname");
        if (attrValue != null) {
            attrSt = new StringTokenizer(attrValue, ",");
            while (attrSt.hasMoreTokens()) {
                this.addAttribute("osname", attrSt.nextToken());
            }
        }
        if ((attrValue = element.getAttribute("processor")) != null) {
            attrSt = new StringTokenizer(attrValue, ",");
            while (attrSt.hasMoreTokens()) {
                this.addAttribute("processor", attrSt.nextToken());
            }
        }
        if ((attrValue = element.getAttribute("osversion")) != null) {
            attrSt = new StringTokenizer(attrValue, ",");
            while (attrSt.hasMoreTokens()) {
                this.addAttribute("osversion", attrSt.nextToken());
            }
        }
        if ((attrValue = element.getAttribute("language")) != null) {
            attrSt = new StringTokenizer(attrValue, ",");
            while (attrSt.hasMoreTokens()) {
                this.addAttribute("language", attrSt.nextToken());
            }
        }
        if ((attrValue = element.getAttribute("ws")) != null) {
            attrSt = new StringTokenizer(attrValue, ",");
            while (attrSt.hasMoreTokens()) {
                this.addAttribute("ws", attrSt.nextToken());
            }
        }
    }

    public String[] getPaths() {
        if (this.nativepaths == null) {
            return null;
        }
        String[] paths = new String[this.nativepaths.size()];
        this.nativepaths.toArray(paths);
        return paths;
    }

    protected void addPath(String nativepath) {
        if (this.nativepaths == null) {
            this.nativepaths = new Attribute();
        }
        this.nativepaths.addElement(nativepath);
    }

    protected synchronized void addAttribute(String key, String value) {
        if (key.equals("processor")) {
            if (this.processor == null) {
                this.processor = new Attribute();
            }
            this.processor.addElement(aliasMapper.aliasProcessor(value));
            return;
        }
        if (key.equals("osname")) {
            if (this.osname == null) {
                this.osname = new Attribute();
            }
            this.osname.addElement(aliasMapper.aliasOSName(value));
            return;
        }
        if (key.equals("osversion")) {
            if (this.osversion == null) {
                this.osversion = new Attribute();
            }
            this.osversion.addElement(new Version(value));
            return;
        }
        if (key.equals("language")) {
            if (this.language == null) {
                this.language = new Attribute();
            }
            this.language.addElement(value.toLowerCase());
            return;
        }
        if (key.equals("ws")) {
            if (this.windowingsystem == null) {
                this.windowingsystem = new Attribute();
            }
            this.windowingsystem.addElement(value.toLowerCase());
            return;
        }
    }

    public String toString() {
        Attribute nativepaths = this.nativepaths;
        int size = nativepaths.size();
        StringBuffer sb = new StringBuffer(50 * size);
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(';');
            }
            sb.append(nativepaths.elementAt(i).toString());
            ++i;
        }
        if (this.processor != null) {
            size = this.processor.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("processor");
                sb.append('=');
                sb.append(this.processor.elementAt(i).toString());
                ++i;
            }
        }
        if (this.osname != null) {
            size = this.osname.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("osname");
                sb.append('=');
                sb.append(this.osname.elementAt(i).toString());
                ++i;
            }
        }
        if (this.osversion != null) {
            size = this.osversion.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("osversion");
                sb.append('=');
                sb.append(this.osversion.elementAt(i).toString());
                ++i;
            }
        }
        if (this.language != null) {
            size = this.language.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("language");
                sb.append('=');
                sb.append(this.language.elementAt(i).toString());
                ++i;
            }
        }
        if (this.windowingsystem != null) {
            size = this.windowingsystem.size();
            i = 0;
            while (i < size) {
                sb.append(';');
                sb.append("ws");
                sb.append('=');
                sb.append(this.windowingsystem.elementAt(i).toString());
                ++i;
            }
        }
        return sb.toString();
    }

    public int matchProcessorOSName(String processor, String osname) {
        if (this.processor == null || this.osname == null) {
            return 0;
        }
        String otherProcessor = aliasMapper.aliasProcessor(processor);
        String otherOSName = aliasMapper.aliasOSName(osname);
        if (this.processor.equals(otherProcessor) && this.osname.equals(otherOSName)) {
            return 1;
        }
        return 0;
    }

    public Version matchOSVersion(Version version) {
        if (this.osversion == null) {
            return Version.emptyVersion;
        }
        Version result = null;
        int size = this.osversion.size();
        int i = 0;
        while (i < size) {
            Version ver = (Version)this.osversion.elementAt(i);
            int compare = ver.compareTo(version);
            if (compare == 0) {
                return ver;
            }
            if (compare < 0 && (result == null || ver.compareTo(result) > 0)) {
                result = ver;
            }
            ++i;
        }
        return result;
    }

    public int matchLanguage(String language) {
        if (this.language == null) {
            return 1;
        }
        if (this.language.equals(language.toLowerCase())) {
            return 2;
        }
        return 0;
    }

    public int matchWindowingSystem(String runtimeWS) {
        if (runtimeWS == null) {
            if (this.windowingsystem == null) {
                return 1;
            }
            return 0;
        }
        if (this.windowingsystem.equals(runtimeWS.toLowerCase())) {
            return 2;
        }
        return 0;
    }

    static class Attribute
    extends Vector {
        Attribute() {
            super(10, 10);
        }

        public synchronized boolean equals(Object obj) {
            int i = 0;
            while (i < this.elementCount) {
                if (this.elementData[i].equals(obj)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public synchronized void addElement(Object obj) {
            if (!this.contains(obj)) {
                super.addElement(obj);
            }
        }
    }
}

