/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;

public class BundleLoaderProxy
implements KeyedElement {
    private BundleLoader loader;
    private BundleHost bundle;
    private String uniqueId;
    private String key;
    private boolean stale = false;
    private KeyedHashSet users;
    protected boolean markedUsedDependencies = false;

    public BundleLoaderProxy(BundleHost bundle) {
        this.bundle = bundle;
        this.uniqueId = bundle.getGlobalName();
        if (this.uniqueId == null) {
            this.uniqueId = bundle.id + "NOUNIQUEID";
        }
        this.key = this.uniqueId + "_" + bundle.getVersion().toString();
        this.users = new KeyedHashSet(false);
    }

    public BundleLoader getBundleLoader() {
        if (this.loader == null) {
            this.loader = this.bundle.getBundleLoader();
        }
        return this.loader;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundleLoader(BundleLoader value) {
        this.loader = value;
    }

    public void markUsed(BundleLoaderProxy user) {
        if (user.getBundle() != this.bundle) {
            this.users.add(user);
        }
    }

    public void unMarkUsed(BundleLoaderProxy user) {
        this.users.removeByKey(user.getKey());
    }

    public int getKeyHashCode() {
        return this.key.hashCode();
    }

    public boolean compare(KeyedElement other) {
        if (!(other instanceof BundleLoaderProxy)) {
            return false;
        }
        BundleLoaderProxy otherLoaderProxy = (BundleLoaderProxy)other;
        return this.uniqueId.equals(otherLoaderProxy.uniqueId) && this.bundle.getVersion().isPerfect(otherLoaderProxy.bundle.getVersion());
    }

    public Object getKey() {
        return this.key;
    }

    public void setStale() {
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    public boolean inUse() {
        return this.users.size() > 0;
    }

    public Bundle[] getDependentBundles() {
        KeyedElement[] proxyLoaders = this.users.elements();
        KeyedHashSet bundles = new KeyedHashSet(proxyLoaders.length, false);
        int i = 0;
        while (i < proxyLoaders.length) {
            BundleLoaderProxy loaderProxy = (BundleLoaderProxy)proxyLoaders[i];
            bundles.add(loaderProxy.getBundle());
            ++i;
        }
        KeyedElement[] elements = bundles.elements();
        Bundle[] result = new Bundle[elements.length];
        System.arraycopy(elements, 0, result, 0, elements.length);
        return result;
    }

    public String toString() {
        return this.bundle.getLocation();
    }

    protected void markDependencies() {
        if (this.markedUsedDependencies || !this.bundle.isResolved()) {
            return;
        }
        this.markedUsedDependencies = true;
        BundleDescription bundleDes = this.bundle.getBundleDescription();
        if (Debug.DEBUG_GENERAL && bundleDes == null) {
            Debug.println("Bundle.resolved called and getBundleDescription returned null: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        PackageSpecification[] packages = bundleDes.getPackages();
        BundleSpecification[] requiredBundles = bundleDes.getRequiredBundles();
        BundleDescription[] fragDescriptions = bundleDes.getFragments();
        this.markUsedPackages(packages);
        this.markUsedBundles(requiredBundles);
        int i = 0;
        while (i < fragDescriptions.length) {
            if (fragDescriptions[i].isResolved()) {
                this.markUsedPackages(fragDescriptions[i].getPackages());
                this.markUsedBundles(fragDescriptions[i].getRequiredBundles());
            }
            ++i;
        }
        this.getBundleLoader();
    }

    private void markUsedPackages(PackageSpecification[] packages) {
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                SingleSourcePackage packagesource = (SingleSourcePackage)this.bundle.framework.packageAdmin.exportedPackages.getByKey(packages[i].getName());
                if (packagesource != null) {
                    packagesource.getSupplier().markUsed(this);
                }
                ++i;
            }
        }
    }

    private void markUsedBundles(BundleSpecification[] requiredBundles) {
        if (requiredBundles != null) {
            int i = 0;
            while (i < requiredBundles.length) {
                String bundleKey;
                BundleLoaderProxy loaderProxy;
                if (requiredBundles[i].isResolved() && (loaderProxy = (BundleLoaderProxy)this.bundle.framework.packageAdmin.exportedBundles.getByKey(bundleKey = requiredBundles[i].getName() + "_" + requiredBundles[i].getActualVersion().toString())) != null) {
                    loaderProxy.markUsed(this);
                }
                ++i;
            }
        }
    }
}

