/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.ImportClassNotFoundException;
import org.eclipse.osgi.framework.adaptor.ImportResourceNotFoundException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleResourcePermission;
import org.eclipse.osgi.framework.internal.core.Filter;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.MultiSourcePackage;
import org.eclipse.osgi.framework.internal.core.NullPackageSource;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermission;

public class BundleLoader
implements ClassLoaderDelegate {
    protected BundleHost bundle;
    protected BundleClassLoader classloader;
    protected BundleResourcePermission resourcePermission;
    protected KeyedHashSet importedPackages;
    protected boolean hasImportedPackages = false;
    protected boolean hasDynamicImports = false;
    protected boolean dynamicImportPackageAll;
    protected String[] dynamicImportPackageStems;
    protected String[] dynamicImportPackages;
    protected KeyedHashSet providedPackages;
    protected KeyedHashSet requiredPackagesCache;
    protected BundleLoaderProxy[] requiredBundles;
    protected int[] reexportTable;

    protected static String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return null;
    }

    protected static String getResourcePackageName(String name) {
        if (name != null) {
            int begin = name.length() > 1 && name.charAt(0) == '/' ? 1 : 0;
            int end = name.lastIndexOf(47);
            if (end > begin) {
                return name.substring(begin, end).replace('/', '.');
            }
        }
        return null;
    }

    protected BundleLoader(BundleHost bundle, BundleDescription description) throws BundleException {
        this.bundle = bundle;
        try {
            bundle.getBundleData().open();
        }
        catch (IOException e) {
            throw new BundleException(Msg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)e);
        }
        this.initialize(description);
    }

    protected void initialize(BundleDescription description) {
        this.hasDynamicImports = SystemBundleLoader.getSystemPackages() != null;
        this.hasImportedPackages = this.hasDynamicImports;
        org.osgi.framework.Bundle[] fragmentObjects = this.bundle.getFragments();
        BundleDescription[] fragments = new BundleDescription[fragmentObjects == null ? 0 : fragmentObjects.length];
        int i = 0;
        while (i < fragments.length) {
            fragments[i] = ((Bundle)fragmentObjects[i]).getBundleDescription();
            ++i;
        }
        this.addImportedPackages(description.getPackages());
        i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                this.addImportedPackages(fragments[i].getPackages());
            }
            ++i;
        }
        BundleSpecification[] required = description.getRequiredBundles();
        ArrayList<BundleSpecification> bundles = new ArrayList<BundleSpecification>(Arrays.asList(required == null ? new BundleSpecification[]{} : required));
        int i2 = 0;
        while (i2 < fragments.length) {
            BundleSpecification[] fragmentRequires;
            if (fragments[i2].isResolved() && (fragmentRequires = fragments[i2].getRequiredBundles()) != null) {
                bundles.addAll(Arrays.asList(fragmentRequires));
            }
            ++i2;
        }
        if (bundles.size() > 0) {
            ArrayList<BundleLoaderProxy> bound = new ArrayList<BundleLoaderProxy>(bundles.size());
            int[] reexported = new int[bundles.size()];
            int reexportIndex = 0;
            int i3 = 0;
            while (i3 < bundles.size()) {
                BundleSpecification spec = bundles.get(i3);
                if (spec.isResolved()) {
                    String bundleKey = spec.getName() + "_" + spec.getActualVersion().toString();
                    BundleLoaderProxy loaderProxy = (BundleLoaderProxy)this.bundle.framework.packageAdmin.exportedBundles.getByKey(bundleKey);
                    if (loaderProxy != null) {
                        bound.add(loaderProxy);
                        if (spec.isExported()) {
                            reexported[reexportIndex++] = i3;
                        }
                    } else {
                        System.out.println("Could not find loaderProxy: " + bundleKey);
                    }
                }
                ++i3;
            }
            this.requiredBundles = bound.toArray(new BundleLoaderProxy[bound.size()]);
            if (reexportIndex > 0) {
                this.reexportTable = new int[reexportIndex];
                System.arraycopy(reexported, 0, this.reexportTable, 0, reexportIndex);
            }
        }
        String[] provides = description.getProvidedPackages();
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(required == null ? new String[]{} : provides));
        int i4 = 0;
        while (i4 < fragments.length) {
            String[] fragmentProvides;
            if (fragments[i4].isResolved() && (fragmentProvides = fragments[i4].getProvidedPackages()) != null) {
                packages.addAll(Arrays.asList(fragmentProvides));
            }
            ++i4;
        }
        if (packages.size() > 0) {
            this.providedPackages = new KeyedHashSet(packages.size());
            i4 = 0;
            while (i4 < packages.size()) {
                this.providedPackages.add(new SingleSourcePackage(packages.get(i4), this.bundle.getLoaderProxy()));
                ++i4;
            }
        }
        try {
            String spec = this.bundle.getBundleData().getDynamicImports();
            ManifestElement[] imports = ManifestElement.parsePackageDescription(spec);
            this.initDynamicImportPackage(imports);
            int i5 = 0;
            while (i5 < fragments.length) {
                if (fragments[i5].isResolved()) {
                    spec = ((Bundle)fragmentObjects[i5]).getBundleData().getDynamicImports();
                    imports = ManifestElement.parsePackageDescription(spec);
                    this.initDynamicImportPackage(imports);
                }
                ++i5;
            }
        }
        catch (BundleException bundleException) {}
    }

    private void addImportedPackages(PackageSpecification[] packages) {
        if (packages != null && packages.length > 0) {
            if (!this.hasImportedPackages || this.importedPackages == null) {
                this.hasImportedPackages = true;
                this.importedPackages = new KeyedHashSet();
            }
            int i = 0;
            while (i < packages.length) {
                SingleSourcePackage packagesource = (SingleSourcePackage)this.bundle.framework.packageAdmin.exportedPackages.getByKey(packages[i].getName());
                if (packagesource != null) {
                    this.importedPackages.add(packagesource);
                }
                ++i;
            }
        }
    }

    protected BundleHost getSupplier(VersionConstraint spec) {
        BundleDescription supplier = spec.getSupplier();
        if (supplier == null) {
            return null;
        }
        return (BundleHost)this.bundle.framework.getBundle(supplier.getBundleId());
    }

    protected void close() {
        if (this.bundle == null) {
            return;
        }
        BundleData bundleData = this.bundle.getBundleData();
        this.importedPackages = null;
        if (bundleData != null) {
            block5: {
                if (this.classloader != null) {
                    this.classloader.close();
                }
                this.classloader = null;
                try {
                    bundleData.close();
                }
                catch (IOException e) {
                    if (!Debug.DEBUG_LOADER) break block5;
                    Debug.println("IOException on close :" + e.getMessage());
                }
            }
            this.bundle = null;
        }
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(name, false);
    }

    protected ResourceBundle getResourceBundle(String name, Locale locale) {
        return ResourceBundle.getBundle(name, locale, this.createClassLoader());
    }

    protected Class importClass(String name) {
        Class result = this.findLocalClass(name);
        return result;
    }

    protected BundleClassLoader createClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        BundleLoader bundleLoader = this;
        synchronized (bundleLoader) {
            if (this.classloader != null) {
                return this.classloader;
            }
            try {
                String[] classpath = this.getClassPath(this.bundle, System.getProperties());
                if (classpath != null) {
                    this.classloader = this.createBCLPrevileged(this.bundle.getProtectionDomain(), classpath);
                    org.osgi.framework.Bundle[] fragments = this.bundle.getFragments();
                    if (fragments != null) {
                        int i = 0;
                        while (i < fragments.length) {
                            Bundle fragment = (Bundle)fragments[i];
                            this.classloader.attachFragment(fragment.getBundleData(), fragment.domain, this.getClassPath(fragment, System.getProperties()));
                            ++i;
                        }
                    }
                    this.classloader.initialize();
                } else {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
                }
            }
            catch (BundleException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            }
        }
        return this.classloader;
    }

    protected Class findLocalClass(String name) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(name);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.isClosed()) {
            throw new ClassNotFoundException(name);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + name + ")");
        }
        String packageName = BundleLoader.getPackageName(name);
        Class result = null;
        if (packageName != null && (result = this.findImportedClass(name, packageName)) == null) {
            result = this.findRequiredClass(name, packageName);
        }
        if (result == null && (result = this.findLocalClass(name)) == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    boolean isClosed() {
        return this.bundle == null;
    }

    public URL findResource(String name) {
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException securityException) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException securityException2) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(name);
        URL resource = null;
        if (packageName != null && (resource = this.findImportedResource(name, packageName)) == null) {
            resource = this.findRequiredResource(name, packageName);
        }
        if (resource == null) {
            resource = this.findLocalResource(name);
        }
        return resource;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.isClosed()) {
            return null;
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException securityException) {
            try {
                this.bundle.framework.checkAdminPermission();
            }
            catch (SecurityException securityException2) {
                return null;
            }
        }
        String packageName = BundleLoader.getResourcePackageName(name);
        Enumeration result = null;
        if (packageName != null && (result = this.findImportedResources(name, packageName)) == null) {
            result = this.findRequiredResources(name, packageName);
        }
        if (result == null) {
            result = this.findLocalResources(name);
        }
        return result;
    }

    protected URL importResource(String name) {
        URL result = this.findLocalResource(name);
        return result;
    }

    protected URL findLocalResource(final String name) {
        if (System.getSecurityManager() == null) {
            return this.createClassLoader().findLocalResource(name);
        }
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createClassLoader().findLocalResource(name);
            }
        });
    }

    protected Enumeration importResources(String name) {
        Enumeration result = this.findLocalResources(name);
        return result;
    }

    protected Enumeration findLocalResources(String name) {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException securityException) {
            return null;
        }
        return this.createClassLoader().findLocalResources(name);
    }

    public String findLibrary(final String name) {
        if (this.isClosed()) {
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(name);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(name);
            }
        });
    }

    protected String findLocalLibrary(String name) {
        String result = this.bundle.getBundleData().findLibrary(name);
        if (result != null) {
            return result;
        }
        org.osgi.framework.Bundle[] fragments = this.bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        int i = 0;
        while (i < fragments.length) {
            result = ((Bundle)fragments[i]).getBundleData().findLibrary(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final ProtectionDomain pd, final String[] cp) {
        if (System.getSecurityManager() == null) {
            return this.bundle.getBundleData().createClassLoader(this, pd, cp);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.bundle.getBundleData().createClassLoader(BundleLoader.this, pd, cp);
            }
        });
    }

    protected boolean hasExportPackagePermission(String name) {
        ProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            return domain.implies((Permission)new PackagePermission(name, "export"));
        }
        return true;
    }

    protected boolean hasProvideBundlePermission(String uniqueId) {
        ProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            return domain.implies((Permission)new BundlePermission(uniqueId, "provide"));
        }
        return true;
    }

    protected boolean hasImportPackagePermission(String name) {
        ProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            return domain.implies((Permission)new PackagePermission(name, "import"));
        }
        return true;
    }

    protected boolean hasRequireBundlePermission(String uniqueId) {
        ProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            return domain.implies((Permission)new BundlePermission(uniqueId, "require"));
        }
        return true;
    }

    protected boolean hasHostBundlePermission(String uniqueId) {
        ProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            return domain.implies((Permission)new BundlePermission(uniqueId, "host"));
        }
        return true;
    }

    public String toString() {
        BundleData result = this.bundle.getBundleData();
        return result == null ? "BundleLoader.bundledata == null!" : result.toString();
    }

    protected void checkResourcePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.resourcePermission == null) {
                this.resourcePermission = new BundleResourcePermission(this.bundle.getBundleId());
            }
            sm.checkPermission(this.resourcePermission);
        }
    }

    protected BundleLoader getPackageExporter(String pkgname) {
        PackageSource exporter;
        if (this.importedPackages != null && (exporter = (PackageSource)this.importedPackages.getByKey(pkgname)) != null) {
            return exporter.getSupplier().getBundleLoader();
        }
        if (this.isDynamicallyImported(pkgname) && (exporter = (PackageSource)this.bundle.framework.packageAdmin.exportedPackages.getByKey(pkgname)) != null) {
            exporter.getSupplier().markUsed(this.bundle.getLoaderProxy());
            this.importedPackages.add(exporter);
            return exporter.getSupplier().getBundleLoader();
        }
        return null;
    }

    protected boolean isDynamicallyImported(String pkgname) {
        int i;
        if (!this.hasDynamicImports) {
            return false;
        }
        if (this.dynamicImportPackageAll) {
            return true;
        }
        String[] systemPackages = SystemBundleLoader.getSystemPackages();
        if (systemPackages != null) {
            i = 0;
            while (i < systemPackages.length) {
                if (pkgname.equals(systemPackages[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.dynamicImportPackages != null) {
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                if (pkgname.equals(this.dynamicImportPackages[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            i = 0;
            while (i < this.dynamicImportPackageStems.length) {
                if (pkgname.startsWith(this.dynamicImportPackageStems[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findImportedClass(String name, String packageName) throws ImportClassNotFoundException {
        Class result;
        block7: {
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "].findImportedClass(" + name + ")");
            }
            if (!this.hasImportedPackages) {
                return null;
            }
            result = null;
            try {
                BundleLoader exporter = this.getPackageExporter(packageName);
                if (exporter != null && (result = exporter.importClass(name)) == null) {
                    throw new ImportClassNotFoundException(name);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (result == null) {
                    if (!Debug.DEBUG_LOADER) throw throwable;
                    Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
                    throw throwable;
                }
                if (!Debug.DEBUG_LOADER) throw throwable;
                Debug.println("BundleLoader[" + this + "] found imported class " + name);
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (result != null) break block7;
                if (!Debug.DEBUG_LOADER) return result;
            }
            Debug.println("ImportClassLoader[" + this + "] class " + name + " not found in imported package " + packageName);
            return result;
        }
        if (!Debug.DEBUG_LOADER) return result;
        Debug.println("BundleLoader[" + this + "] found imported class " + name);
        return result;
    }

    protected void addExportedProvidersFor(String packageName, ArrayList result, KeyedHashSet visited) {
        PackageSource local;
        if (!visited.add(this.bundle)) {
            return;
        }
        if (this.requiredBundles != null) {
            int size = this.reexportTable == null ? 0 : this.reexportTable.length;
            int reexportIndex = 0;
            int i = 0;
            while (i < this.requiredBundles.length) {
                if (reexportIndex < size && this.reexportTable[reexportIndex] == i) {
                    ++reexportIndex;
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(packageName, result, visited);
                }
                ++i;
            }
        }
        if ((local = this.getProvidedPackage(packageName)) != null) {
            result.add(local.getSupplier());
        }
    }

    protected PackageSource getProvidersFor(String packageName) {
        PackageSource source;
        PackageSource result;
        if (this.requiredPackagesCache != null && (result = (PackageSource)this.requiredPackagesCache.getByKey(packageName)) != null) {
            if (result.isNullSource()) {
                return null;
            }
            return result;
        }
        if (this.requiredBundles == null) {
            return null;
        }
        KeyedHashSet visited = new KeyedHashSet(false);
        ArrayList result2 = new ArrayList(3);
        int i = 0;
        while (i < this.requiredBundles.length) {
            BundleLoader requiredLoader = this.requiredBundles[i].getBundleLoader();
            requiredLoader.addExportedProvidersFor(packageName, result2, visited);
            ++i;
        }
        if (this.requiredPackagesCache == null) {
            this.requiredPackagesCache = new KeyedHashSet();
        }
        if (result2.size() == 0) {
            this.requiredPackagesCache.add(new NullPackageSource(packageName));
            return null;
        }
        if (result2.size() == 1) {
            BundleLoaderProxy bundle = (BundleLoaderProxy)result2.get(0);
            source = new SingleSourcePackage(packageName, bundle);
            this.requiredPackagesCache.add(source);
            return source;
        }
        BundleLoaderProxy[] bundles = result2.toArray(new BundleLoaderProxy[result2.size()]);
        source = new MultiSourcePackage(packageName, bundles);
        this.requiredPackagesCache.add(source);
        return source;
    }

    protected Class findRequiredClass(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredClass(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            int i = 0;
            while (i < bundles.length) {
                Class result = bundles[i].getBundleLoader().importClass(name);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else {
            return source.getSupplier().getBundleLoader().importClass(name);
        }
        return null;
    }

    protected PackageSource getProvidedPackage(String name) {
        return this.providedPackages == null ? null : (PackageSource)this.providedPackages.getByKey(name);
    }

    protected URL findImportedResource(String name, String packageName) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResource(" + name + ")");
        }
        if (!this.hasImportedPackages) {
            return null;
        }
        BundleLoader exporter = this.getPackageExporter(packageName);
        if (exporter != null) {
            URL url = exporter.importResource(name);
            if (url != null) {
                return url;
            }
            if (Debug.DEBUG_LOADER) {
                Debug.println("ImportClassLoader[" + this + "] resource " + name + " not found in imported package " + packageName);
            }
            throw new ImportResourceNotFoundException(name);
        }
        return null;
    }

    protected URL findRequiredResource(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResource(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            int i = 0;
            while (i < bundles.length) {
                URL result = bundles[i].getBundleLoader().importResource(name);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else {
            return source.getSupplier().getBundleLoader().importResource(name);
        }
        return null;
    }

    protected Enumeration findImportedResources(String name, String packageName) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findImportedResources(" + name + ")");
        }
        if (!this.hasImportedPackages) {
            return null;
        }
        BundleLoader exporter = this.getPackageExporter(packageName);
        if (exporter != null) {
            return exporter.importResources(name);
        }
        return null;
    }

    protected Enumeration findRequiredResources(String name, String packageName) {
        PackageSource source;
        if (Debug.DEBUG_LOADER) {
            Debug.println("ImportClassLoader[" + this + "].findRequiredResources(" + name + ")");
        }
        if ((source = this.getProvidersFor(packageName)) == null) {
            return null;
        }
        if (source.isMultivalued()) {
            BundleLoaderProxy[] bundles = source.getSuppliers();
            int i = 0;
            while (i < bundles.length) {
                Enumeration result = bundles[i].getBundleLoader().importResources(name);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else {
            return source.getSupplier().getBundleLoader().importResources(name);
        }
        return null;
    }

    protected void initDynamicImportPackage(ManifestElement[] packages) {
        int i;
        ArrayList<String> names;
        ArrayList<String> stems;
        if (packages == null && SystemBundleLoader.getSystemPackages() == null) {
            return;
        }
        this.hasImportedPackages = true;
        this.hasDynamicImports = true;
        if (this.importedPackages == null) {
            this.importedPackages = new KeyedHashSet();
        }
        if (packages == null) {
            return;
        }
        int size = packages.length;
        if (this.dynamicImportPackageStems == null) {
            stems = new ArrayList<String>(size);
        } else {
            stems = new ArrayList(size + this.dynamicImportPackageStems.length);
            int i2 = 0;
            while (i2 < this.dynamicImportPackageStems.length) {
                stems.add(this.dynamicImportPackageStems[i2]);
                ++i2;
            }
        }
        if (this.dynamicImportPackages == null) {
            names = new ArrayList<String>(size);
        } else {
            names = new ArrayList(size + this.dynamicImportPackages.length);
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                names.add(this.dynamicImportPackages[i]);
                ++i;
            }
        }
        i = 0;
        while (i < size) {
            String name = packages[i].getValue();
            if (name.equals("*")) {
                this.dynamicImportPackageAll = true;
                return;
            }
            if (name.endsWith(".*")) {
                stems.add(name.substring(0, name.length() - 1));
            } else {
                names.add(name);
            }
            ++i;
        }
        size = stems.size();
        if (size > 0) {
            this.dynamicImportPackageStems = stems.toArray(new String[size]);
        }
        if ((size = names.size()) > 0) {
            this.dynamicImportPackages = names.toArray(new String[size]);
        }
    }

    protected void clear() {
        this.providedPackages = null;
        this.requiredBundles = null;
        this.importedPackages = null;
        this.dynamicImportPackages = null;
        this.dynamicImportPackageStems = null;
    }

    protected ClassLoader getClassLoader() {
        return this.classloader;
    }

    protected void attachFragment(BundleFragment fragment, Properties props) {
        this.initialize(this.bundle.getBundleDescription());
        if (this.classloader == null) {
            return;
        }
        try {
            String[] classpath = this.getClassPath(fragment, props);
            if (classpath != null) {
                this.classloader.attachFragment(fragment.getBundleData(), fragment.domain, classpath);
            } else {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.formatter.getString("BUNDLE_NO_CLASSPATH_MATCH")));
            }
        }
        catch (BundleException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    protected String[] getClassPath(Bundle bundle, Properties props) throws BundleException {
        String spec = bundle.getBundleData().getClassPath();
        ManifestElement[] classpathElements = ManifestElement.parseClassPath(spec);
        return this.matchClassPath(classpathElements, props);
    }

    protected String[] matchClassPath(ManifestElement[] classpath, Properties props) {
        if (classpath == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  no classpath");
            }
            return new String[]{"."};
        }
        ArrayList<String> result = new ArrayList<String>(10);
        int i = 0;
        while (i < classpath.length) {
            Filter filter = this.createFilter(classpath[i].getAttribute("filter"));
            if (filter == null || filter.match(props)) {
                if (Debug.DEBUG_LOADER) {
                    Debug.println("  found match for classpath entry " + classpath[i].getValue());
                }
                result.add(classpath[i].getValue());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected Filter createFilter(String filter) {
        if (filter == null) {
            return null;
        }
        try {
            return new Filter(filter);
        }
        catch (InvalidSyntaxException e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            return null;
        }
    }
}

