/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.IBundleStats;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleContext;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleHost
extends Bundle {
    protected BundleLoader loader = null;
    private BundleLoaderProxy proxy;
    protected BundleContext context = null;
    protected Vector fragments = null;

    public BundleHost(BundleData bundledata, String location, Framework framework, int startLevel) throws BundleException {
        super(bundledata, location, framework, startLevel);
    }

    protected BundleLoader basicGetBundleLoader() {
        return this.loader;
    }

    protected void load() throws BundleException {
        SecurityManager sm;
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.load called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.loader != null) {
                Debug.println("Bundle.load called when loader != null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        if (this.framework.isActive() && (sm = System.getSecurityManager()) != null) {
            PermissionCollection collection = this.framework.permissionAdmin.createPermissionCollection(this);
            this.domain = new ProtectionDomain(null, collection);
        }
        this.loader = null;
    }

    protected boolean unresolve() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy;
                if (this.isActive()) {
                    boolean suspended = this.framework.suspendBundle(this, true);
                    if (!suspended) {
                        throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION"));
                    }
                } else {
                    this.beginStateChange();
                }
                if (exporting = (curProxy = this.getLoaderProxy()).inUse()) {
                    curProxy.getBundleLoader();
                    this.framework.packageAdmin.addRemovalPending(curProxy);
                } else {
                    this.framework.packageAdmin.unexportResources(curProxy);
                    if (this.loader != null) {
                        this.loader.clear();
                        this.loader.close();
                    }
                    this.framework.bundles.unMarkDependancies(curProxy);
                }
                this.unresolveFragments();
                this.loader = null;
                this.fragments = null;
                this.proxy = null;
                this.state = 2;
                this.completeStateChange();
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected boolean reload(Bundle newBundle) throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy = this.getLoaderProxy();
                exporting = curProxy.inUse();
                if (exporting) {
                    curProxy.getBundleLoader();
                    this.framework.packageAdmin.addRemovalPending(curProxy);
                } else {
                    this.framework.packageAdmin.unexportResources(curProxy);
                    if (this.loader != null) {
                        this.loader.clear();
                        this.loader.close();
                    }
                    this.framework.bundles.unMarkDependancies(curProxy);
                }
                this.state = 2;
                this.loader = null;
                this.proxy = null;
                this.unresolveFragments();
                this.fragments = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        return exporting;
    }

    protected void unresolveFragments() {
        if (this.fragments != null) {
            Vector vector = this.fragments;
            synchronized (vector) {
                int size = this.fragments.size();
                int i = 0;
                while (i < size) {
                    BundleFragment fragment = (BundleFragment)this.fragments.elementAt(i);
                    fragment.unresolve();
                    ++i;
                }
            }
        }
    }

    protected void refresh() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.reload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            BundleLoaderProxy curProxy = this.getLoaderProxy();
            this.framework.packageAdmin.unexportResources(curProxy);
            if (this.loader != null) {
                this.loader.clear();
                this.loader.close();
            }
            this.framework.bundles.unMarkDependancies(curProxy);
            this.loader = null;
            this.proxy = null;
            this.fragments = null;
            this.state = 2;
        }
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy = this.getLoaderProxy();
                exporting = curProxy.inUse();
                if (exporting) {
                    curProxy.getBundleLoader();
                    this.framework.packageAdmin.addRemovalPending(curProxy);
                } else {
                    this.framework.packageAdmin.unexportResources(curProxy);
                    if (this.loader != null) {
                        this.loader.clear();
                        this.loader.close();
                    }
                    this.framework.bundles.unMarkDependancies(curProxy);
                }
                this.state = 2;
                this.loader = null;
                this.proxy = null;
                this.unresolveFragments();
                this.fragments = null;
                this.domain = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            this.framework.checkAdminPermission();
            this.checkValid();
        }
        if (Debug.DEBUG_GENERAL && (this.state & 0x38) == 0) {
            Debug.println("Bundle.loadClass(" + name + ") called when state != STARTING | ACTIVE | STOPPING: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.getBundleLoader();
        if (this.loader == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.loadClass(" + name + ") called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            throw new ClassNotFoundException(name);
        }
        return this.loader.loadClass(name);
    }

    public URL getResource(String name) {
        this.checkValid();
        this.getBundleLoader();
        if (this.loader == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.getResource(" + name + ") called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return this.loader.findResource(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startWorker(boolean persistent) throws BundleException {
        block16: {
            IBundleStats bundleStats;
            if (!this.framework.active) break block16;
            if ((this.state & 0x28) != 0) {
                return;
            }
            if (Debug.DEBUG_MONITOR_BUNDLES && (bundleStats = this.framework.adaptor.getBundleStats()) != null) {
                bundleStats.startActivation(this.getGlobalName());
            }
            try {
                if (this.state == 2) {
                    this.framework.packageAdmin.resolveBundles();
                    if (this.state != 4) {
                        throw new BundleException(this.getResolutionFailureMessage());
                    }
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Bundle: Active sl = " + this.framework.startLevelImpl.getStartLevel() + "; Bundle " + this.id + " sl = " + this.startLevel);
                }
                if (this.startLevel <= this.framework.startLevelImpl.getStartLevel()) {
                    this.state = 8;
                    this.context = this.createContext();
                    try {
                        this.context.start();
                        if (this.framework.active) {
                            this.state = 32;
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("->started " + this);
                            }
                            this.framework.publishBundleEvent(2, this);
                        }
                    }
                    catch (BundleException e) {
                        this.context.close();
                        this.context = null;
                        this.state = 4;
                        throw e;
                    }
                    if (this.state == 1) {
                        this.context.close();
                        this.context = null;
                        throw new BundleException(Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION"));
                    }
                }
            }
            catch (Throwable throwable) {
                IBundleStats bundleStats2;
                Object var3_5 = null;
                if (Debug.DEBUG_MONITOR_BUNDLES && (bundleStats2 = this.framework.adaptor.getBundleStats()) != null) {
                    bundleStats2.endActivation(this.getGlobalName());
                }
                throw throwable;
            }
            {
                IBundleStats bundleStats2;
                Object var3_6 = null;
                if (!Debug.DEBUG_MONITOR_BUNDLES || (bundleStats2 = this.framework.adaptor.getBundleStats()) == null) break block16;
                bundleStats2.endActivation(this.getGlobalName());
            }
        }
        if (persistent) {
            this.setStatus(1, true);
        }
    }

    protected BundleContext createContext() {
        return new BundleContext(this);
    }

    protected BundleContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopWorker(boolean persistent) throws BundleException {
        if (persistent) {
            this.setStatus(1, false);
        }
        if (!this.framework.active) return;
        if ((this.state & 0x16) != 0) {
            return;
        }
        this.state = 16;
        try {
            this.context.stop();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.context.close();
            this.context = null;
            this.checkValid();
            this.state = 4;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("->stopped " + this);
            }
            this.framework.publishBundleEvent(4, this);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.context.close();
            this.context = null;
        }
        this.checkValid();
        this.state = 4;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->stopped " + this);
        }
        this.framework.publishBundleEvent(4, this);
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getServicesInUse();
    }

    public org.osgi.framework.Bundle[] getFragments() {
        BundleHost bundleHost = this;
        synchronized (bundleHost) {
            if (this.fragments == null) {
                return null;
            }
            org.osgi.framework.Bundle[] result = new org.osgi.framework.Bundle[this.fragments.size()];
            this.fragments.toArray(result);
            return result;
        }
    }

    public void attachFragment(BundleFragment fragment) throws BundleException {
        if (this.fragments == null) {
            BundleHost bundleHost = this;
            synchronized (bundleHost) {
                if (this.fragments == null) {
                    this.fragments = new Vector(10);
                    this.fragments.addElement(fragment);
                }
            }
        }
        Vector vector = this.fragments;
        synchronized (vector) {
            int size = this.fragments.size();
            boolean inserted = false;
            int i = 0;
            while (i < size) {
                BundleFragment frag = (BundleFragment)this.fragments.elementAt(i);
                if (fragment.id < frag.id) {
                    if (this.loader != null) {
                        throw new BundleException(Msg.formatter.getString("FRAGMENT_ATTACHMENT ERROR"));
                    }
                    this.fragments.insertElementAt(fragment, i);
                    inserted = true;
                }
                ++i;
            }
            if (!inserted) {
                this.fragments.addElement(fragment);
            }
        }
        if (this.loader != null) {
            this.loader.attachFragment(fragment, System.getProperties());
        }
        if (this.state == 32 && this.context != null) {
            this.context.startFragment(fragment);
        }
    }

    public BundleLoader getBundleLoader() {
        if (this.loader == null) {
            BundleHost bundleHost = this;
            synchronized (bundleHost) {
                if (this.loader == null) {
                    try {
                        this.loader = new BundleLoader(this, this.getBundleDescription());
                        this.getLoaderProxy().setBundleLoader(this.loader);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }
        return this.loader;
    }

    protected void resolve() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.resolve called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.state = 4;
    }

    protected BundleLoaderProxy getLoaderProxy() {
        if (this.proxy == null) {
            BundleHost bundleHost = this;
            synchronized (bundleHost) {
                if (this.proxy == null) {
                    this.proxy = new BundleLoaderProxy(this);
                }
            }
        }
        return this.proxy;
    }
}

