/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleContext;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.ServiceReference;

public class BundleFragment
extends Bundle {
    protected BundleHost host = null;
    protected BundleActivator activator;

    public BundleFragment(BundleData bundledata, String location, Framework framework, int startLevel) throws BundleException {
        super(bundledata, location, framework, startLevel);
    }

    protected void load() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.load called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.framework.isActive()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                PermissionCollection collection = this.framework.permissionAdmin.createPermissionCollection(this);
                this.domain = new ProtectionDomain(null, collection);
            }
            try {
                this.bundledata.open();
            }
            catch (IOException e) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)e);
            }
        }
    }

    protected boolean unresolve() {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.framework.isActive()) {
            if (this.host != null && this.state == 4) {
                this.state = 2;
                this.host = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    protected boolean reload(Bundle newBundle) throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive() && this.host != null && this.state == 4) {
            exporting = this.host.unresolve();
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        return exporting;
    }

    protected void refresh() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.refresh called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            this.host = null;
            this.state = 2;
        }
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.host != null) {
                BundleHost resumeHost = this.host;
                if (this.state == 4) {
                    try {
                        exporting = this.host.unresolve();
                    }
                    catch (BundleException be) {
                        this.framework.publishFrameworkEvent(2, this, be);
                    }
                }
                if (!exporting) {
                    this.domain = null;
                    try {
                        this.bundledata.close();
                    }
                    catch (IOException iOException) {}
                }
                this.framework.resumeBundle(resumeHost);
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            this.framework.checkAdminPermission();
            this.checkValid();
        }
        if (this.host == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.loadClass(" + name + ") called when host == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            throw new ClassNotFoundException(name);
        }
        return this.host.loadClass(name, checkPermission);
    }

    public URL getResource(String name) {
        this.checkValid();
        if (this.host == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.getResource(" + name + ") called when host == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return this.host.getResource(name);
    }

    protected void startWorker(boolean persistent) throws BundleException {
        throw new BundleException(Msg.formatter.getString("FRAGMENT_CANNOT_START"));
    }

    protected void stopWorker(boolean persistent) throws BundleException {
        throw new BundleException(Msg.formatter.getString("FRAGMENT_CANNOT_STOP"));
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.host == null) {
            return null;
        }
        return this.host.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.host == null) {
            return null;
        }
        return this.host.getServicesInUse();
    }

    public org.osgi.framework.Bundle getHost() {
        return this.host;
    }

    public boolean isFragment() {
        return true;
    }

    protected boolean setHost(BundleHost value) {
        this.host = value;
        if (this.host != null) {
            try {
                this.host.attachFragment(this);
            }
            catch (BundleException be) {
                this.framework.publishFrameworkEvent(2, this.host, be);
                return false;
            }
        }
        return true;
    }

    protected boolean hasHostBundlePermission(String uniqueId) {
        if (this.domain != null) {
            return this.domain.implies((Permission)new BundlePermission(uniqueId, "host"));
        }
        return true;
    }

    public BundleLoader getBundleLoader() {
        return this.host == null ? null : this.host.getBundleLoader();
    }

    protected void resolve() {
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.resolve called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.host == null) {
                Debug.println("Bundle.resolve called when host == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        this.state = 4;
    }

    protected BundleContext getContext() {
        return this.host == null ? null : this.host.getContext();
    }
}

