/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventSource;
import org.eclipse.osgi.framework.internal.core.Bundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Filter;
import org.eclipse.osgi.framework.internal.core.FilteredServiceListener;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdmin;
import org.eclipse.osgi.framework.internal.core.ServiceReference;
import org.eclipse.osgi.framework.internal.core.ServiceRegistration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContext
implements org.osgi.framework.BundleContext,
EventSource {
    protected BundleHost bundle;
    protected Framework framework;
    protected Hashtable servicesInUse;
    protected EventListeners bundleEvent;
    protected EventListeners bundleEventSync;
    protected EventListeners serviceEvent;
    protected EventListeners frameworkEvent;
    protected BundleActivator activator;
    protected BundleActivator[] fragmentActivators;
    protected Object contextLock = new Object();

    protected BundleContext(BundleHost bundle) {
        this.bundle = bundle;
        this.framework = bundle.framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.serviceEvent = null;
        this.frameworkEvent = null;
        this.servicesInUse = null;
        this.activator = null;
        this.fragmentActivators = null;
    }

    protected void close() {
        this.bundle = null;
        if (this.serviceEvent != null) {
            this.framework.serviceEvent.removeListener(this);
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.framework.frameworkEvent.removeListener(this);
            this.frameworkEvent = null;
        }
        if (this.bundleEvent != null) {
            this.framework.bundleEvent.removeListener(this);
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.framework.bundleEventSync.removeListener(this);
            this.bundleEventSync = null;
        }
        Vector registeredServices = null;
        Object[] publishedReferences = null;
        int regSize = 0;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            registeredServices = this.framework.serviceRegistry.lookupServiceReferences(this);
            if (registeredServices != null) {
                regSize = registeredServices.size();
            }
            if (regSize > 0) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("Unregistering services");
                }
                publishedReferences = new ServiceReference[regSize];
                registeredServices.copyInto(publishedReferences);
            }
        }
        int i = 0;
        while (i < regSize) {
            try {
                ((ServiceReference)publishedReferences[i]).registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
            ++i;
        }
        registeredServices = null;
        if (this.servicesInUse != null) {
            int usedSize;
            ServiceReference[] usedRefs = null;
            Hashtable hashtable = this.servicesInUse;
            synchronized (hashtable) {
                usedSize = this.servicesInUse.size();
                if (usedSize > 0) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("Releasing services");
                    }
                    usedRefs = new ServiceReference[usedSize];
                    Enumeration enumeration = this.servicesInUse.keys();
                    int i2 = 0;
                    while (i2 < usedSize) {
                        usedRefs[i2] = (ServiceReference)enumeration.nextElement();
                        ++i2;
                    }
                }
            }
            int i3 = 0;
            while (i3 < usedSize) {
                usedRefs[i3].registration.releaseService(this);
                ++i3;
            }
            this.servicesInUse = null;
        }
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return this.framework.getProperty(key);
    }

    public org.osgi.framework.Bundle getBundle() {
        this.checkValid();
        return this.bundle;
    }

    public org.osgi.framework.Bundle installBundle(String location) throws BundleException {
        this.framework.checkAdminPermission();
        this.checkValid();
        return this.framework.installBundle(location);
    }

    public org.osgi.framework.Bundle installBundle(String location, InputStream in) throws BundleException {
        this.framework.checkAdminPermission();
        this.checkValid();
        return this.framework.installBundle(location, in);
    }

    public org.osgi.framework.Bundle getBundle(long id) {
        return this.framework.getBundle(id);
    }

    public Bundle getBundleByLocation(String location) {
        return this.framework.getBundleByLocation(location);
    }

    public org.osgi.framework.Bundle[] getBundles() {
        BundleRepository bundles;
        BundleRepository bundleRepository = bundles = this.framework.getBundles();
        synchronized (bundleRepository) {
            List allBundles = bundles.getBundles();
            int size = allBundles.size();
            if (size == 0) {
                return null;
            }
            org.osgi.framework.Bundle[] bundlelist = new Bundle[size];
            allBundles.toArray(bundlelist);
            return bundlelist;
        }
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("addServiceListener[" + this.bundle + "](" + listenerName + ", \"" + filter + "\")");
        }
        ServiceListener filteredListener = filter == null ? listener : new FilteredServiceListener(filter, listener);
        EventListeners eventListeners = this.framework.serviceEvent;
        synchronized (eventListeners) {
            if (this.serviceEvent == null) {
                this.serviceEvent = new EventListeners();
                this.framework.serviceEvent.addListener(this, this);
            } else {
                this.serviceEvent.removeListener(listener);
            }
            this.serviceEvent.addListener(listener, filteredListener);
        }
    }

    public void addServiceListener(ServiceListener listener) {
        block2: {
            try {
                this.addServiceListener(listener, null);
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("removeServiceListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (this.serviceEvent != null) {
            EventListeners eventListeners = this.framework.serviceEvent;
            synchronized (eventListeners) {
                this.serviceEvent.removeListener(listener);
            }
        }
    }

    public void addBundleListener(BundleListener listener) {
        EventListeners eventListeners;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("addBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission();
            eventListeners = this.framework.bundleEventSync;
            synchronized (eventListeners) {
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new EventListeners();
                    this.framework.bundleEventSync.addListener(this, this);
                } else {
                    this.bundleEventSync.removeListener(listener);
                }
                this.bundleEventSync.addListener(listener, listener);
            }
        }
        eventListeners = this.framework.bundleEvent;
        synchronized (eventListeners) {
            if (this.bundleEvent == null) {
                this.bundleEvent = new EventListeners();
                this.framework.bundleEvent.addListener(this, this);
            } else {
                this.bundleEvent.removeListener(listener);
            }
            this.bundleEvent.addListener(listener, listener);
        }
    }

    public void removeBundleListener(BundleListener listener) {
        EventListeners eventListeners;
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("removeBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (listener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission();
            if (this.bundleEventSync != null) {
                eventListeners = this.framework.bundleEventSync;
                synchronized (eventListeners) {
                    this.bundleEventSync.removeListener(listener);
                }
            }
        } else if (this.bundleEvent != null) {
            eventListeners = this.framework.bundleEvent;
            synchronized (eventListeners) {
                this.bundleEvent.removeListener(listener);
            }
        }
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("addFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        EventListeners eventListeners = this.framework.frameworkEvent;
        synchronized (eventListeners) {
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new EventListeners();
                this.framework.frameworkEvent.addListener(this, this);
            } else {
                this.frameworkEvent.removeListener(listener);
            }
            this.frameworkEvent.addListener(listener, listener);
        }
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        if (this.frameworkEvent != null) {
            EventListeners eventListeners = this.framework.frameworkEvent;
            synchronized (eventListeners) {
                this.frameworkEvent.removeListener(listener);
            }
        }
    }

    public org.osgi.framework.ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValid();
        if (service == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new NullPointerException(Msg.formatter.getString("SERVICE_ARGUMENT_NULL_EXCEPTION"));
        }
        int size = clazzes.length;
        if (size == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.formatter.getString("SERVICE_EMPTY_CLASS_LIST_EXCEPTION"));
        }
        String[] copy = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            copy[i] = new String(clazzes[i].getBytes());
            ++i;
        }
        clazzes = copy;
        this.framework.checkRegisterServicePermission(clazzes);
        if (!(service instanceof ServiceFactory)) {
            PackageAdmin cfr_ignored_0 = this.framework.packageAdmin;
            i = 0;
            while (i < size) {
                Class<?> clazz;
                try {
                    clazz = this.bundle.loadClass(clazzes[i], false);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Class.forName(clazzes[i]);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        if (Debug.DEBUG_SERVICES) {
                            Debug.println(String.valueOf(clazzes[i]) + " class not found");
                        }
                        throw new IllegalArgumentException(Msg.formatter.getString("SERVICE_CLASS_NOT_FOUND_EXCEPTION", clazzes[i]));
                    }
                }
                if (!clazz.isInstance(service)) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("Service object is not an instanceof " + clazzes[i]);
                    }
                    throw new IllegalArgumentException(Msg.formatter.getString("SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION", clazzes[i]));
                }
                ++i;
            }
        }
        return this.createServiceRegistration(clazzes, service, properties);
    }

    protected ServiceRegistration createServiceRegistration(String[] clazzes, Object service, Dictionary properties) {
        return new ServiceRegistration(this, clazzes, service, properties);
    }

    public org.osgi.framework.ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        String[] clazzes = new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public org.osgi.framework.ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getServiceReferences(" + clazz + ", \"" + filter + "\")");
        }
        return this.framework.getServiceReferences(clazz, filter);
    }

    public org.osgi.framework.ServiceReference getServiceReference(String clazz) {
        block12: {
            this.checkValid();
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + clazz + ")");
            }
            try {
                ServiceReference[] references = this.framework.getServiceReferences(clazz, null);
                if (references != null) {
                    int index = 0;
                    int length = references.length;
                    if (length > 1) {
                        int[] rankings = new int[length];
                        int count = 0;
                        int maxRanking = Integer.MIN_VALUE;
                        int i = 0;
                        while (i < length) {
                            int ranking;
                            rankings[i] = ranking = references[i].getRanking();
                            if (ranking > maxRanking) {
                                index = i;
                                maxRanking = ranking;
                                count = 1;
                            } else if (ranking == maxRanking) {
                                ++count;
                            }
                            ++i;
                        }
                        if (count > 1) {
                            long minId = Long.MAX_VALUE;
                            int i2 = 0;
                            while (i2 < length) {
                                long id;
                                if (rankings[i2] == maxRanking && (id = references[i2].getId()) < minId) {
                                    index = i2;
                                    minId = id;
                                }
                                ++i2;
                            }
                        }
                    }
                    return references[index];
                }
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block12;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public Object getService(org.osgi.framework.ServiceReference reference) {
        this.checkValid();
        if (this.servicesInUse == null) {
            Object object = this.contextLock;
            synchronized (object) {
                if (this.servicesInUse == null) {
                    this.servicesInUse = new Hashtable(17);
                }
            }
        }
        ServiceRegistration registration = ((ServiceReference)reference).registration;
        this.framework.checkGetServicePermission(registration.clazzes);
        return registration.getService(this);
    }

    public boolean ungetService(org.osgi.framework.ServiceReference reference) {
        this.checkValid();
        ServiceRegistration registration = ((ServiceReference)reference).registration;
        return registration.ungetService(this);
    }

    public File getDataFile(String filename) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, filename);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException be) {
                this.activator = null;
                throw be;
            }
        }
        if (this.bundle.fragments != null) {
            Vector vector = this.bundle.fragments;
            synchronized (vector) {
                Bundle fragment;
                this.fragmentActivators = new BundleActivator[this.bundle.fragments.size()];
                int i = 0;
                while (i < this.fragmentActivators.length) {
                    fragment = (BundleFragment)this.bundle.fragments.elementAt(i);
                    try {
                        this.fragmentActivators[i] = fragment.loadBundleActivator();
                    }
                    catch (Throwable t) {
                        this.framework.publishFrameworkEvent(2, fragment, t);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.fragmentActivators.length) {
                    fragment = (Bundle)this.bundle.fragments.elementAt(i);
                    if (this.fragmentActivators[i] != null) {
                        try {
                            fragment.state = 8;
                            this.startActivator(this.fragmentActivators[i]);
                            fragment.state = 32;
                            this.framework.publishBundleEvent(2, fragment);
                        }
                        catch (Throwable t) {
                            this.fragmentActivators[i] = null;
                            fragment.state = 4;
                            this.framework.publishFrameworkEvent(2, fragment, t);
                        }
                    } else {
                        fragment.state = 32;
                        this.framework.publishBundleEvent(2, fragment);
                    }
                    ++i;
                }
            }
        }
    }

    protected void startActivator(final BundleActivator bundleActivator) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (bundleActivator != null) {
                        bundleActivator.start((org.osgi.framework.BundleContext)BundleContext.this);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.printStackTrace(t2);
            }
            String clazz = null;
            clazz = bundleActivator.getClass().getName();
            throw new BundleException(Msg.formatter.getString("BUNDLE_ACTIVATOR_EXCEPTION", clazz, "start"), (Throwable)t2);
        }
    }

    protected void startFragment(BundleFragment fragment) {
        BundleActivator fragmentActivator = null;
        try {
            fragmentActivator = fragment.loadBundleActivator();
        }
        catch (Throwable t) {
            this.framework.publishFrameworkEvent(2, fragment, t);
        }
        if (fragmentActivator != null) {
            try {
                fragment.state = 8;
                this.startActivator(fragmentActivator);
                if (this.fragmentActivators != null) {
                    BundleActivator[] newFragmentActivators = new BundleActivator[this.fragmentActivators.length + 1];
                    System.arraycopy(this.fragmentActivators, 0, newFragmentActivators, 0, this.fragmentActivators.length);
                    newFragmentActivators[newFragmentActivators.length - 1] = fragmentActivator;
                    this.fragmentActivators = newFragmentActivators;
                } else {
                    this.fragmentActivators = new BundleActivator[]{fragmentActivator};
                }
                fragment.state = 32;
                this.framework.publishBundleEvent(2, fragment);
            }
            catch (Throwable t) {
                fragment.state = 4;
                this.framework.publishFrameworkEvent(2, fragment, t);
            }
        } else {
            fragment.state = 32;
            this.framework.publishBundleEvent(2, fragment);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() throws Exception {
                        if (BundleContext.this.fragmentActivators != null) {
                            int i = BundleContext.this.fragmentActivators.length - 1;
                            while (i >= 0) {
                                block9: {
                                    Bundle fragment = (Bundle)BundleContext.this.bundle.fragments.elementAt(i);
                                    if (BundleContext.this.fragmentActivators[i] != null) {
                                        Object var4_4;
                                        fragment.state = 16;
                                        try {
                                            try {
                                                BundleContext.this.fragmentActivators[i].stop((org.osgi.framework.BundleContext)BundleContext.this);
                                            }
                                            catch (Throwable t) {
                                                BundleContext.this.framework.publishFrameworkEvent(2, fragment, t);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            var4_4 = null;
                                            fragment.state = 4;
                                            BundleContext.this.framework.publishBundleEvent(4, fragment);
                                            throw throwable;
                                        }
                                        {
                                            var4_4 = null;
                                            fragment.state = 4;
                                            BundleContext.this.framework.publishBundleEvent(4, fragment);
                                            break block9;
                                        }
                                    }
                                    fragment.state = 4;
                                    BundleContext.this.framework.publishBundleEvent(4, fragment);
                                }
                                --i;
                            }
                        }
                        if (BundleContext.this.activator != null) {
                            BundleContext.this.activator.stop((org.osgi.framework.BundleContext)BundleContext.this);
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t2);
                }
                String clazz = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(Msg.formatter.getString("BUNDLE_ACTIVATOR_EXCEPTION", clazz, "stop"), (Throwable)t2);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.activator = null;
            this.fragmentActivators = null;
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.activator = null;
            this.fragmentActivators = null;
            return;
        }
    }

    protected ServiceReference[] getRegisteredServices() {
        ServiceReference[] references = null;
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            Vector services = this.framework.serviceRegistry.lookupServiceReferences(this);
            if (services == null) {
                return null;
            }
            int i = services.size() - 1;
            while (i >= 0) {
                ServiceReference ref = (ServiceReference)services.elementAt(i);
                String[] classes = ref.getClasses();
                try {
                    this.framework.checkGetServicePermission(classes);
                }
                catch (SecurityException securityException) {
                    services.removeElementAt(i);
                }
                --i;
            }
            if (services.size() > 0) {
                references = new ServiceReference[services.size()];
                services.toArray(references);
            }
        }
        return references;
    }

    protected ServiceReference[] getServicesInUse() {
        if (this.servicesInUse == null) {
            return null;
        }
        Hashtable hashtable = this.servicesInUse;
        synchronized (hashtable) {
            int size = this.servicesInUse.size();
            if (size == 0) {
                return null;
            }
            ServiceReference[] references = new ServiceReference[size];
            int refcount = 0;
            Enumeration enumeration = this.servicesInUse.keys();
            int i = 0;
            while (i < size) {
                block10: {
                    ServiceReference reference = (ServiceReference)enumeration.nextElement();
                    try {
                        this.framework.checkGetServicePermission(reference.registration.clazzes);
                    }
                    catch (SecurityException securityException) {
                        break block10;
                    }
                    references[refcount] = reference;
                    ++refcount;
                }
                ++i;
            }
            if (refcount < size) {
                if (refcount == 0) {
                    return null;
                }
                ServiceReference[] refs = references;
                references = new ServiceReference[refcount];
                System.arraycopy(refs, 0, references, 0, refcount);
            }
            return references;
        }
    }

    public void dispatchEvent(Object originalListener, Object l, int action, Object object) {
        block12: {
            BundleHost tmpBundle = this.bundle;
            try {
                if (tmpBundle != null) {
                    switch (action) {
                        case 1: 
                        case 2: {
                            BundleListener listener = (BundleListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
                                Debug.println("dispatchBundleEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.bundleChanged((BundleEvent)object);
                            break;
                        }
                        case 3: {
                            ServiceEvent event = (ServiceEvent)object;
                            if (!this.hasListenServicePermission(event)) break;
                            ServiceListener listener = (ServiceListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
                                Debug.println("dispatchServiceEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.serviceChanged(event);
                            break;
                        }
                        case 4: {
                            FrameworkListener listener = (FrameworkListener)l;
                            if (Debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
                                Debug.println("dispatchFrameworkEvent[" + tmpBundle + "](" + listenerName + ")");
                            }
                            listener.frameworkEvent((FrameworkEvent)object);
                        }
                    }
                }
            }
            catch (Throwable t) {
                FrameworkEvent event;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in bottom level event dispatcher: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) break block12;
                this.framework.publishFrameworkEvent(2, tmpBundle, t);
            }
        }
    }

    protected boolean hasListenServicePermission(ServiceEvent event) {
        ProtectionDomain domain = this.bundle.getProtectionDomain();
        if (domain != null) {
            ServiceReference reference = (ServiceReference)event.getServiceReference();
            String[] names = reference.registration.clazzes;
            int len = names.length;
            int i = 0;
            while (i < len) {
                if (domain.implies((Permission)new ServicePermission(names[i], "get"))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public org.osgi.framework.Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return new Filter(filter);
    }

    protected void checkValid() {
        if (this.bundle == null) {
            throw new IllegalStateException(Msg.formatter.getString("BUNDLE_CONTEXT_INVALID_EXCEPTION"));
        }
    }

    public org.osgi.framework.Bundle[] getBundles(String uniqueId) {
        return this.framework.getBundleByUniqueId(uniqueId);
    }

    public org.osgi.framework.Bundle getBundle(String uniqueId) {
        org.osgi.framework.Bundle[] bundles = this.getBundles(uniqueId);
        return bundles == null ? null : bundles[0];
    }

    public org.osgi.framework.Bundle getBundleFor(Object object) {
        ClassLoader cl = object.getClass().getClassLoader();
        if (cl == null) {
            return null;
        }
        if (cl instanceof BundleClassLoader) {
            return this.framework.getBundleByClassLoader((BundleClassLoader)cl);
        }
        return null;
    }
}

