/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContext;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.NothingToUpdateException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public abstract class Bundle
implements org.osgi.framework.Bundle,
Comparable,
KeyedElement {
    protected Framework framework;
    protected volatile int state = 2;
    protected volatile Thread stateChanging = null;
    protected BundleData bundledata;
    protected long id;
    protected String location;
    protected Object statechangeLock = new Object();
    protected ProtectionDomain domain;
    protected int startLevel;
    protected BundleException resolveException;

    protected static Bundle createBundle(BundleData bundledata, String location, Framework framework, int startLevel) throws BundleException {
        if (bundledata.isFragment()) {
            return new BundleFragment(bundledata, location, framework, startLevel);
        }
        return new BundleHost(bundledata, location, framework, startLevel);
    }

    protected Bundle(BundleData bundledata, String location, Framework framework, int startLevel) throws BundleException {
        this.id = bundledata.getBundleID();
        this.bundledata = bundledata;
        this.location = location;
        this.framework = framework;
        this.startLevel = startLevel;
        bundledata.setBundle(this);
    }

    protected abstract void load() throws BundleException;

    protected abstract boolean reload(Bundle var1) throws BundleException;

    protected abstract void refresh() throws BundleException;

    protected abstract boolean unload();

    protected void close() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.close called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.state = 1;
    }

    protected BundleActivator loadBundleActivator() throws BundleException {
        String activatorClassName = this.bundledata.getActivator();
        if (activatorClassName != null) {
            try {
                Class activatorClass = this.loadClass(activatorClassName, false);
                return (BundleActivator)activatorClass.newInstance();
            }
            catch (Throwable t) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t);
                }
                throw new BundleException(Msg.formatter.getString("BUNDLE_INVALID_ACTIVATOR_EXCEPTION", activatorClassName), t);
            }
        }
        return null;
    }

    protected abstract Class loadClass(String var1, boolean var2) throws ClassNotFoundException;

    public abstract URL getResource(String var1);

    public int getState() {
        return this.state;
    }

    protected boolean isActive() {
        return (this.state & 0x28) != 0;
    }

    protected boolean isResolved() {
        return (this.state & 3) == 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws BundleException {
        long start = 0L;
        if (Debug.DEBUG_BUNDLE_TIME) {
            start = System.currentTimeMillis();
            System.out.println("Starting " + this.getGlobalName());
        }
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.startWorker(true);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.completeStateChange();
            if (Debug.DEBUG_BUNDLE_TIME) {
                System.out.println("End starting " + this.getGlobalName() + " " + (System.currentTimeMillis() - start));
            }
            return;
        }
    }

    protected abstract void startWorker(boolean var1) throws BundleException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resume() throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            this.startWorker(false);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws BundleException {
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.stopWorker(true);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    protected abstract void stopWorker(boolean var1) throws BundleException;

    protected void setStatus(final int mask, final boolean state) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException, IOException {
                    boolean test;
                    int status = Bundle.this.bundledata.getStatus();
                    boolean bl = test = (status & mask) != 0;
                    if (test != state) {
                        Bundle.this.bundledata.setStatus(state ? status | mask : status & ~mask);
                        Bundle.this.bundledata.save();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            this.framework.publishFrameworkEvent(2, this, pae.getException());
        }
    }

    /*
     * Exception decompiling
     */
    protected void suspend(boolean lock) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 38->42)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.location);
        }
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            try {
                this.updateWorker(new PrivilegedExceptionAction(){

                    public Object run() throws BundleException {
                        String updateLocation = Bundle.this.location;
                        if (Bundle.this.bundledata.getManifest().get("Bundle-UpdateLocation") != null) {
                            updateLocation = (String)Bundle.this.bundledata.getManifest().get("Bundle-UpdateLocation");
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("   from location: " + updateLocation);
                            }
                        }
                        URLConnection source = Bundle.this.framework.adaptor.mapLocationToURLConnection(updateLocation);
                        Bundle.this.updateWorkerPrivileged(source);
                        return null;
                    }
                });
            }
            catch (BundleException e) {
                if (!(e.getNestedException() instanceof NothingToUpdateException)) {
                    throw e;
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(final InputStream in) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.location);
            Debug.println("   from: " + in);
        }
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.updateWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    BundleSource source = new BundleSource(in);
                    Bundle.this.updateWorkerPrivileged(source);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void updateWorker(PrivilegedExceptionAction action) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 193->197)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateWorkerPrivileged(URLConnection source) throws BundleException {
        Bundle oldBundle = Bundle.createBundle(this.bundledata, this.location, this.framework, this.startLevel);
        boolean reloaded = false;
        BundleOperation storage = this.framework.adaptor.updateBundle(this.bundledata, source);
        BundleRepository bundles = this.framework.getBundles();
        try {
            boolean exporting;
            BundleData newBundleData = storage.begin();
            Bundle newBundle = this.framework.createBundle(newBundleData, this.location, this.startLevel);
            Bundle installedBundle = this.framework.getBundleByUniqueId(newBundle.getGlobalName(), newBundle.getVersion().toString());
            if (installedBundle != null && installedBundle != this) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_INSTALL_SAME_UNIQUEID", newBundle.getGlobalName(), newBundle.getVersion().toString()));
            }
            String[] nativepaths = this.framework.selectNativeCode(newBundle);
            if (nativepaths != null) {
                this.bundledata.installNativeCode(nativepaths);
            }
            BundleRepository bundleRepository = bundles;
            synchronized (bundleRepository) {
                bundles.markDependancies();
                exporting = this.reload(newBundle);
            }
            reloaded = true;
            storage.commit(exporting);
        }
        catch (BundleException e) {
            block12: {
                try {
                    storage.undo();
                    if (!reloaded) break block12;
                    BundleRepository newBundle = bundles;
                    synchronized (newBundle) {
                        this.reload(oldBundle);
                    }
                }
                catch (BundleException ee) {
                    this.framework.publishFrameworkEvent(2, this, ee);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("uninstall location: " + this.location);
        }
        this.framework.checkAdminPermission();
        this.checkValid();
        this.beginStateChange();
        try {
            this.uninstallWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    Bundle.this.uninstallWorkerPrivileged();
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void uninstallWorker(PrivilegedExceptionAction action) throws BundleException {
        block21: {
            bundleActive = false;
            host = null;
            if (this.isFragment()) {
                host = (Bundle)this.getHost();
                bundleActive = host == null ? false : host.state == 32;
            } else {
                v0 = bundleActive = this.state == 32;
            }
            if (bundleActive) {
                try {
                    if (this.isFragment()) {
                        host.stopWorker(true);
                    } else {
                        this.stopWorker(true);
                    }
                }
                catch (BundleException e) {
                    this.framework.publishFrameworkEvent(2, this, e);
                }
            }
            try {
                try {
                    AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    if (bundleActive == false) throw (BundleException)pae.getException();
                    try {
                        if (this.isFragment()) {
                            host.startWorker(false);
                        } else {
                            this.startWorker(false);
                        }
                    }
                    catch (BundleException e) {
                        this.framework.publishFrameworkEvent(2, this, e);
                    }
                    bundleActive = false;
                    throw (BundleException)pae.getException();
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                if (this.isFragment() == false) throw var7_7;
                if (bundleActive == false) throw var7_7;
                try {
                    host.startWorker(false);
                    throw var7_7;
                }
                catch (BundleException e) {
                    this.framework.publishFrameworkEvent(2, this, e);
                }
                throw var7_7;
            }
            {
                var6_9 = null;
                if (!this.isFragment() || !bundleActive) break block21;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 182->190)] { 
lbl50:
            // 1 sources

            host.startWorker(false);
            break block21;
lbl52:
            // 1 sources

            catch (BundleException e) {
                this.framework.publishFrameworkEvent(2, this, e);
            }
        }
        this.framework.publishBundleEvent(16, this);
    }

    protected void uninstallWorkerPrivileged() throws BundleException {
        boolean unloaded = false;
        BundleOperation storage = this.framework.adaptor.uninstallBundle(this.bundledata);
        BundleRepository bundles = this.framework.getBundles();
        try {
            boolean exporting;
            storage.begin();
            BundleRepository bundleRepository = bundles;
            synchronized (bundleRepository) {
                bundles.markDependancies();
                bundles.remove(this);
                exporting = this.unload();
            }
            unloaded = true;
            storage.commit(exporting);
            this.close();
        }
        catch (BundleException e) {
            block10: {
                try {
                    storage.undo();
                    if (!unloaded) break block10;
                    BundleRepository bundleRepository = bundles;
                    synchronized (bundleRepository) {
                        this.load();
                        bundles.add(this);
                    }
                }
                catch (BundleException ee) {
                    this.framework.publishFrameworkEvent(2, this, ee);
                }
            }
            throw e;
        }
    }

    public Dictionary getHeaders() {
        this.framework.checkAdminPermission();
        return this.bundledata.getHeaders();
    }

    public long getBundleId() {
        return this.id;
    }

    public String getLocation() {
        this.framework.checkAdminPermission();
        return this.location;
    }

    public abstract ServiceReference[] getRegisteredServices();

    public abstract ServiceReference[] getServicesInUse();

    public boolean hasPermission(Object permission) {
        this.checkValid();
        if (this.domain != null) {
            if (permission instanceof Permission) {
                return this.domain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    protected void beginStateChange() throws BundleException {
        Object object = this.statechangeLock;
        synchronized (object) {
            boolean doubleFault = false;
            while (true) {
                if (this.stateChanging == null) {
                    this.stateChanging = Thread.currentThread();
                    return;
                }
                if (doubleFault || this.stateChanging == Thread.currentThread()) {
                    throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION"));
                }
                try {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(" Waiting for state to change in bundle " + this);
                    }
                    long start = 0L;
                    start = System.currentTimeMillis();
                    this.statechangeLock.wait(5000L);
                    long end = System.currentTimeMillis();
                    if (end - start > 0L) {
                        System.out.println("Waiting... : " + this.getGlobalName() + " " + (end - start));
                    }
                }
                catch (InterruptedException interruptedException) {}
                doubleFault = true;
            }
        }
    }

    protected void completeStateChange() {
        Object object = this.statechangeLock;
        synchronized (object) {
            if (this.stateChanging != null) {
                this.stateChanging = null;
                this.statechangeLock.notify();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.location) + " [" + this.id + "]";
    }

    public int compareTo(Object obj) {
        int slcomp = this.startLevel - ((Bundle)obj).startLevel;
        if (slcomp != 0) {
            return slcomp;
        }
        long idcomp = this.id - ((Bundle)obj).id;
        return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
    }

    protected void checkValid() {
        if (this.state == 1) {
            throw new IllegalStateException(Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION"));
        }
    }

    protected ProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    protected void unresolvePermissions(Hashtable unresolvedPackages) {
        if (this.domain != null) {
            BundlePermissionCollection collection = (BundlePermissionCollection)this.domain.getPermissions();
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unresolving permissions in bundle " + this);
            }
            collection.unresolvePermissions(unresolvedPackages);
        }
    }

    public org.osgi.framework.Bundle[] getFragments() {
        this.checkValid();
        return null;
    }

    public boolean isFragment() {
        return false;
    }

    public org.osgi.framework.Bundle getHost() {
        this.checkValid();
        return null;
    }

    public Class loadClass(String classname) throws ClassNotFoundException {
        return this.loadClass(classname, true);
    }

    public Enumeration getEntryPaths(final String path) {
        try {
            this.framework.checkAdminPermission();
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (this.bundledata == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.getResourcePaths(" + path + ") called when bundledata == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Bundle.this.bundledata.getEntryPaths(path);
            }
        });
    }

    public URL getEntry(String fileName) throws IOException {
        try {
            this.framework.checkAdminPermission();
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (this.bundledata == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.getFile(" + fileName + ") called when bundledata == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.bundledata.getEntry(fileName);
        }
        final String ffileName = fileName;
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Bundle.this.bundledata.getEntry(ffileName);
            }
        });
    }

    public String getGlobalName() {
        return this.bundledata.getUniqueId();
    }

    public BundleData getBundleData() {
        return this.bundledata;
    }

    public org.eclipse.osgi.framework.adaptor.Version getVersion() {
        return this.bundledata.getVersion();
    }

    protected BundleDescription getBundleDescription() {
        return this.framework.adaptor.getState().getBundle(this.getBundleId());
    }

    public abstract BundleLoader getBundleLoader();

    protected abstract void resolve();

    protected abstract boolean unresolve() throws BundleException;

    protected abstract BundleContext getContext();

    protected String getResolutionFailureMessage() {
        String defaultMessage = Msg.formatter.getString("BUNDLE_UNRESOLVED_EXCEPTION");
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return defaultMessage;
        }
        if (bundleDescription.isResolved()) {
            throw new IllegalStateException("bundle *is* resolved");
        }
        VersionConstraint[] unsatisfied = bundleDescription.getUnsatisfiedConstraints();
        if (unsatisfied.length == 0) {
            return Msg.formatter.getString("BUNDLE_UNRESOLVED_NOT_CHOSEN_EXCEPTION");
        }
        StringBuffer missing = new StringBuffer();
        int i = 0;
        while (i < unsatisfied.length) {
            if (unsatisfied[i] instanceof PackageSpecification) {
                missing.append(Msg.formatter.getString("BUNDLE_UNRESOLVED_PACKAGE", this.toString(unsatisfied[i])));
            } else if (unsatisfied[i] instanceof BundleSpecification) {
                missing.append(Msg.formatter.getString("BUNDLE_UNRESOLVED_BUNDLE", this.toString(unsatisfied[i])));
            } else {
                missing.append(Msg.formatter.getString("BUNDLE_UNRESOLVED_HOST", this.toString(unsatisfied[i])));
            }
            missing.append(',');
            ++i;
        }
        missing.deleteCharAt(missing.length() - 1);
        return Msg.formatter.getString("BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION", missing.toString());
    }

    private String toString(VersionConstraint constraint) {
        Version versionSpec = constraint.getVersionSpecification();
        if (versionSpec == null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionSpec;
    }

    public int getKeyHashCode() {
        return (int)this.id;
    }

    public boolean compare(KeyedElement other) {
        return this.id == ((Bundle)other).getBundleId();
    }

    public Object getKey() {
        return new Long(this.id);
    }
}

