/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventSource;

class ListenerList {
    final ListenerList list;
    final Object listener;
    final Object object;
    static final boolean DEBUG = true;

    private ListenerList(ListenerList oldlist, Object l, Object o) {
        this.list = oldlist;
        this.listener = l;
        this.object = o;
    }

    static ListenerList addListener(ListenerList oldlist, Object l, Object o) {
        return new ListenerList(oldlist, l, o);
    }

    static ListenerList removeListener(ListenerList oldlist, Object l) {
        if (oldlist != null) {
            try {
                return oldlist.removeListener(l);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return oldlist;
    }

    private ListenerList removeListener(Object l) throws IllegalArgumentException {
        if (this.listener == l) {
            return this.list;
        }
        if (this.list != null) {
            ListenerList ll = this.list.removeListener(l);
            return new ListenerList(ll, this.listener, this.object);
        }
        throw new IllegalArgumentException();
    }

    void dispatchEvent(EventSource source, int action, Object object) {
        ListenerList ll = this;
        while (ll != null) {
            try {
                source.dispatchEvent(ll.listener, ll.object, action, object);
            }
            catch (Throwable t) {
                System.out.println("Exception in " + ll.listener);
                t.printStackTrace();
            }
            ll = ll.list;
        }
    }
}

