/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventSource;
import org.eclipse.osgi.framework.eventmgr.ListenerList;

class EventThread
extends Thread {
    private EventThreadItem head;
    private EventThreadItem tail;
    private volatile boolean running;

    EventThread(String threadName) {
        super(threadName);
        this.init();
    }

    EventThread() {
        this.init();
    }

    void init() {
        this.running = true;
        this.head = null;
        this.tail = null;
        this.setDaemon(true);
        this.start();
    }

    void close() {
        this.running = false;
        this.interrupt();
    }

    public void run() {
        while (this.running) {
            try {
                this.getNextEvent().dispatchEvent();
            }
            catch (Throwable throwable) {}
        }
    }

    synchronized void postEvent(ListenerList l, EventSource s, int a, Object o) {
        EventThreadItem item = new EventThreadItem(l, s, a, o);
        if (this.head == null) {
            this.head = item;
            this.tail = item;
        } else {
            this.tail.next = item;
            this.tail = item;
        }
        this.notify();
    }

    private synchronized EventThreadItem getNextEvent() throws InterruptedException {
        while (this.running && this.head == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.running) {
            throw new InterruptedException();
        }
        EventThreadItem item = this.head;
        this.head = item.next;
        if (this.head == null) {
            this.tail = null;
        }
        return item;
    }

    static class EventThreadItem {
        private final ListenerList listeners;
        private final EventSource source;
        private final int action;
        private final Object object;
        EventThreadItem next;

        EventThreadItem(ListenerList l, EventSource s, int a, Object o) {
            this.listeners = l;
            this.source = s;
            this.action = a;
            this.object = o;
            this.next = null;
        }

        void dispatchEvent() {
            this.listeners.dispatchEvent(this.source, this.action, this.object);
        }
    }
}

