/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventSource;
import org.eclipse.osgi.framework.eventmgr.EventThread;
import org.eclipse.osgi.framework.eventmgr.ListenerList;

public class EventManager {
    protected EventThread thread = null;
    protected String threadName;

    public EventManager() {
    }

    public EventManager(String threadName) {
        this();
        this.threadName = threadName;
    }

    public synchronized void close() {
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
    }

    void dispatchEventAsynchronous(ListenerList ll, int eventAction, Object eventObject) {
        EventThread thread = this.getEventThread();
        while (ll != null) {
            thread.postEvent((ListenerList)ll.listener, (EventSource)ll.object, eventAction, eventObject);
            ll = ll.list;
        }
    }

    void dispatchEventSynchronous(ListenerList ll, int eventAction, Object eventObject) {
        while (ll != null) {
            ((ListenerList)ll.listener).dispatchEvent((EventSource)ll.object, eventAction, eventObject);
            ll = ll.list;
        }
    }

    private synchronized EventThread getEventThread() {
        if (this.thread == null) {
            this.thread = this.threadName == null ? new EventThread() : new EventThread(this.threadName);
        }
        return this.thread;
    }
}

