/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;

public class DebugOptions
implements org.eclipse.osgi.service.debug.DebugOptions {
    Properties options = null;
    private static DebugOptions singleton = null;
    private static boolean debugEnabled = true;
    private static final String OPTIONS = ".options";

    public static DebugOptions getDefault() {
        DebugOptions result;
        if (singleton == null && debugEnabled && (debugEnabled = (result = new DebugOptions()).isDebugEnabled())) {
            singleton = result;
        }
        return singleton;
    }

    private DebugOptions() {
        this.loadOptions();
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = this.getOption(option);
        return optionValue != null && optionValue.equalsIgnoreCase("true") || defaultValue;
    }

    public String getOption(String option) {
        return this.options != null ? this.options.getProperty(option) : null;
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public void setOption(String option, String value) {
        if (this.options != null) {
            this.options.put(option, value.trim());
        }
    }

    public boolean isDebugEnabled() {
        return this.options != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        URL optionsFile;
        String debugOptionsFilename = System.getProperty("osgi.debug");
        if (debugOptionsFilename == null) {
            return;
        }
        this.options = new Properties();
        if (debugOptionsFilename.length() == 0) {
            String userDir = System.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!userDir.endsWith("/")) {
                userDir = String.valueOf(userDir) + "/";
            }
            debugOptionsFilename = "file:" + userDir + OPTIONS;
        }
        try {
            optionsFile = this.getURL(debugOptionsFilename);
        }
        catch (MalformedURLException e) {
            System.out.println("Unable to construct URL for options file: " + debugOptionsFilename);
            e.printStackTrace(System.out);
            return;
        }
        System.out.println("Debug-Options:\n    " + debugOptionsFilename);
        try {
            InputStream input = optionsFile.openStream();
            try {
                this.options.load(input);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                input.close();
                throw throwable;
            }
            {
                Object var4_8 = null;
                input.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            System.out.println("Could not parse the options file: " + optionsFile);
            e.printStackTrace(System.out);
        }
        Iterator<Object> i = this.options.keySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                if (this.options.size() == 0) {
                    this.options = null;
                }
                return;
            }
            Object key = i.next();
            this.options.put(key, ((String)this.options.get(key)).trim());
        }
    }

    private URL getURL(String urlString) throws MalformedURLException {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            try {
                return new File(urlString).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw e;
            }
        }
    }
}

