/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.util.Hashtable;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistry
implements org.eclipse.osgi.framework.adaptor.ServiceRegistry {
    protected Hashtable publishedServicesByClass;
    protected Vector allPublishedServices;
    protected Hashtable publishedServicesByContext;

    public void initialize() {
        this.publishedServicesByClass = new Hashtable(53);
        this.publishedServicesByContext = new Hashtable(53);
        this.allPublishedServices = new Vector(50, 20);
    }

    public void publishService(BundleContext context, ServiceRegistration serviceReg) {
        Vector<ServiceRegistration> contextServices = (Vector<ServiceRegistration>)this.publishedServicesByContext.get(context);
        if (contextServices == null) {
            contextServices = new Vector<ServiceRegistration>(10, 10);
            this.publishedServicesByContext.put(context, contextServices);
        }
        contextServices.addElement(serviceReg);
        String[] clazzes = (String[])serviceReg.getReference().getProperty("objectClass");
        int size = clazzes.length;
        int i = 0;
        while (i < size) {
            String clazz = clazzes[i];
            Vector<ServiceRegistration> services = (Vector<ServiceRegistration>)this.publishedServicesByClass.get(clazz);
            if (services == null) {
                services = new Vector<ServiceRegistration>(10, 10);
                this.publishedServicesByClass.put(clazz, services);
            }
            services.addElement(serviceReg);
            ++i;
        }
        this.allPublishedServices.addElement(serviceReg);
    }

    public void unpublishService(BundleContext context, ServiceRegistration serviceReg) {
        Vector contextServices = (Vector)this.publishedServicesByContext.get(context);
        if (contextServices != null) {
            contextServices.removeElement(serviceReg);
        }
        String[] clazzes = (String[])serviceReg.getReference().getProperty("objectClass");
        int size = clazzes.length;
        int i = 0;
        while (i < size) {
            String clazz = clazzes[i];
            Vector services = (Vector)this.publishedServicesByClass.get(clazz);
            services.removeElement(serviceReg);
            ++i;
        }
        this.allPublishedServices.removeElement(serviceReg);
    }

    public void unpublishServices(BundleContext context) {
        Vector serviceRegs = (Vector)this.publishedServicesByContext.get(context);
        if (serviceRegs != null) {
            this.publishedServicesByContext.remove(context);
            int size = serviceRegs.size();
            int i = 0;
            while (i < size) {
                ServiceRegistration serviceReg = (ServiceRegistration)serviceRegs.elementAt(i);
                this.allPublishedServices.removeElement(serviceReg);
                String[] clazzes = (String[])serviceReg.getReference().getProperty("objectClass");
                int numclazzes = clazzes.length;
                int j = 0;
                while (j < numclazzes) {
                    String clazz = clazzes[j];
                    Vector services = (Vector)this.publishedServicesByClass.get(clazz);
                    services.removeElement(serviceReg);
                    ++j;
                }
                ++i;
            }
        }
    }

    public Vector lookupServiceReferences(String clazz, Filter filter) {
        Vector<ServiceReference> references = new Vector<ServiceReference>();
        if (clazz == null) {
            Vector serviceRegs = this.allPublishedServices;
            if (serviceRegs == null) {
                return null;
            }
            int size = serviceRegs.size();
            if (size == 0) {
                return null;
            }
            int i = 0;
            while (i < size) {
                ServiceRegistration registration = (ServiceRegistration)serviceRegs.elementAt(i);
                ServiceReference reference = registration.getReference();
                if (filter == null || filter.match(reference)) {
                    references.addElement(reference);
                }
                ++i;
            }
        } else {
            Vector serviceRegs = (Vector)this.publishedServicesByClass.get(clazz);
            if (serviceRegs == null) {
                return null;
            }
            int size = serviceRegs.size();
            if (size == 0) {
                return null;
            }
            int i = 0;
            while (i < size) {
                ServiceRegistration registration = (ServiceRegistration)serviceRegs.elementAt(i);
                ServiceReference reference = registration.getReference();
                if (filter == null || filter.match(reference)) {
                    references.addElement(reference);
                }
                ++i;
            }
        }
        if (references.size() == 0) {
            return null;
        }
        return references;
    }

    public Vector lookupServiceReferences(BundleContext context) {
        Vector<ServiceReference> references = new Vector<ServiceReference>();
        Vector serviceRegs = (Vector)this.publishedServicesByContext.get(context);
        if (serviceRegs == null) {
            return null;
        }
        int size = serviceRegs.size();
        if (size == 0) {
            return null;
        }
        int i = 0;
        while (i < size) {
            ServiceRegistration registration = (ServiceRegistration)serviceRegs.elementAt(i);
            ServiceReference reference = registration.getReference();
            references.addElement(reference);
            ++i;
        }
        if (references.size() == 0) {
            return null;
        }
        return references;
    }
}

