/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class AbstractFrameworkAdaptor
implements FrameworkAdaptor {
    protected EventPublisher eventPublisher;
    protected ServiceRegistry serviceRegistry;
    protected Properties properties;
    protected BundleContext context;
    protected int vic;
    protected int vci;
    protected int hic;
    protected float hlf;
    protected int initialBundleStartLevel = 1;

    public void initialize(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.serviceRegistry = new ServiceRegistry();
        this.serviceRegistry.initialize();
        this.loadProperties();
        this.vic = 10;
        this.vci = 10;
        this.hic = 10;
        this.hlf = 0.75f;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public URLConnection mapLocationToURLConnection(String location) throws BundleException {
        try {
            return new URL(location).openConnection();
        }
        catch (IOException e) {
            throw new BundleException(Msg.formatter.getString("ADAPTOR_URL_CREATE_EXCEPTION", location), (Throwable)e);
        }
    }

    public long getTotalFreeSpace() throws IOException {
        return -1L;
    }

    public org.eclipse.osgi.framework.adaptor.ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public int getVectorInitialCapacity() {
        return this.vic;
    }

    public int getVectorCapacityIncrement() {
        return this.vci;
    }

    public int getHashtableInitialCapacity() {
        return this.hic;
    }

    public float getHashtableLoadFactor() {
        return this.hlf;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        this.context = context;
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.context = null;
    }

    public String getExportPackages() {
        return null;
    }

    public String getExportServices() {
        return null;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadProperties() {
        this.properties = new Properties();
        String resource = System.getProperty("org.eclipse.osgi.framework.internal.core.properties", "osgi.properties");
        try {
            InputStream in = null;
            File file = new File(resource);
            if (file.exists()) {
                in = new FileInputStream(file);
            }
            if (in == null) {
                in = this.getClass().getResourceAsStream(resource);
            }
            if (in == null) {
                if (!Debug.DEBUG_GENERAL) return;
                Debug.println("Skipping osgi.properties: " + resource);
                return;
            }
            try {
                this.properties.load(new BufferedInputStream(in));
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var4_7 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                in.close();
                return;
            }
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return;
            Debug.println("Unable to load osgi.properties: " + e.getMessage());
        }
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int value) {
        this.initialBundleStartLevel = value;
    }
}

