/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class AbstractBundleData
implements BundleData {
    protected Dictionary manifest = null;
    protected Bundle bundle;

    public Dictionary getManifest() throws BundleException {
        if (this.manifest == null) {
            AbstractBundleData abstractBundleData = this;
            synchronized (abstractBundleData) {
                if (this.manifest == null) {
                    URL url = this.getEntry("META-INF/MANIFEST.MF");
                    if (url == null) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_NOT_FOUND_EXCEPTION", "META-INF/MANIFEST.MF", this.getLocation()));
                    }
                    try {
                        this.manifest = Headers.parseManifest(url.openStream());
                    }
                    catch (IOException e) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_NOT_FOUND_EXCEPTION", "META-INF/MANIFEST.MF", this.getLocation()), (Throwable)e);
                    }
                }
            }
        }
        return this.manifest;
    }

    public Dictionary getHeaders() {
        try {
            return this.getManifest();
        }
        catch (BundleException bundleException) {
            return null;
        }
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }
}

