/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor;

import java.util.StringTokenizer;
import java.util.Vector;

public final class Version
implements Comparable {
    private int major = 0;
    private int minor = 0;
    private int service = 0;
    private String qualifier = "";
    private static final String SEPARATOR = ".";
    public static Version emptyVersion = new Version(0, 0, 0);

    public Version(Version version) {
        this(version.major, version.minor, version.service, version.qualifier);
    }

    public Version(int major, int minor, int service) {
        this(major, minor, service, null);
    }

    public Version(int major, int minor, int service, String qualifier) throws IllegalArgumentException {
        if (major < 0) {
            throw new IllegalArgumentException("Negative major");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Negative minor");
        }
        if (service < 0) {
            throw new IllegalArgumentException("Negative service");
        }
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = minor;
        this.service = service;
        this.qualifier = Version.verifyQualifier(qualifier);
    }

    public Version(String versionId) {
        if (versionId == null) {
            versionId = "0.0.0";
        }
        Object[] parts = Version.parseVersion(versionId);
        this.major = (Integer)parts[0];
        this.minor = (Integer)parts[1];
        this.service = (Integer)parts[2];
        this.qualifier = (String)parts[3];
    }

    public static RuntimeException validateVersion(String version) {
        try {
            Version.parseVersion(version);
        }
        catch (RuntimeException e) {
            return e;
        }
        return null;
    }

    private static Object[] parseVersion(String versionId) {
        if (versionId == null) {
            throw new IllegalArgumentException("Null version string");
        }
        String s = versionId.trim();
        if (s.equals("")) {
            throw new IllegalArgumentException("Empty version string");
        }
        if (s.startsWith(SEPARATOR)) {
            throw new IllegalArgumentException("Invalid version format");
        }
        if (s.endsWith(SEPARATOR)) {
            throw new IllegalArgumentException("Invalid version format");
        }
        if (s.indexOf("..") != -1) {
            throw new IllegalArgumentException("Invalid version format");
        }
        StringTokenizer st = new StringTokenizer(s, SEPARATOR);
        Vector<String> elements = new Vector<String>(4);
        while (st.hasMoreTokens()) {
            elements.addElement(st.nextToken());
        }
        int elementSize = elements.size();
        if (elementSize <= 0) {
            throw new IllegalArgumentException("Invalid version format (no token)");
        }
        if (elementSize > 4) {
            throw new IllegalArgumentException("Invalid version format (more than 4 tokens)");
        }
        int[] numbers = new int[3];
        try {
            numbers[0] = Integer.parseInt((String)elements.elementAt(0));
            if (numbers[0] < 0) {
                throw new IllegalArgumentException("Negative major");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid major");
        }
        try {
            if (elementSize >= 2) {
                numbers[1] = Integer.parseInt((String)elements.elementAt(1));
                if (numbers[1] < 0) {
                    throw new IllegalArgumentException("Negative minor");
                }
            } else {
                numbers[1] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid minor");
        }
        try {
            if (elementSize >= 3) {
                numbers[2] = Integer.parseInt((String)elements.elementAt(2));
                if (numbers[2] < 0) {
                    throw new IllegalArgumentException("Invalid service");
                }
            } else {
                numbers[2] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid service");
        }
        Object[] result = new Object[]{new Integer(numbers[0]), new Integer(numbers[1]), new Integer(numbers[2]), elementSize >= 4 ? Version.verifyQualifier((String)elements.elementAt(3)) : ""};
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        Version v = (Version)object;
        return v.getMajorComponent() == this.major && v.getMinorComponent() == this.minor && v.getServiceComponent() == this.service && v.getQualifierComponent().equals(this.qualifier);
    }

    public int hashCode() {
        int code = this.major + this.minor + this.service;
        if (this.qualifier.equals("")) {
            return code;
        }
        return code + this.qualifier.hashCode();
    }

    public int getMajorComponent() {
        return this.major;
    }

    public int getMinorComponent() {
        return this.minor;
    }

    public int getServiceComponent() {
        return this.service;
    }

    public String getQualifierComponent() {
        return this.qualifier;
    }

    public boolean isGreaterOrEqualTo(Version id) {
        if (id == null) {
            return false;
        }
        if (this.major > id.getMajorComponent()) {
            return true;
        }
        if (this.major == id.getMajorComponent() && this.minor > id.getMinorComponent()) {
            return true;
        }
        if (this.major == id.getMajorComponent() && this.minor == id.getMinorComponent() && this.service > id.getServiceComponent()) {
            return true;
        }
        return this.major == id.getMajorComponent() && this.minor == id.getMinorComponent() && this.service == id.getServiceComponent() && this.qualifier.compareTo(id.getQualifierComponent()) >= 0;
    }

    public boolean isCompatibleWith(Version id) {
        if (id == null) {
            return false;
        }
        if (this.major != id.getMajorComponent()) {
            return false;
        }
        if (this.minor > id.getMinorComponent()) {
            return true;
        }
        if (this.minor < id.getMinorComponent()) {
            return false;
        }
        if (this.service > id.getServiceComponent()) {
            return true;
        }
        if (this.service < id.getServiceComponent()) {
            return false;
        }
        return this.qualifier.compareTo(id.getQualifierComponent()) >= 0;
    }

    public boolean isEquivalentTo(Version id) {
        if (id == null) {
            return false;
        }
        if (this.major != id.getMajorComponent()) {
            return false;
        }
        if (this.minor != id.getMinorComponent()) {
            return false;
        }
        if (this.service > id.getServiceComponent()) {
            return true;
        }
        if (this.service < id.getServiceComponent()) {
            return false;
        }
        return this.qualifier.compareTo(id.getQualifierComponent()) >= 0;
    }

    public boolean isPerfect(Version id) {
        if (id == null) {
            return false;
        }
        return this.major == id.getMajorComponent() && this.minor == id.getMinorComponent() && this.service == id.getServiceComponent() && this.qualifier.equals(id.getQualifierComponent());
    }

    public boolean isGreaterThan(Version id) {
        if (id == null) {
            return this.major != 0 || this.minor != 0 || this.service != 0 || !this.qualifier.equals("");
        }
        if (this.major > id.getMajorComponent()) {
            return true;
        }
        if (this.major < id.getMajorComponent()) {
            return false;
        }
        if (this.minor > id.getMinorComponent()) {
            return true;
        }
        if (this.minor < id.getMinorComponent()) {
            return false;
        }
        if (this.service > id.getServiceComponent()) {
            return true;
        }
        if (this.service < id.getServiceComponent()) {
            return false;
        }
        return this.qualifier.compareTo(id.getQualifierComponent()) > 0;
    }

    public String toString() {
        String base = String.valueOf(this.major) + SEPARATOR + this.minor + SEPARATOR + this.service;
        if (this.qualifier.equals("")) {
            return base;
        }
        return String.valueOf(base) + SEPARATOR + this.qualifier;
    }

    private static String verifyQualifier(String s) {
        char[] chars = s.trim().toCharArray();
        boolean whitespace = false;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                chars[i] = 45;
                whitespace = true;
            }
            ++i;
        }
        return whitespace ? new String(chars) : s;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Version)) {
            throw new ClassCastException();
        }
        Version cfr_ignored_0 = (Version)o;
        if (this.equals(o)) {
            return 0;
        }
        if (this.isGreaterThan((Version)o)) {
            return 1;
        }
        return -1;
    }
}

