/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor;

import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.ImportResourceNotFoundException;
import org.eclipse.osgi.framework.debug.Debug;

public abstract class BundleClassLoader
extends ClassLoader {
    protected ClassLoaderDelegate delegate;
    protected ProtectionDomain hostdomain;
    protected String[] hostclasspath;
    protected boolean closed = false;
    protected static ParentClassLoader defaultParentClassLoader = new ParentClassLoader();
    protected ClassLoader parentClassLoader;

    public BundleClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath) {
        this(delegate, domain, classpath, null);
    }

    public BundleClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, ClassLoader parent) {
        this.delegate = delegate;
        this.hostdomain = domain;
        this.hostclasspath = classpath;
        this.parentClassLoader = parent == null ? defaultParentClassLoader : parent;
    }

    public abstract void initialize();

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.closed) {
            throw new ClassNotFoundException(name);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ")");
        }
        try {
            try {
                return this.parentClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class clazz = this.delegate.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (Error e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ") failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + name + ") failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
    }

    protected abstract Class findClass(String var1) throws ClassNotFoundException;

    public URL getResource(String name) {
        if (this.closed) {
            return null;
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + name + ")");
        }
        try {
            URL url = this.parentClassLoader.getResource(name);
            if (url != null) {
                return url;
            }
            url = this.delegate.findResource(name);
            if (url != null) {
                return url;
            }
        }
        catch (ImportResourceNotFoundException importResourceNotFoundException) {}
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + name + ") failed.");
        }
        return null;
    }

    protected abstract URL findResource(String var1);

    protected Enumeration findResources(String name) throws IOException {
        try {
            return this.delegate.findResources(name);
        }
        catch (Exception e) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].findResources(" + name + ") failed.");
                Debug.printStackTrace(e);
            }
            return null;
        }
    }

    protected String findLibrary(String libname) {
        return this.delegate.findLibrary(libname);
    }

    public URL findLocalResource(String resource) {
        return this.findResource(resource);
    }

    public abstract Enumeration findLocalResources(String var1);

    public Class findLocalClass(String classname) throws ClassNotFoundException {
        return this.findClass(classname);
    }

    public void close() {
        this.closed = false;
    }

    public abstract void attachFragment(BundleData var1, ProtectionDomain var2, String[] var3);

    protected static class ParentClassLoader
    extends ClassLoader {
        protected ParentClassLoader() {
            super(null);
        }
    }
}

