/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.eval.EvaluationResult;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTEvaluationEngine;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTInstructionCompiler;
import org.eclipse.jdt.internal.debug.eval.ast.engine.EvaluationEngineMessages;
import org.eclipse.jdt.internal.debug.eval.ast.engine.EvaluationSourceGenerator;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.Interpreter;
import org.eclipse.jdt.internal.debug.eval.ast.engine.JavaObjectRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.RuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionSequence;

public class ASTEvaluationEngine
implements IAstEvaluationEngine {
    private IJavaProject fProject;
    private IJavaDebugTarget fDebugTarget;

    public ASTEvaluationEngine(IJavaProject project, IJavaDebugTarget debugTarget) {
        this.setJavaProject(project);
        this.setDebugTarget(debugTarget);
    }

    public void setJavaProject(IJavaProject project) {
        this.fProject = project;
    }

    public void setDebugTarget(IJavaDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    public void evaluate(String snippet, IJavaStackFrame frame, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        ICompiledExpression expression = this.getCompiledExpression(snippet, frame);
        this.evaluateExpression(expression, frame, listener, evaluationDetail, hitBreakpoints);
    }

    public void evaluate(String snippet, IJavaObject thisContext, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        ICompiledExpression expression = this.getCompiledExpression(snippet, thisContext);
        this.evaluateExpression(expression, thisContext, thread, listener, evaluationDetail, hitBreakpoints);
    }

    public void evaluateExpression(ICompiledExpression expression, IJavaStackFrame frame, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        RuntimeContext context = new RuntimeContext(this.getJavaProject(), frame);
        this.doEvaluation(expression, context, (IJavaThread)frame.getThread(), listener, evaluationDetail, hitBreakpoints);
    }

    public void evaluateExpression(ICompiledExpression expression, IJavaObject thisContext, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        JavaObjectRuntimeContext context = new JavaObjectRuntimeContext(thisContext, this.getJavaProject(), thread);
        this.doEvaluation(expression, context, thread, listener, evaluationDetail, hitBreakpoints);
    }

    private void doEvaluation(ICompiledExpression expression, IRuntimeContext context, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        if (expression instanceof InstructionSequence) {
            if (thread.isSuspended() && ((JDIThread)thread).isInvokingMethod() || thread.isPerformingEvaluation() && evaluationDetail == 64) {
                EvaluationResult result = new EvaluationResult(this, expression.getSnippet(), thread);
                result.addError(EvaluationEngineMessages.getString("ASTEvaluationEngine.Cannot_perform_nested_evaluations"));
                listener.evaluationComplete(result);
                return;
            }
        } else {
            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, EvaluationEngineMessages.getString("ASTEvaluationEngine.AST_evaluation_engine_cannot_evaluate_expression"), null));
        }
        thread.queueRunnable(new EvalRunnable((InstructionSequence)expression, thread, context, listener, evaluationDetail, hitBreakpoints));
    }

    public ICompiledExpression getCompiledExpression(String snippet, IJavaStackFrame frame) {
        IJavaProject javaProject = this.getJavaProject();
        RuntimeContext context = new RuntimeContext(javaProject, frame);
        EvaluationSourceGenerator mapper = null;
        CompilationUnit unit = null;
        try {
            IJavaVariable[] localsVar = context.getLocals();
            int numLocalsVar = localsVar.length;
            IJavaVariable[] locals = new IJavaVariable[numLocalsVar];
            int numLocals = 0;
            int i = 0;
            while (i < numLocalsVar) {
                if (!this.isLocalType(localsVar[i].getReferenceTypeName())) {
                    locals[numLocals++] = localsVar[i];
                }
                ++i;
            }
            String[] localTypesNames = new String[numLocals];
            String[] localVariables = new String[numLocals];
            int i2 = 0;
            while (i2 < numLocals) {
                localVariables[i2] = locals[i2].getName();
                localTypesNames[i2] = locals[i2].getReferenceTypeName();
                ++i2;
            }
            mapper = new EvaluationSourceGenerator(localTypesNames, localVariables, snippet);
            unit = AST.parseCompilationUnit((char[])mapper.getSource(frame).toCharArray(), (String)mapper.getCompilationUnitName(), (IJavaProject)javaProject);
        }
        catch (CoreException e) {
            InstructionSequence expression = new InstructionSequence(snippet);
            expression.addError(e.getStatus().getMessage());
            return expression;
        }
        return this.createExpressionFromAST(snippet, mapper, unit);
    }

    private boolean isLocalType(String typeName) {
        StringTokenizer strTok = new StringTokenizer(typeName, "$");
        strTok.nextToken();
        while (strTok.hasMoreTokens()) {
            char char0 = strTok.nextToken().charAt(0);
            if ('0' > char0 || char0 > '9') continue;
            return true;
        }
        return false;
    }

    public ICompiledExpression getCompiledExpression(String snippet, IJavaObject thisContext) {
        if (thisContext instanceof IJavaArray) {
            InstructionSequence errorExpression = new InstructionSequence(snippet);
            errorExpression.addError(EvaluationEngineMessages.getString("ASTEvaluationEngine.Cannot_perform_an_evaluation_in_the_context_of_an_array_instance_1"));
        }
        IJavaProject javaProject = this.getJavaProject();
        EvaluationSourceGenerator mapper = null;
        CompilationUnit unit = null;
        mapper = new EvaluationSourceGenerator(new String[0], new String[0], snippet);
        try {
            unit = AST.parseCompilationUnit((char[])mapper.getSource(thisContext, javaProject).toCharArray(), (String)mapper.getCompilationUnitName(), (IJavaProject)javaProject);
        }
        catch (CoreException e) {
            InstructionSequence expression = new InstructionSequence(snippet);
            expression.addError(e.getStatus().getMessage());
            return expression;
        }
        return this.createExpressionFromAST(snippet, mapper, unit);
    }

    private ICompiledExpression createExpressionFromAST(String snippet, EvaluationSourceGenerator mapper, CompilationUnit unit) {
        IProblem[] problems = unit.getProblems();
        if (problems.length != 0) {
            boolean snippetError = false;
            boolean runMethodError = false;
            InstructionSequence errorSequence = new InstructionSequence(snippet);
            int codeSnippetStart = mapper.getSnippetStart();
            int codeSnippetEnd = codeSnippetStart + mapper.getSnippet().length();
            int runMethodStart = mapper.getRunMethodStart();
            int runMethodEnd = runMethodStart + mapper.getRunMethodLength();
            int i = 0;
            while (i < problems.length) {
                IProblem problem = problems[i];
                int errorOffset = problem.getSourceStart();
                if (problem.isError() && problem.getID() != 67108969) {
                    if (codeSnippetStart <= errorOffset && errorOffset <= codeSnippetEnd) {
                        errorSequence.addError(problem.getMessage());
                        snippetError = true;
                    } else if (runMethodStart <= errorOffset && errorOffset <= runMethodEnd) {
                        runMethodError = true;
                    }
                }
                ++i;
            }
            if (snippetError || runMethodError) {
                if (runMethodError) {
                    errorSequence.addError(EvaluationEngineMessages.getString("ASTEvaluationEngine.Evaluations_must_contain_either_an_expression_or_a_block_of_well-formed_statements_1"));
                }
                return errorSequence;
            }
        }
        ASTInstructionCompiler visitor = new ASTInstructionCompiler(mapper.getSnippetStart(), snippet);
        unit.accept((ASTVisitor)visitor);
        return visitor.getInstructions();
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public IJavaDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void dispose() {
    }

    class EvalRunnable
    implements Runnable {
        private InstructionSequence fExpression;
        private IJavaThread fThread;
        private int fEvaluationDetail;
        private boolean fHitBreakpoints;
        private IRuntimeContext fContext;
        private IEvaluationListener fListener;

        public EvalRunnable(InstructionSequence expression, IJavaThread thread, IRuntimeContext context, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) {
            this.fExpression = expression;
            this.fThread = thread;
            this.fContext = context;
            this.fListener = listener;
            this.fEvaluationDetail = evaluationDetail;
            this.fHitBreakpoints = hitBreakpoints;
        }

        public void run() {
            EvaluationResult result = new EvaluationResult(ASTEvaluationEngine.this, this.fExpression.getSnippet(), this.fThread);
            if (this.fExpression.hasErrors()) {
                String[] errors = this.fExpression.getErrorMessages();
                int i = 0;
                int numErrors = errors.length;
                while (i < numErrors) {
                    result.addError(errors[i]);
                    ++i;
                }
                this.evaluationFinished(result);
                return;
            }
            Interpreter interpreter = new Interpreter(this.fExpression, this.fContext);
            class EvaluationRunnable
            implements IEvaluationRunnable,
            ITerminate {
                CoreException fException;
                final /* synthetic */ EvalRunnable this$1;
                private final /* synthetic */ Interpreter val$interpreter;

                EvaluationRunnable(EvalRunnable evalRunnable, Interpreter interpreter) {
                    this.this$1 = evalRunnable;
                    this.val$interpreter = interpreter;
                }

                public void run(IJavaThread jt, IProgressMonitor pm) {
                    try {
                        this.val$interpreter.execute();
                    }
                    catch (CoreException exception) {
                        this.fException = exception;
                        if (EvalRunnable.access$0(this.this$1) == 64 && exception.getStatus().getException() instanceof InvocationException) {
                            InvocationException invocationException = (InvocationException)exception.getStatus().getException();
                            ObjectReference exObject = invocationException.exception();
                            IJavaObject modelObject = (IJavaObject)((Object)JDIValue.createValue((JDIDebugTarget)EvalRunnable.access$1(this.this$1).getDebugTarget(), exObject));
                            try {
                                modelObject.sendMessage("printStackTrace", "()V", null, jt, false);
                            }
                            catch (DebugException debugException) {}
                        }
                    }
                    catch (Throwable exception) {
                        JDIDebugPlugin.log(exception);
                        this.fException = new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 4, EvaluationEngineMessages.getString("ASTEvaluationEngine.Runtime_exception_occurred_during_evaluation._See_log_for_details"), exception));
                    }
                }

                public void terminate() {
                    this.val$interpreter.stop();
                }

                public boolean canTerminate() {
                    return true;
                }

                public boolean isTerminated() {
                    return false;
                }

                public CoreException getException() {
                    return this.fException;
                }
            }
            EvaluationRunnable er = new EvaluationRunnable(this, interpreter);
            Throwable exception = null;
            try {
                this.fThread.runEvaluation(er, null, this.fEvaluationDetail, this.fHitBreakpoints);
            }
            catch (DebugException e) {
                exception = e;
            }
            IJavaValue value = interpreter.getResult();
            if (exception == null) {
                exception = er.getException();
            }
            if (value != null) {
                result.setValue(value);
            } else {
                result.addError(EvaluationEngineMessages.getString("ASTEvaluationEngine.An_unknown_error_occurred_during_evaluation"));
            }
            if (exception != null) {
                if (exception instanceof DebugException) {
                    result.setException((DebugException)exception);
                } else {
                    result.setException(new DebugException(exception.getStatus()));
                }
            }
            this.evaluationFinished(result);
        }

        private void evaluationFinished(IEvaluationResult result) {
            if (JDIDebugPlugin.getDefault() != null) {
                this.fListener.evaluationComplete(result);
            }
        }

        static /* synthetic */ int access$0(EvalRunnable evalRunnable) {
            return evalRunnable.fEvaluationDetail;
        }

        static /* synthetic */ ASTEvaluationEngine access$1(EvalRunnable evalRunnable) {
            return evalRunnable.ASTEvaluationEngine.this;
        }
    }
}

