/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdi.hcr.ReferenceType;
import org.eclipse.jdi.hcr.VirtualMachine;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.EvaluationManager;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.internal.debug.core.EventDispatcher;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.JDIVoidValue;

public class JDIDebugTarget
extends JDIDebugElement
implements IJavaDebugTarget,
ILaunchListener {
    private ArrayList fThreads;
    private IProcess fProcess;
    private com.sun.jdi.VirtualMachine fVirtualMachine;
    private boolean fSupportsTerminate;
    private boolean fTerminated;
    private boolean fTerminating;
    private boolean fDisconnected;
    private boolean fSupportsDisconnect;
    private List fBreakpoints;
    private Set fOutOfSynchTypes;
    private boolean fHasHCROccurred;
    private String fName;
    private EventDispatcher fEventDispatcher = null;
    private ThreadStartHandler fThreadStartHandler = null;
    private boolean fSuspended = true;
    private boolean fResumeOnStartup = false;
    private ILaunch fLaunch;
    private int fSuspendCount = 0;
    private HashMap fEngines;
    private String[] fStepFilters = null;
    private int fStepFilterMask = 0;
    private static final int STEP_FILTERS_ENABLED = 1;
    private static final int FILTER_SYNTHETICS = 2;
    private static final int FILTER_STATIC_INITIALIZERS = 4;
    private static final int FILTER_CONSTRUCTORS = 8;
    private static final int XOR_MASK = 4095;
    private boolean fIsPerformingHotCodeReplace = false;
    static /* synthetic */ Class class$0;

    public JDIDebugTarget(ILaunch launch, com.sun.jdi.VirtualMachine jvm, String name, boolean supportTerminate, boolean supportDisconnect, IProcess process, boolean resume) {
        super(null);
        this.setLaunch(launch);
        this.setResumeOnStartup(resume);
        this.setDebugTarget(this);
        this.setSupportsTerminate(supportTerminate);
        this.setSupportsDisconnect(supportDisconnect);
        this.setVM(jvm);
        jvm.setDebugTraceMode(0);
        this.setProcess(process);
        this.setTerminated(false);
        this.setTerminating(false);
        this.setDisconnected(false);
        this.setName(name);
        this.setBreakpoints(new ArrayList(5));
        this.setThreadList(new ArrayList(5));
        this.setOutOfSynchTypes(new ArrayList(0));
        this.setHCROccurred(false);
        this.initialize();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public EventDispatcher getEventDispatcher() {
        return this.fEventDispatcher;
    }

    private void setEventDispatcher(EventDispatcher dispatcher) {
        this.fEventDispatcher = dispatcher;
    }

    private ArrayList getThreadList() {
        return this.fThreads;
    }

    private Iterator getThreadIterator() {
        List threadList;
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            threadList = (List)this.getThreadList().clone();
        }
        Iterator threads = threadList.iterator();
        return threads;
    }

    private void setThreadList(ArrayList threads) {
        this.fThreads = threads;
    }

    public List getBreakpoints() {
        return this.fBreakpoints;
    }

    private void setBreakpoints(List breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public void handleVMStart(VMStartEvent event) {
        if (this.isResumeOnStartup()) {
            try {
                this.setSuspended(true);
                this.resume();
            }
            catch (DebugException e) {
                this.logError((Exception)((Object)e));
            }
        }
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            JDIThread thread = (JDIThread)threads[i];
            if (thread.isSuspended()) {
                try {
                    boolean suspended = thread.getUnderlyingThread().isSuspended();
                    if (!suspended) {
                        thread.setRunning(true);
                        thread.fireResumeEvent(32);
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                }
                catch (ObjectCollectedException objectCollectedException) {
                }
                catch (RuntimeException e) {
                    this.logError(e);
                }
            }
            ++i;
        }
    }

    protected synchronized void initialize() {
        this.setEventDispatcher(new EventDispatcher(this));
        this.setRequestTimeout(JDIDebugModel.getPreferences().getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT));
        this.initializeRequests();
        this.initializeState();
        this.initializeBreakpoints();
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            new Thread((Runnable)dispatcher, String.valueOf(JDIDebugModel.getPluginIdentifier()) + JDIDebugModelMessages.getString("JDIDebugTarget.JDI_Event_Dispatcher")).start();
        }
    }

    protected void initializeState() {
        List<ThreadReference> threads = null;
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            try {
                threads = vm.allThreads();
            }
            catch (RuntimeException e) {
                this.internalError(e);
            }
            if (threads != null) {
                Iterator<ThreadReference> initialThreads = threads.iterator();
                while (initialThreads.hasNext()) {
                    this.createThread(initialThreads.next());
                }
            }
        }
        if (this.isResumeOnStartup()) {
            this.setSuspended(false);
        }
    }

    protected void initializeRequests() {
        this.setThreadStartHandler(new ThreadStartHandler());
        new ThreadDeathHandler();
    }

    protected void initializeBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this);
        IBreakpoint[] bps = manager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < bps.length) {
            if (bps[i] instanceof IJavaBreakpoint) {
                this.breakpointAdded(bps[i]);
            }
            ++i;
        }
    }

    protected JDIThread createThread(ThreadReference thread) {
        JDIThread jdiThread = null;
        try {
            jdiThread = new JDIThread(this, thread);
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        if (this.isDisconnected()) {
            return null;
        }
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            this.getThreadList().add(jdiThread);
        }
        jdiThread.fireCreationEvent();
        return jdiThread;
    }

    public IThread[] getThreads() {
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            return this.getThreadList().toArray(new IThread[0]);
        }
    }

    public boolean canResume() {
        return this.isSuspended() && this.isAvailable() && !this.isPerformingHotCodeReplace();
    }

    public boolean canSuspend() {
        if (!this.isSuspended() && this.isAvailable()) {
            IThread[] threads = this.getThreads();
            int i = 0;
            int numThreads = threads.length;
            while (i < numThreads) {
                if (((JDIThread)threads[i]).isSuspended()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect() && !this.isDisconnected();
    }

    protected boolean supportsDisconnect() {
        return this.fSupportsDisconnect;
    }

    private void setSupportsDisconnect(boolean supported) {
        this.fSupportsDisconnect = supported;
    }

    protected boolean supportsTerminate() {
        return this.fSupportsTerminate;
    }

    private void setSupportsTerminate(boolean supported) {
        this.fSupportsTerminate = supported;
    }

    public boolean supportsHotCodeReplace() {
        return this.supportsJ9HotCodeReplace() || this.supportsJDKHotCodeReplace();
    }

    public boolean supportsInstanceBreakpoints() {
        com.sun.jdi.VirtualMachine vm;
        if (this.isAvailable() && JDIDebugPlugin.isJdiVersionGreaterThanOrEqual(new int[]{1, 4}) && (vm = this.getVM()) != null) {
            return vm.canUseInstanceFilters();
        }
        return false;
    }

    public boolean supportsJ9HotCodeReplace() {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (this.isAvailable() && vm instanceof VirtualMachine) {
            try {
                return ((VirtualMachine)((Object)vm)).canReloadClasses();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return false;
    }

    public boolean supportsJDKHotCodeReplace() {
        com.sun.jdi.VirtualMachine vm;
        if (this.isAvailable() && JDIDebugPlugin.isJdiVersionGreaterThanOrEqual(new int[]{1, 4}) && (vm = this.getVM()) != null) {
            return vm.canRedefineClasses();
        }
        return false;
    }

    public boolean canPopFrames() {
        com.sun.jdi.VirtualMachine vm;
        if (this.isAvailable() && JDIDebugPlugin.isJdiVersionGreaterThanOrEqual(new int[]{1, 4}) && (vm = this.getVM()) != null) {
            return vm.canPopFrames();
        }
        return false;
    }

    public void disconnect() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.canDisconnect()) {
            this.notSupported(JDIDebugModelMessages.getString("JDIDebugTarget.does_not_support_disconnect"));
        }
        try {
            this.getThreadStartHandler().deleteRequest();
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.dispose();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIDebugTarget.exception_disconnecting"), e.toString()), e);
        }
    }

    public com.sun.jdi.VirtualMachine getVM() {
        return this.fVirtualMachine;
    }

    private void setVM(com.sun.jdi.VirtualMachine vm) {
        this.fVirtualMachine = vm;
    }

    public void setHCROccurred(boolean occurred) {
        this.fHasHCROccurred = occurred;
    }

    public void removeOutOfSynchTypes(List qualifiedNames) {
        this.fOutOfSynchTypes.removeAll(qualifiedNames);
    }

    private void setOutOfSynchTypes(List qualifiedNames) {
        this.fOutOfSynchTypes = new HashSet();
        this.fOutOfSynchTypes.addAll(qualifiedNames);
    }

    public void addOutOfSynchTypes(List qualifiedNames) {
        this.fOutOfSynchTypes.addAll(qualifiedNames);
    }

    public boolean isOutOfSynch(String qualifiedName) {
        if (this.fOutOfSynchTypes == null || this.fOutOfSynchTypes.isEmpty()) {
            return false;
        }
        return this.fOutOfSynchTypes.contains(qualifiedName);
    }

    public boolean isOutOfSynch() throws DebugException {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            JDIThread thread = (JDIThread)threads.next();
            if (!thread.isOutOfSynch()) continue;
            return true;
        }
        return false;
    }

    public boolean mayBeOutOfSynch() {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            JDIThread thread = (JDIThread)threads.next();
            if (!thread.mayBeOutOfSynch()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHCRFailed() {
        return this.fOutOfSynchTypes != null && !this.fOutOfSynchTypes.isEmpty();
    }

    public boolean hasHCROccurred() {
        return this.fHasHCROccurred;
    }

    public void reinstallBreakpointsIn(List resources, List classNames) {
        List breakpoints = this.getBreakpoints();
        IJavaBreakpoint[] copy = new IJavaBreakpoint[breakpoints.size()];
        breakpoints.toArray(copy);
        IJavaBreakpoint breakpoint = null;
        String installedType = null;
        int i = 0;
        while (i < copy.length) {
            breakpoint = copy[i];
            if (breakpoint instanceof JavaLineBreakpoint) {
                try {
                    installedType = breakpoint.getTypeName();
                    if (classNames.contains(installedType)) {
                        this.breakpointAdded(breakpoint);
                    }
                }
                catch (CoreException ce) {
                    this.logError((Exception)((Object)ce));
                }
            }
            ++i;
        }
    }

    public JDIThread findThread(ThreadReference tr) {
        Iterator iter = this.getThreadIterator();
        while (iter.hasNext()) {
            JDIThread thread = (JDIThread)iter.next();
            if (!thread.getUnderlyingThread().equals(tr)) continue;
            return thread;
        }
        return null;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm == null) {
                this.requestFailed(JDIDebugModelMessages.getString("JDIDebugTarget.Unable_to_retrieve_name_-_VM_disconnected._1"), null);
            }
            try {
                this.setName(vm.name());
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIDebugTarget.exception_retrieving_name"), e.toString()), e);
                return null;
            }
        }
        return this.fName;
    }

    protected void setName(String name) {
        this.fName = name;
    }

    protected void setProcess(IProcess process) {
        this.fProcess = process;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public void handleVMDeath(VMDeathEvent event) {
        this.terminated();
    }

    public void handleVMDisconnect(VMDisconnectEvent event) {
        if (this.isTerminating()) {
            this.terminated();
        } else {
            this.disconnected();
        }
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    private void setSuspended(boolean suspended) {
        this.fSuspended = suspended;
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    protected void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    protected void setDisconnected(boolean disconnected) {
        this.fDisconnected = disconnected;
    }

    public boolean isDisconnected() {
        return this.fDisconnected;
    }

    public ClassPrepareRequest createClassPrepareRequest(String classPattern) throws CoreException {
        return this.createClassPrepareRequest(classPattern, null);
    }

    public ClassPrepareRequest createClassPrepareRequest(String classPattern, String classExclusionPattern) throws CoreException {
        EventRequestManager manager = this.getEventRequestManager();
        if (!this.isAvailable() || manager == null) {
            this.requestFailed(JDIDebugModelMessages.getString("JDIDebugTarget.Unable_to_create_class_prepare_request_-_VM_disconnected._2"), null);
        }
        ClassPrepareRequest req = null;
        try {
            req = manager.createClassPrepareRequest();
            req.addClassFilter(classPattern);
            if (classExclusionPattern != null) {
                req.addClassExclusionFilter(classExclusionPattern);
            }
            req.setSuspendPolicy(1);
            req.enable();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.getString("JDIDebugTarget.Unable_to_create_class_prepare_request._3"), e);
            return null;
        }
        return req;
    }

    public void resume() throws DebugException {
        this.setResumeOnStartup(true);
        this.resume(true);
    }

    public void resumeQuiet() throws DebugException {
        this.resume(false);
    }

    protected void resume(boolean fireNotification) throws DebugException {
        if (!this.isSuspended() || !this.isAvailable()) {
            return;
        }
        try {
            this.setSuspended(false);
            this.resumeThreads();
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.resume();
            }
            if (fireNotification) {
                this.fireResumeEvent(32);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
            return;
        }
        catch (RuntimeException e) {
            this.setSuspended(true);
            this.fireSuspendEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIDebugTarget.exception_resume"), e.toString()), e);
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof IJavaBreakpoint;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                ((JavaBreakpoint)breakpoint).addToTarget(this);
                if (!this.getBreakpoints().contains(breakpoint)) {
                    this.getBreakpoints().add(breakpoint);
                }
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            ((JavaBreakpoint)breakpoint).changeForTarget(this);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                ((JavaBreakpoint)breakpoint).removeFromTarget(this);
                this.getBreakpoints().remove(breakpoint);
                Iterator threads = this.getThreadIterator();
                while (threads.hasNext()) {
                    ((JDIThread)threads.next()).removeCurrentBreakpoint(breakpoint);
                }
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
            }
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        try {
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.suspend();
            }
            this.suspendThreads();
            this.setSuspended(true);
            this.fireSuspendEvent(32);
        }
        catch (RuntimeException e) {
            this.setSuspended(false);
            this.fireResumeEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIDebugTarget.exception_suspend"), e.toString()), e);
        }
    }

    protected void suspendThreads() {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            ((JDIThread)threads.next()).suspendedByVM();
        }
    }

    protected void resumeThreads() {
        Iterator threads = this.getThreadIterator();
        while (threads.hasNext()) {
            ((JDIThread)threads.next()).resumedByVM();
        }
    }

    public void prepareToSuspendByBreakpoint(JavaBreakpoint breakpoint) {
        this.setSuspended(true);
        this.suspendThreads();
    }

    protected void suspendedByBreakpoint(JavaBreakpoint breakpoint, boolean queueEvent) {
        if (queueEvent) {
            this.queueSuspendEvent(16);
        } else {
            this.fireSuspendEvent(16);
        }
    }

    protected void cancelSuspendByBreakpoint(JavaBreakpoint breakpoint) {
        this.setSuspended(false);
        this.resumeThreads();
    }

    public void terminate() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.supportsTerminate()) {
            this.notSupported(JDIDebugModelMessages.getString("JDIDebugTarget.does_not_support_termination"));
        }
        try {
            IProcess process;
            this.setTerminating(true);
            this.getThreadStartHandler().deleteRequest();
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm != null) {
                vm.exit(1);
            }
            if ((process = this.getProcess()) != null) {
                process.terminate();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.terminated();
        }
        catch (TimeoutException timeoutException) {
            IProcess process = this.getProcess();
            if (process != null && process.isTerminated()) {
                this.terminated();
            } else {
                this.disconnected();
            }
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIDebugTarget.exception_terminating"), e.toString()), e);
        }
    }

    protected void terminated() {
        this.setTerminating(false);
        if (!this.isTerminated()) {
            this.setTerminated(true);
            this.setDisconnected(true);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setDisconnected(true);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void cleanup() {
        this.removeAllThreads();
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        plugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.removeAllBreakpoints();
        this.fOutOfSynchTypes.clear();
        if (this.fEngines != null) {
            Iterator engines = this.fEngines.values().iterator();
            while (engines.hasNext()) {
                IAstEvaluationEngine engine = (IAstEvaluationEngine)engines.next();
                engine.dispose();
            }
            this.fEngines.clear();
        }
        this.fVirtualMachine = null;
        this.setThreadStartHandler(null);
        this.setEventDispatcher(null);
        this.setStepFilters(new String[0]);
    }

    protected void removeAllThreads() {
        Iterator itr = this.getThreadIterator();
        while (itr.hasNext()) {
            JDIThread child = (JDIThread)itr.next();
            child.terminated();
        }
        this.getThreadList().clear();
    }

    protected void removeAllBreakpoints() {
        Iterator breakpoints = ((ArrayList)((ArrayList)this.getBreakpoints()).clone()).iterator();
        while (breakpoints.hasNext()) {
            JavaBreakpoint breakpoint = (JavaBreakpoint)breakpoints.next();
            try {
                breakpoint.removeFromTarget(this);
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
            }
        }
        this.getBreakpoints().clear();
    }

    public List jdiClassesByName(String className) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            try {
                return vm.classesByName(className);
            }
            catch (VMDisconnectedException e) {
                if (!this.isAvailable()) {
                    return Collections.EMPTY_LIST;
                }
                this.logError(e);
            }
            catch (RuntimeException e) {
                this.internalError(e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public IJavaVariable findVariable(String varName) throws DebugException {
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            IJavaThread thread = (IJavaThread)threads[i];
            IJavaVariable var = thread.findVariable(varName);
            if (var != null) {
                return var;
            }
            ++i;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.debug.core.IJavaDebugTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void shutdown() {
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.shutdown();
        }
        try {
            if (this.supportsTerminate()) {
                this.terminate();
            } else if (this.supportsDisconnect()) {
                this.disconnect();
            }
        }
        catch (DebugException e) {
            JDIDebugPlugin.log(e);
        }
        this.cleanup();
    }

    protected Integer getCRC(String typeName) throws DebugException {
        com.sun.jdi.ReferenceType type;
        List classes;
        if (this.getVM() instanceof VirtualMachine && !(classes = this.jdiClassesByName(typeName)).isEmpty() && (type = (com.sun.jdi.ReferenceType)classes.get(0)) instanceof ReferenceType) {
            try {
                ReferenceType rt = (ReferenceType)((Object)type);
                if (rt.isVersionKnown()) {
                    return new Integer(rt.getClassFileVersion());
                }
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIDebugTarget.exception_retrieving_version_information"), e.toString(), type.name()), e);
                return null;
            }
        }
        return null;
    }

    public IJavaType[] getJavaTypes(String name) throws DebugException {
        try {
            List<com.sun.jdi.ReferenceType> classes;
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm == null) {
                this.requestFailed(JDIDebugModelMessages.getString("JDIDebugTarget.Unable_to_retrieve_types_-_VM_disconnected._4"), null);
            }
            if ((classes = vm.classesByName(name)).size() == 0) {
                switch (name.charAt(0)) {
                    case 'b': {
                        if (name.equals("boolean")) {
                            return new IJavaType[]{this.newValue(true).getJavaType()};
                        }
                        if (!name.equals("byte")) break;
                        return new IJavaType[]{this.newValue((byte)1).getJavaType()};
                    }
                    case 'i': {
                        if (!name.equals("int")) break;
                        return new IJavaType[]{this.newValue(1).getJavaType()};
                    }
                    case 'l': {
                        if (!name.equals("long")) break;
                        return new IJavaType[]{this.newValue(1L).getJavaType()};
                    }
                    case 'c': {
                        if (!name.equals("char")) break;
                        return new IJavaType[]{this.newValue(' ').getJavaType()};
                    }
                    case 's': {
                        if (!name.equals("short")) break;
                        return new IJavaType[]{this.newValue((short)1).getJavaType()};
                    }
                    case 'f': {
                        if (!name.equals("float")) break;
                        return new IJavaType[]{this.newValue(1.0f).getJavaType()};
                    }
                    case 'd': {
                        if (!name.equals("double")) break;
                        return new IJavaType[]{this.newValue(1.0).getJavaType()};
                    }
                }
                return null;
            }
            IJavaType[] types = new IJavaType[classes.size()];
            int i = 0;
            while (i < types.length) {
                types[i] = JDIType.createType(this, classes.get(i));
                ++i;
            }
            return types;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occurred while retrieving class for name {1}", e.toString(), name), e);
            return null;
        }
    }

    public IJavaValue newValue(boolean value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            BooleanValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(byte value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            ByteValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(char value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            CharValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(double value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            DoubleValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(float value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            FloatValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(int value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            IntegerValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(long value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            LongValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(short value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            ShortValue v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue newValue(String value) {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            StringReference v = vm.mirrorOf(value);
            return JDIValue.createValue(this, v);
        }
        return null;
    }

    public IJavaValue nullValue() {
        return JDIValue.createValue(this, null);
    }

    public IJavaValue voidValue() {
        return new JDIVoidValue(this);
    }

    protected boolean isTerminating() {
        return this.fTerminating;
    }

    protected void setTerminating(boolean terminating) {
        this.fTerminating = terminating;
    }

    protected ThreadStartHandler getThreadStartHandler() {
        return this.fThreadStartHandler;
    }

    protected void setThreadStartHandler(ThreadStartHandler threadStartHandler) {
        this.fThreadStartHandler = threadStartHandler;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.notSupported(JDIDebugModelMessages.getString("JDIDebugTarget.does_not_support_storage_retrieval"));
        return null;
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    private synchronized void setResumeOnStartup(boolean resume) {
        this.fResumeOnStartup = resume;
    }

    protected synchronized boolean isResumeOnStartup() {
        return this.fResumeOnStartup;
    }

    public String[] getStepFilters() {
        return this.fStepFilters;
    }

    public boolean isFilterConstructors() {
        return (this.fStepFilterMask & 8) > 0;
    }

    public boolean isFilterStaticInitializers() {
        return (this.fStepFilterMask & 4) > 0;
    }

    public boolean isFilterSynthetics() {
        return (this.fStepFilterMask & 2) > 0;
    }

    public boolean isStepFiltersEnabled() {
        return (this.fStepFilterMask & 1) > 0;
    }

    public void setFilterConstructors(boolean filter) {
        this.fStepFilterMask = filter ? (this.fStepFilterMask |= 8) : (this.fStepFilterMask &= 0xFF7);
    }

    public void setFilterStaticInitializers(boolean filter) {
        this.fStepFilterMask = filter ? (this.fStepFilterMask |= 4) : (this.fStepFilterMask &= 0xFFB);
    }

    public void setFilterSynthetics(boolean filter) {
        this.fStepFilterMask = filter ? (this.fStepFilterMask |= 2) : (this.fStepFilterMask &= 0xFFD);
    }

    public void setStepFilters(String[] list) {
        this.fStepFilters = list;
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.fStepFilterMask = enabled ? (this.fStepFilterMask |= 1) : (this.fStepFilterMask &= 0xFFE);
    }

    public boolean hasThreads() {
        return this.getThreadList().size() > 0;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    protected int getSuspendCount() {
        return this.fSuspendCount;
    }

    protected void incrementSuspendCount() {
        ++this.fSuspendCount;
    }

    public IAstEvaluationEngine getEvaluationEngine(IJavaProject project) {
        IAstEvaluationEngine engine;
        if (this.fEngines == null) {
            this.fEngines = new HashMap(2);
        }
        if ((engine = (IAstEvaluationEngine)this.fEngines.get(project)) == null) {
            engine = EvaluationManager.newAstEvaluationEngine(project, this);
            this.fEngines.put(project, engine);
        }
        return engine;
    }

    public boolean supportsMonitorInformation() {
        if (!this.isAvailable()) {
            return false;
        }
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (vm != null) {
            return vm.canGetCurrentContendedMonitor() && vm.canGetMonitorInfo() && vm.canGetOwnedMonitorInfo();
        }
        return false;
    }

    public void setIsPerformingHotCodeReplace(boolean isPerformingHotCodeReplace) {
        this.fIsPerformingHotCodeReplace = isPerformingHotCodeReplace;
    }

    public boolean isPerformingHotCodeReplace() {
        return this.fIsPerformingHotCodeReplace;
    }

    public boolean supportsAccessWatchpoints() {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (this.isAvailable() && vm != null) {
            return vm.canWatchFieldAccess();
        }
        return false;
    }

    public boolean supportsModificationWatchpoints() {
        com.sun.jdi.VirtualMachine vm = this.getVM();
        if (this.isAvailable() && vm != null) {
            return vm.canWatchFieldModification();
        }
        return false;
    }

    public void setDefaultStratum(String stratum) {
        this.getVM().setDefaultStratum(stratum);
    }

    public String getDefaultStratum() {
        return this.getVM().getDefaultStratum();
    }

    class ThreadStartHandler
    implements IJDIEventListener {
        protected EventRequest fRequest;

        protected ThreadStartHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager manager = JDIDebugTarget.this.getEventRequestManager();
            if (manager != null) {
                try {
                    ThreadStartRequest req = manager.createThreadStartRequest();
                    req.setSuspendPolicy(0);
                    req.enable();
                    JDIDebugTarget.this.addJDIEventListener(this, req);
                    this.setRequest(req);
                }
                catch (RuntimeException e) {
                    JDIDebugTarget.this.logError(e);
                }
            }
        }

        public boolean handleEvent(Event event, JDIDebugTarget target) {
            ThreadReference thread = ((ThreadStartEvent)event).thread();
            try {
                if (thread.isCollected()) {
                    return false;
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                return false;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return false;
            }
            catch (TimeoutException timeoutException) {}
            JDIThread jdiThread = JDIDebugTarget.this.findThread(thread);
            if (jdiThread == null) {
                jdiThread = JDIDebugTarget.this.createThread(thread);
                if (jdiThread == null) {
                    return false;
                }
            } else {
                jdiThread.disposeStackFrames();
                jdiThread.fireChangeEvent(512);
            }
            return !jdiThread.isSuspended();
        }

        protected void deleteRequest() {
            if (this.getRequest() != null) {
                JDIDebugTarget.this.removeJDIEventListener(this, this.getRequest());
                this.setRequest(null);
            }
        }

        protected EventRequest getRequest() {
            return this.fRequest;
        }

        protected void setRequest(EventRequest request) {
            this.fRequest = request;
        }
    }

    class ThreadDeathHandler
    implements IJDIEventListener {
        protected ThreadDeathHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager manager = JDIDebugTarget.this.getEventRequestManager();
            if (manager != null) {
                try {
                    ThreadDeathRequest req = manager.createThreadDeathRequest();
                    req.setSuspendPolicy(0);
                    req.enable();
                    JDIDebugTarget.this.addJDIEventListener(this, req);
                }
                catch (RuntimeException e) {
                    JDIDebugTarget.this.logError(e);
                }
            }
        }

        public boolean handleEvent(Event event, JDIDebugTarget target) {
            ThreadReference ref = ((ThreadDeathEvent)event).thread();
            JDIThread thread = JDIDebugTarget.this.findThread(ref);
            if (thread != null) {
                ArrayList arrayList = JDIDebugTarget.this.fThreads;
                synchronized (arrayList) {
                    JDIDebugTarget.this.getThreadList().remove(thread);
                }
                thread.terminated();
            }
            return true;
        }
    }
}

