/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.EventDispatcher;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public abstract class JDIDebugElement
extends PlatformObject
implements IDebugElement,
IDisconnect {
    private static List fgJDIExceptions = new ArrayList(15);
    private JDIDebugTarget fDebugTarget;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lcom.sun.jdi.ClassNotPreparedException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lcom.sun.jdi.InconsistentDebugInfoException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lcom.sun.jdi.InternalException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("[Lcom.sun.jdi.InvalidCodeIndexException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("[Lcom.sun.jdi.InvalidLineNumberException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("[Lcom.sun.jdi.InvalidStackFrameException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("[Lcom.sun.jdi.NativeMethodException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("[Lcom.sun.jdi.ObjectCollectedException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz8);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("[Lorg.eclipse.jdi.TimeoutException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz9);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("[Lcom.sun.jdi.VMDisconnectedException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz10);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("[Lcom.sun.jdi.VMMismatchException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz11);
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("[Lcom.sun.jdi.VMOutOfMemoryException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz12);
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("[Lcom.sun.jdi.request.DuplicateRequestException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz13);
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("[Lcom.sun.jdi.request.InvalidRequestStateException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz14);
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("[Lorg.eclipse.jdi.hcr.OperationRefusedException;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgJDIExceptions.add(clazz15);
    }

    public JDIDebugElement(JDIDebugTarget target) {
        this.setDebugTarget(target);
    }

    protected void logError(Exception e) {
        if (!((JDIDebugTarget)this.getDebugTarget()).isAvailable() && (e instanceof VMDisconnectedException || e instanceof CoreException && ((CoreException)((Object)e)).getStatus().getException() instanceof VMDisconnectedException)) {
            return;
        }
        JDIDebugPlugin.log(e);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$15;
        if (clazz == null) {
            try {
                clazz = class$15 = Class.forName("[Lorg.eclipse.debug.core.model.IDebugElement;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getModelIdentifier() {
        return JDIDebugModel.getPluginIdentifier();
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    public void queueEvent(DebugEvent event) {
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.queue(event);
        }
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public void fireSuspendEvent(int detail) {
        this.getJavaDebugTarget().incrementSuspendCount();
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    public void queueSuspendEvent(int detail) {
        this.getJavaDebugTarget().incrementSuspendCount();
        this.queueEvent(new DebugEvent((Object)this, 2, detail));
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 16, detail));
    }

    public void requestFailed(String message, Exception e) throws DebugException {
        this.requestFailed(message, e, 5012);
    }

    public void targetRequestFailed(String message, RuntimeException e) throws DebugException {
        if (e != null && !fgJDIExceptions.contains(e.getClass())) {
            throw e;
        }
        this.requestFailed(message, e, 5010);
    }

    public void requestFailed(String message, Throwable e, int code) throws DebugException {
        this.throwDebugException(message, code, e);
    }

    public void targetRequestFailed(String message, Throwable e) throws DebugException {
        this.throwDebugException(message, 5010, e);
    }

    public void jdiRequestFailed(String message, Throwable e) throws DebugException {
        this.throwDebugException(message, 5010, e);
    }

    public void notSupported(String message) throws DebugException {
        this.throwDebugException(message, 5011, null);
    }

    protected void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), code, message, exception));
    }

    public void internalError(RuntimeException e) {
        if (!fgJDIExceptions.contains(e.getClass())) {
            throw e;
        }
        this.logError(e);
    }

    protected void internalError(String message) {
        this.logError((Exception)((Object)new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5013, message, null))));
    }

    protected String getUnknownMessage() {
        return JDIDebugModelMessages.getString("JDIDebugElement.unknown");
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected JDIDebugTarget getJavaDebugTarget() {
        return this.fDebugTarget;
    }

    protected VirtualMachine getVM() {
        return ((JDIDebugTarget)this.getDebugTarget()).getVM();
    }

    public EventRequestManager getEventRequestManager() {
        VirtualMachine vm = this.getVM();
        if (vm == null) {
            return null;
        }
        return vm.eventRequestManager();
    }

    public void addJDIEventListener(IJDIEventListener listener, EventRequest request) {
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.addJDIEventListener(listener, request);
        }
    }

    public void removeJDIEventListener(IJDIEventListener listener, EventRequest request) {
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.removeJDIEventListener(listener, request);
        }
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    protected void setDebugTarget(JDIDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    protected void disconnected() {
        if (this.fDebugTarget != null) {
            this.fDebugTarget.disconnected();
        }
    }

    public void setRequestTimeout(int timeout) {
        VirtualMachine vm;
        if (this.supportsRequestTimeout() && (vm = this.getVM()) != null) {
            ((org.eclipse.jdi.VirtualMachine)((Object)vm)).setRequestTimeout(timeout);
        }
    }

    public int getRequestTimeout() {
        VirtualMachine vm;
        if (this.supportsRequestTimeout() && (vm = this.getVM()) != null) {
            return ((org.eclipse.jdi.VirtualMachine)((Object)vm)).getRequestTimeout();
        }
        return -1;
    }

    public boolean supportsRequestTimeout() {
        return this.getJavaDebugTarget().isAvailable() && this.getVM() instanceof org.eclipse.jdi.VirtualMachine;
    }

    public boolean canDisconnect() {
        return this.getDebugTarget().canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.getDebugTarget().disconnect();
    }

    public boolean isDisconnected() {
        return this.getDebugTarget().isDisconnected();
    }
}

