/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.lang.constant.Constable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIType;

public abstract class JavaBreakpoint
extends Breakpoint
implements IJavaBreakpoint,
IJDIEventListener,
IDebugEventSetListener {
    protected static final String EXPIRED = "org.eclipse.jdt.debug.core.expired";
    protected static final String HIT_COUNT = "org.eclipse.jdt.debug.core.hitCount";
    protected static final String INSTALL_COUNT = "org.eclipse.jdt.debug.core.installCount";
    protected static final String TYPE_NAME = "org.eclipse.jdt.debug.core.typeName";
    protected static final String SUSPEND_POLICY = "org.eclipse.jdt.debug.core.suspendPolicy";
    protected HashMap fRequestsByTarget = new HashMap(1);
    protected Map fFilteredThreadsByTarget = new HashMap(1);
    protected String fInstalledTypeName = null;
    protected Set fInstalledTargets = null;
    protected List fInstanceFilters = null;
    protected static final IJavaObject[] fgEmptyInstanceFilters = new IJavaObject[0];
    public static final String JAVA_BREAKPOINT_PROPERTY = "org.eclipse.jdt.debug.breakpoint";
    protected static final String[] fgExpiredEnabledAttributes = new String[]{"org.eclipse.jdt.debug.core.expired", "org.eclipse.debug.core.enabled"};
    static /* synthetic */ Class class$0;

    public String getModelIdentifier() {
        return JDIDebugModel.getPluginIdentifier();
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.configureAtStartup();
    }

    protected void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected void registerRequest(EventRequest request, JDIDebugTarget target) throws CoreException {
        if (request == null) {
            return;
        }
        ArrayList reqs = this.getRequests(target);
        if (reqs.isEmpty()) {
            this.fRequestsByTarget.put(target, reqs);
        }
        reqs.add(request);
        target.addJDIEventListener(this, request);
        if (!(request instanceof ClassPrepareRequest)) {
            this.incrementInstallCount();
            this.fireInstalled(target);
        }
    }

    protected String getEnclosingReferenceTypeName() throws CoreException {
        String name = this.getTypeName();
        int index = name.indexOf(36);
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    protected ArrayList getRequests(JDIDebugTarget target) {
        ArrayList list = (ArrayList)this.fRequestsByTarget.get(target);
        if (list == null) {
            list = new ArrayList(2);
        }
        return list;
    }

    protected void deregisterRequest(EventRequest request, JDIDebugTarget target) throws CoreException {
        target.removeJDIEventListener(this, request);
        if (!(request instanceof ClassPrepareRequest) && this.getMarker().exists()) {
            this.decrementInstallCount();
        }
    }

    public boolean handleEvent(Event event, JDIDebugTarget target) {
        if (event instanceof ClassPrepareEvent) {
            return this.handleClassPrepareEvent((ClassPrepareEvent)event, target);
        }
        ThreadReference threadRef = ((LocatableEvent)event).thread();
        JDIThread thread = target.findThread(threadRef);
        if (thread == null || thread.isIgnoringBreakpoints()) {
            return true;
        }
        return this.handleBreakpointEvent(event, target, thread);
    }

    public boolean handleClassPrepareEvent(ClassPrepareEvent event, JDIDebugTarget target) {
        try {
            if (!this.installableReferenceType(event.referenceType(), target)) {
                return true;
            }
            this.createRequest(target, event.referenceType());
        }
        catch (CoreException e) {
            JDIDebugPlugin.log(e);
        }
        return true;
    }

    public boolean handleBreakpointEvent(Event event, JDIDebugTarget target, JDIThread thread) {
        this.expireHitCount(event);
        return !this.suspend(thread);
    }

    protected boolean suspend(JDIThread thread) {
        return thread.handleSuspendForBreakpoint(this, true);
    }

    protected boolean installableReferenceType(ReferenceType type, JDIDebugTarget target) throws CoreException {
        String installableType = this.getTypeName();
        String queriedType = type.name();
        if (installableType == null || queriedType == null) {
            return false;
        }
        if (installableType.equals(queriedType)) {
            return this.queryInstallListeners(target, type);
        }
        int index = queriedType.indexOf(36, 0);
        if (index == -1) {
            return false;
        }
        if (installableType.regionMatches(0, queriedType, 0, index)) {
            return this.queryInstallListeners(target, type);
        }
        return false;
    }

    protected void expireHitCount(Event event) {
        Integer requestCount = null;
        EventRequest request = null;
        if (event != null) {
            request = event.request();
            requestCount = (Integer)request.getProperty(HIT_COUNT);
        }
        if (requestCount != null) {
            if (request != null) {
                request.putProperty(EXPIRED, Boolean.TRUE);
            }
            try {
                this.setAttributes(fgExpiredEnabledAttributes, new Object[]{Boolean.TRUE, Boolean.FALSE});
            }
            catch (CoreException ce) {
                JDIDebugPlugin.log(ce);
            }
        }
    }

    protected boolean createRequest(JDIDebugTarget target, ReferenceType type) throws CoreException {
        EventRequest request = this.newRequest(target, type);
        if (request == null) {
            return false;
        }
        this.fInstalledTypeName = type.name();
        this.registerRequest(request, target);
        return true;
    }

    protected void configureRequest(EventRequest request, JDIDebugTarget target) throws CoreException {
        request.setSuspendPolicy(this.getJDISuspendPolicy());
        request.putProperty(JAVA_BREAKPOINT_PROPERTY, this);
        this.configureRequestThreadFilter(request, target);
        this.configureRequestHitCount(request);
        this.configureInstanceFilters(request, target);
        this.updateEnabledState(request);
    }

    protected abstract void addInstanceFilter(EventRequest var1, ObjectReference var2);

    protected void configureRequestThreadFilter(EventRequest request, JDIDebugTarget target) {
        IJavaThread thread = (IJavaThread)this.fFilteredThreadsByTarget.get(target);
        if (thread == null || !(thread instanceof JDIThread)) {
            return;
        }
        this.setRequestThreadFilter(request, ((JDIThread)thread).getUnderlyingThread());
    }

    protected void configureRequestHitCount(EventRequest request) throws CoreException {
        int hitCount = this.getHitCount();
        if (hitCount > 0) {
            request.addCountFilter(hitCount);
            request.putProperty(HIT_COUNT, new Integer(hitCount));
        }
    }

    protected void configureInstanceFilters(EventRequest request, JDIDebugTarget target) {
        if (this.fInstanceFilters != null && !this.fInstanceFilters.isEmpty()) {
            Iterator iter = this.fInstanceFilters.iterator();
            while (iter.hasNext()) {
                IJavaObject object = (IJavaObject)iter.next();
                if (!object.getDebugTarget().equals(target)) continue;
                this.addInstanceFilter(request, ((JDIObjectValue)object).getUnderlyingObject());
            }
        }
    }

    protected abstract EventRequest newRequest(JDIDebugTarget var1, ReferenceType var2) throws CoreException;

    public void addToTarget(JDIDebugTarget target) throws CoreException {
        this.fireAdding(target);
        this.createRequests(target);
    }

    protected void createRequests(JDIDebugTarget target) throws CoreException {
        if (target.isTerminated()) {
            return;
        }
        String referenceTypeName = this.getTypeName();
        String enclosingTypeName = this.getEnclosingReferenceTypeName();
        if (referenceTypeName == null || enclosingTypeName == null) {
            return;
        }
        if (referenceTypeName.indexOf(36) == -1) {
            this.registerRequest(target.createClassPrepareRequest(enclosingTypeName), target);
            this.registerRequest(target.createClassPrepareRequest(String.valueOf(enclosingTypeName) + "$*"), target);
        } else {
            this.registerRequest(target.createClassPrepareRequest(referenceTypeName), target);
            this.registerRequest(target.createClassPrepareRequest(String.valueOf(enclosingTypeName) + "$*", referenceTypeName), target);
        }
        List classes = target.jdiClassesByName(referenceTypeName);
        if (classes.isEmpty() && enclosingTypeName.equals(referenceTypeName)) {
            return;
        }
        boolean success = false;
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            ReferenceType type = (ReferenceType)iter.next();
            if (!this.createRequest(target, type)) continue;
            success = true;
        }
        if (!success) {
            this.addToTargetForLocalType(target, enclosingTypeName);
        }
    }

    protected void addToTargetForLocalType(JDIDebugTarget target, String enclosingTypeName) throws CoreException {
        List classes = target.jdiClassesByName(enclosingTypeName);
        if (!classes.isEmpty()) {
            Iterator iter = classes.iterator();
            block0: while (iter.hasNext()) {
                ReferenceType type = (ReferenceType)iter.next();
                Iterator<ReferenceType> nestedTypes = type.nestedTypes().iterator();
                while (nestedTypes.hasNext()) {
                    ReferenceType nestedType = nestedTypes.next();
                    if (this.createRequest(target, nestedType)) continue block0;
                }
            }
        }
    }

    public void changeForTarget(JDIDebugTarget target) {
    }

    protected int getJDISuspendPolicy() throws CoreException {
        int breakpointPolicy = this.getSuspendPolicy();
        if (breakpointPolicy == 2) {
            return 1;
        }
        return 2;
    }

    protected boolean hasHitCountChanged(EventRequest request) throws CoreException {
        int hitCount = this.getHitCount();
        Integer requestCount = (Integer)request.getProperty(HIT_COUNT);
        int oldCount = -1;
        if (requestCount != null) {
            oldCount = requestCount;
        }
        return hitCount != oldCount;
    }

    public void removeFromTarget(JDIDebugTarget target) throws CoreException {
        this.removeRequests(target);
        Object removed = this.fFilteredThreadsByTarget.remove(target);
        boolean changed = removed != null;
        boolean markerExists = this.markerExists();
        if (!markerExists || markerExists && this.getInstallCount() == 0) {
            this.fInstalledTypeName = null;
        }
        if (this.fInstanceFilters != null && !this.fInstanceFilters.isEmpty()) {
            int i = 0;
            while (i < this.fInstanceFilters.size()) {
                IJavaObject object = (IJavaObject)this.fInstanceFilters.get(i);
                if (object.getDebugTarget().equals(target)) {
                    this.fInstanceFilters.remove(i);
                    changed = true;
                }
                ++i;
            }
        }
        if (changed) {
            this.fireChanged();
        }
        this.fireRemoved(target);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeRequests(JDIDebugTarget target) throws CoreException {
        ArrayList requests = (ArrayList)this.getRequests(target).clone();
        Iterator iter = requests.iterator();
        while (true) {
            Object var6_8;
            if (!iter.hasNext()) {
                this.fRequestsByTarget.remove(target);
                return;
            }
            EventRequest req = (EventRequest)iter.next();
            try {
                try {
                    EventRequestManager manager;
                    if (target.isAvailable() && !this.isExpired(req) && (manager = target.getEventRequestManager()) != null) {
                        manager.deleteEventRequest(req);
                    }
                }
                catch (VMDisconnectedException e) {
                    if (target.isAvailable()) {
                        JDIDebugPlugin.log(e);
                    }
                }
                catch (RuntimeException e) {
                    JDIDebugPlugin.log(e);
                }
            }
            catch (Throwable throwable) {
                var6_8 = null;
                this.deregisterRequest(req, target);
                throw throwable;
            }
            {
                var6_8 = null;
            }
            this.deregisterRequest(req, target);
        }
    }

    protected void updateEnabledState(EventRequest request) throws CoreException {
        this.internalUpdateEnabledState(request, this.isEnabled());
    }

    protected void internalUpdateEnabledState(EventRequest request, boolean enabled) {
        if (request.isEnabled() != enabled) {
            try {
                if (!this.isExpired(request)) {
                    request.setEnabled(enabled);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (RuntimeException e) {
                JDIDebugPlugin.log(e);
            }
        }
    }

    public boolean isExpired() throws CoreException {
        return this.ensureMarker().getAttribute(EXPIRED, false);
    }

    protected boolean isExpired(EventRequest request) {
        Boolean requestExpired = (Boolean)request.getProperty(EXPIRED);
        if (requestExpired == null) {
            return false;
        }
        return requestExpired;
    }

    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0) > 0;
    }

    protected void incrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        this.setAttribute(INSTALL_COUNT, count + 1);
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0);
    }

    protected void decrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        if (count > 0) {
            this.setAttribute(INSTALL_COUNT, count - 1);
        }
        if (count == 1 && this.isExpired()) {
            this.setAttributes(fgExpiredEnabledAttributes, new Object[]{Boolean.FALSE, Boolean.TRUE});
        }
    }

    protected void setTypeName(String typeName) throws CoreException {
        this.setAttribute(TYPE_NAME, typeName);
    }

    public String getTypeName() throws CoreException {
        if (this.fInstalledTypeName == null) {
            return this.ensureMarker().getAttribute(TYPE_NAME, null);
        }
        return this.fInstalledTypeName;
    }

    protected void run(ISchedulingRule rule, IWorkspaceRunnable wr) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(wr, rule, 0, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    private void configureAtStartup() throws CoreException {
        ArrayList<String> attributes = null;
        ArrayList<Constable> values = null;
        if (this.isInstalled()) {
            attributes = new ArrayList<String>(3);
            values = new ArrayList<Constable>(3);
            attributes.add(INSTALL_COUNT);
            values.add(new Integer(0));
        }
        if (this.isExpired()) {
            if (attributes == null) {
                attributes = new ArrayList(3);
                values = new ArrayList(3);
            }
            attributes.add(EXPIRED);
            values.add(Boolean.FALSE);
            attributes.add("org.eclipse.debug.core.enabled");
            values.add(Boolean.TRUE);
        }
        if (attributes != null) {
            String[] strAttributes = new String[attributes.size()];
            this.setAttributes(attributes.toArray(strAttributes), values.toArray());
        }
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_COUNT, -1);
    }

    public void setHitCount(int count) throws CoreException {
        if (this.getHitCount() != count) {
            if (!this.isEnabled() && count > -1) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", HIT_COUNT, EXPIRED}, new Object[]{Boolean.TRUE, new Integer(count), Boolean.FALSE});
            } else {
                this.setAttributes(new String[]{HIT_COUNT, EXPIRED}, new Object[]{new Integer(count), Boolean.FALSE});
            }
            this.recreate();
        }
    }

    protected String getMarkerMessage(int hitCount, int suspendPolicy) {
        StringBuffer buff = new StringBuffer();
        if (hitCount > 0) {
            buff.append(MessageFormat.format(JDIDebugBreakpointMessages.getString("JavaBreakpoint._[Hit_Count__{0}]_1"), Integer.toString(hitCount)));
            buff.append(' ');
        }
        String suspendPolicyString = suspendPolicy == 2 ? JDIDebugBreakpointMessages.getString("JavaBreakpoint.[suspend_policy__thread]_1") : JDIDebugBreakpointMessages.getString("JavaBreakpoint.[suspend_policy__VM]_2");
        buff.append(suspendPolicyString);
        return buff.toString();
    }

    public void setExpired(boolean expired) throws CoreException {
        this.setAttribute(EXPIRED, expired);
    }

    public int getSuspendPolicy() throws CoreException {
        return this.ensureMarker().getAttribute(SUSPEND_POLICY, 2);
    }

    public void setSuspendPolicy(int suspendPolicy) throws CoreException {
        if (this.getSuspendPolicy() != suspendPolicy) {
            this.setAttributes(new String[]{SUSPEND_POLICY}, new Object[]{new Integer(suspendPolicy)});
        }
        this.recreate();
    }

    protected void fireAdding(IJavaDebugTarget target) {
        JDIDebugPlugin.getDefault().fireBreakpointAdding(target, this);
    }

    protected void fireRemoved(IJavaDebugTarget target) {
        JDIDebugPlugin.getDefault().fireBreakpointRemoved(target, this);
        this.setInstalledIn(target, false);
    }

    protected void fireInstalled(IJavaDebugTarget target) {
        if (!this.isInstalledIn(target)) {
            JDIDebugPlugin.getDefault().fireBreakpointInstalled(target, this);
            this.setInstalledIn(target, true);
        }
    }

    protected boolean isInstalledIn(IJavaDebugTarget target) {
        return this.fInstalledTargets != null && this.fInstalledTargets.contains(target);
    }

    protected void setInstalledIn(IJavaDebugTarget target, boolean installed) {
        if (installed) {
            if (this.fInstalledTargets == null) {
                this.fInstalledTargets = new HashSet();
            }
            this.fInstalledTargets.add(target);
        } else if (this.fInstalledTargets != null) {
            this.fInstalledTargets.remove(target);
        }
    }

    public void setThreadFilter(IJavaThread thread) throws CoreException {
        if (!(thread.getDebugTarget() instanceof JDIDebugTarget) || !(thread instanceof JDIThread)) {
            return;
        }
        JDIDebugTarget target = (JDIDebugTarget)thread.getDebugTarget();
        if (thread != this.fFilteredThreadsByTarget.put(target, thread)) {
            this.recreate(target);
            this.fireChanged();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8) {
                Object source = event.getSource();
                if (!(source instanceof JDIThread)) {
                    return;
                }
                try {
                    this.cleanupForThreadTermination((JDIThread)source);
                }
                catch (VMDisconnectedException vMDisconnectedException) {}
            }
            ++i;
        }
    }

    protected void cleanupForThreadTermination(JDIThread thread) {
        JDIDebugTarget target = (JDIDebugTarget)thread.getDebugTarget();
        try {
            if (thread == this.getThreadFilter(target)) {
                this.removeThreadFilter(target);
            }
        }
        catch (CoreException exception) {
            JDIDebugPlugin.log(exception);
        }
    }

    protected abstract void setRequestThreadFilter(EventRequest var1, ThreadReference var2);

    public IJavaThread getThreadFilter(IJavaDebugTarget target) {
        return (IJavaThread)this.fFilteredThreadsByTarget.get(target);
    }

    public IJavaThread[] getThreadFilters() {
        IJavaThread[] threads = null;
        Collection values = this.fFilteredThreadsByTarget.values();
        threads = new IJavaThread[values.size()];
        values.toArray(threads);
        return threads;
    }

    public void removeThreadFilter(IJavaDebugTarget javaTarget) throws CoreException {
        if (!(javaTarget instanceof JDIDebugTarget)) {
            return;
        }
        JDIDebugTarget target = (JDIDebugTarget)javaTarget;
        if (this.fFilteredThreadsByTarget.remove(target) != null) {
            this.recreate(target);
            this.fireChanged();
        }
    }

    protected boolean queryInstallListeners(JDIDebugTarget target, ReferenceType type) {
        JDIType jt = null;
        if (type != null) {
            jt = JDIType.createType(target, type);
        }
        return JDIDebugPlugin.getDefault().fireInstalling(target, this, jt);
    }

    public void addInstanceFilter(IJavaObject object) throws CoreException {
        if (this.fInstanceFilters == null) {
            this.fInstanceFilters = new ArrayList();
        }
        if (!this.fInstanceFilters.contains(object)) {
            this.fInstanceFilters.add(object);
            this.recreate((JDIDebugTarget)object.getDebugTarget());
            this.fireChanged();
        }
    }

    protected void fireChanged() {
        if (this.markerExists()) {
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this);
        }
    }

    public IJavaObject[] getInstanceFilters() {
        if (this.fInstanceFilters == null || this.fInstanceFilters.isEmpty()) {
            return fgEmptyInstanceFilters;
        }
        return this.fInstanceFilters.toArray(new IJavaObject[this.fInstanceFilters.size()]);
    }

    public void removeInstanceFilter(IJavaObject object) throws CoreException {
        if (this.fInstanceFilters == null) {
            return;
        }
        if (this.fInstanceFilters.remove(object)) {
            this.recreate((JDIDebugTarget)object.getDebugTarget());
            this.fireChanged();
        }
    }

    protected void recreate() throws CoreException {
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            IJavaDebugTarget jdiTarget;
            IDebugTarget target = targets[i];
            MultiStatus multiStatus = new MultiStatus(JDIDebugPlugin.getUniqueIdentifier(), 120, JDIDebugBreakpointMessages.getString("JavaBreakpoint.Exception"), null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.jdt.debug.core.IJavaDebugTarget;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jdiTarget = (IJavaDebugTarget)target.getAdapter((Class)clazz)) != null) {
                try {
                    this.recreate((JDIDebugTarget)jdiTarget);
                }
                catch (CoreException e) {
                    multiStatus.add(e.getStatus());
                }
            }
            if (!multiStatus.isOK()) {
                throw new CoreException((IStatus)multiStatus);
            }
            ++i;
        }
    }

    protected void recreate(JDIDebugTarget target) throws CoreException {
        if (target.isAvailable() && target.getBreakpoints().contains(this)) {
            this.removeRequests(target);
            this.createRequests(target);
        }
    }

    public void setEnabled(boolean enabled) throws CoreException {
        super.setEnabled(enabled);
        this.recreate();
    }
}

