/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor.quickdiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.internal.texteditor.quickdiff.DocumentLineDiffer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffProviderImplementation;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;
import org.eclipse.ui.texteditor.quickdiff.ReferenceProviderDescriptor;

public class QuickDiff {
    private static final String REFERENCE_PROVIDER_EXTENSION_POINT = "quickDiffReferenceProvider";
    private ReferenceProviderDescriptor fDefaultDescriptor;
    private List fDescriptors;

    public ReferenceProviderDescriptor getDefaultProvider() {
        this.ensureRegistered();
        return this.fDefaultDescriptor;
    }

    public List getReferenceProviderDescriptors() {
        this.ensureRegistered();
        return this.fDescriptors;
    }

    public IQuickDiffReferenceProvider getReferenceProviderOrDefault(ITextEditor editor, String id) {
        ReferenceProviderDescriptor defaultDescriptor;
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)id);
        List descs = this.getReferenceProviderDescriptors();
        IQuickDiffProviderImplementation provider = null;
        Iterator iter = descs.iterator();
        while (iter.hasNext()) {
            ReferenceProviderDescriptor desc = (ReferenceProviderDescriptor)iter.next();
            if (!desc.getId().equals(id) || (provider = desc.createProvider()) == null) continue;
            provider.setActiveEditor(editor);
            if (provider.isEnabled()) break;
            provider.dispose();
            provider = null;
        }
        if (provider == null && (defaultDescriptor = this.getDefaultProvider()) != null && (provider = defaultDescriptor.createProvider()) != null) {
            provider.setActiveEditor(editor);
            if (!provider.isEnabled()) {
                provider.dispose();
                provider = null;
            }
        }
        return provider;
    }

    public IAnnotationModel createQuickDiffAnnotationModel(ITextEditor editor, String id) {
        IQuickDiffReferenceProvider provider = this.getReferenceProviderOrDefault(editor, id);
        if (provider != null) {
            DocumentLineDiffer differ = new DocumentLineDiffer();
            differ.setReferenceProvider(provider);
            return differ;
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.registerExtensions();
        }
    }

    private void registerExtensions() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        ArrayList<ReferenceProviderDescriptor> list = new ArrayList<ReferenceProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.ui.workbench.texteditor", REFERENCE_PROVIDER_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            ReferenceProviderDescriptor desc = new ReferenceProviderDescriptor(elements[i]);
            if (this.fDefaultDescriptor == null && desc.getDefault()) {
                this.fDefaultDescriptor = desc;
            }
            list.add(desc);
            ++i;
        }
        this.fDescriptors = Collections.unmodifiableList(list);
    }
}

