/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;

public class CaseAction
extends ResourceAction
implements IUpdate {
    private AbstractTextEditor fEditor;
    private boolean fToUpper;

    public CaseAction(ResourceBundle bundle, String prefix, AbstractTextEditor editor, boolean toUpper) {
        super(bundle, prefix);
        this.fEditor = editor;
        this.fToUpper = toUpper;
        this.update();
    }

    public void run() {
        if (this.fEditor == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText st = viewer.getTextWidget();
        if (st == null) {
            return;
        }
        Point sel = viewer.getSelectedRange();
        if (sel == null) {
            return;
        }
        try {
            String replacement;
            if (sel.y == 0 && sel.y == 0) {
                return;
            }
            String target = document.get(sel.x, sel.y);
            String string = replacement = this.fToUpper ? target.toUpperCase() : target.toLowerCase();
            if (!target.equals(replacement)) {
                document.replace(sel.x, target.length(), replacement);
            }
        }
        catch (BadLocationException x) {
            return;
        }
        viewer.setSelectedRange(sel.x, sel.y);
        st.showSelection();
    }

    public void update() {
        boolean enabled = true;
        if (this.fEditor != null) {
            if (this.fEditor.isEditorInputReadOnly()) {
                enabled = false;
            }
        } else {
            enabled = false;
        }
        this.setEnabled(enabled);
    }
}

