/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.IRangeComparator;

public final class DocLineComparator
implements IRangeComparator {
    private final IDocument fDocument;
    private final int fLineOffset;
    private final int fLineCount;
    private final int fLength;
    private final boolean fIgnoreWhiteSpace;
    private final int fMaxOffset;
    private boolean fSkip = false;
    private int fLastOffset;
    private int fLastLength;

    public DocLineComparator(IDocument document, IRegion region, boolean ignoreWhiteSpace) {
        this.fDocument = document;
        this.fIgnoreWhiteSpace = ignoreWhiteSpace;
        if (region != null) {
            this.fLength = region.getLength();
            int start = region.getOffset();
            int lineOffset = 0;
            try {
                lineOffset = this.fDocument.getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.fLineOffset = lineOffset;
            this.fMaxOffset = start + this.fLength;
            if (this.fLength == 0) {
                this.fLineCount = 0;
            } else {
                int endLine = this.fDocument.getNumberOfLines();
                try {
                    endLine = this.fDocument.getLineOfOffset(start + this.fLength);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.fLineCount = endLine - this.fLineOffset + 1;
            }
        } else {
            this.fLineOffset = 0;
            this.fLength = document.getLength();
            this.fLineCount = this.fDocument.getNumberOfLines();
            this.fMaxOffset = this.fDocument.getLength();
        }
    }

    public int getRangeCount() {
        return this.fLineCount;
    }

    private int getLineLength(int line) {
        if (line >= this.fLineCount) {
            return 0;
        }
        try {
            int docLine = this.fLineOffset + line;
            String delim = this.fDocument.getLineDelimiter(docLine);
            int length = this.fDocument.getLineLength(docLine) - (delim == null ? 0 : delim.length());
            if (line == this.fLineCount - 1) {
                this.fLastOffset = this.fDocument.getLineOffset(docLine);
                this.fLastLength = Math.min(length, this.fMaxOffset - this.fLastOffset);
            } else {
                this.fLastOffset = -1;
                this.fLastLength = length;
            }
            return this.fLastLength;
        }
        catch (BadLocationException e) {
            this.fLastOffset = 0;
            this.fLastLength = 0;
            this.fSkip = true;
            return 0;
        }
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other0, int otherIndex) {
        if (other0 != null && other0.getClass() == this.getClass()) {
            int olen;
            DocLineComparator other = (DocLineComparator)other0;
            if (this.fIgnoreWhiteSpace) {
                CharSequence s1 = this.extract(thisIndex);
                CharSequence s2 = other.extract(otherIndex);
                return this.compare(s1, s2);
            }
            int tlen = this.getLineLength(thisIndex);
            if (tlen == (olen = other.getLineLength(otherIndex))) {
                CharSequence s1 = this.extract(thisIndex);
                CharSequence s2 = other.extract(otherIndex);
                return s1.equals(s2);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        return this.fSkip;
    }

    private CharSequence extract(int line) {
        if (line < this.fLineCount) {
            try {
                int docLine = this.fLineOffset + line;
                if (this.fLastOffset == -1) {
                    this.fLastOffset = this.fDocument.getLineOffset(docLine);
                }
                return this.fDocument.get(this.fLastOffset, this.fLastLength);
            }
            catch (BadLocationException e) {
                this.fSkip = true;
            }
        }
        return "";
    }

    private boolean compare(CharSequence s1, CharSequence s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int c1 = 0;
        int c2 = 0;
        int i1 = 0;
        int i2 = 0;
        while (c1 != -1) {
            char c;
            c1 = -1;
            while (i1 < l1) {
                if (Character.isWhitespace(c = s1.charAt(i1++))) continue;
                c1 = c;
                break;
            }
            c2 = -1;
            while (i2 < l2) {
                if (Character.isWhitespace(c = s2.charAt(i2++))) continue;
                c2 = c;
                break;
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }
}

