/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.operations.ReconcileProjectOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardAutoconnectPage;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;
import org.eclipse.team.internal.ccvs.ui.wizards.ModuleSelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.RepositorySelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.SharingWizardFinishPage;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;

public class SharingWizard
extends Wizard
implements IConfigurationWizard {
    private IProject project;
    private ConfigurationWizardAutoconnectPage autoconnectPage;
    private RepositorySelectionPage locationPage;
    private ConfigurationWizardMainPage createLocationPage;
    private ModuleSelectionPage modulePage;
    private SharingWizardFinishPage finishPage;

    public SharingWizard() {
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewLocationWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewLocationWizard");
        }
        this.setDialogSettings(section);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("SharingWizard.title"));
    }

    public void addPages() {
        ImageDescriptor sharingImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif");
        if (this.doesCVSDirectoryExist()) {
            this.autoconnectPage = new ConfigurationWizardAutoconnectPage("autoconnectPage", Policy.bind("SharingWizard.autoConnectTitle"), sharingImage);
            this.autoconnectPage.setProject(this.project);
            this.autoconnectPage.setDescription(Policy.bind("SharingWizard.autoConnectTitleDescription"));
            this.addPage((IWizardPage)this.autoconnectPage);
        } else {
            FolderSyncInfo info = this.getRepositoryInfoFromOneO(this.project);
            if (info != null) {
                this.autoconnectPage = new ConfigurationWizardAutoconnectPage("autoconnectPage", Policy.bind("SharingWizard.autoConnectOneOTitle"), sharingImage);
                this.autoconnectPage.setSharing(info);
                this.autoconnectPage.setDescription(Policy.bind("SharingWizard.autoConnectTitleDescription"));
                this.addPage((IWizardPage)this.autoconnectPage);
            } else {
                ICVSRepositoryLocation[] locations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
                if (locations.length > 0) {
                    this.locationPage = new RepositorySelectionPage("importPage", Policy.bind("SharingWizard.importTitle"), sharingImage);
                    this.locationPage.setDescription(Policy.bind("SharingWizard.importTitleDescription"));
                    this.addPage((IWizardPage)this.locationPage);
                }
                this.createLocationPage = new ConfigurationWizardMainPage("createLocationPage", Policy.bind("SharingWizard.enterInformation"), sharingImage);
                this.createLocationPage.setDescription(Policy.bind("SharingWizard.enterInformationDescription"));
                this.addPage((IWizardPage)this.createLocationPage);
                this.createLocationPage.setDialogSettings(this.getDialogSettings());
                this.modulePage = new ModuleSelectionPage("modulePage", Policy.bind("SharingWizard.enterModuleName"), sharingImage);
                this.modulePage.setDescription(Policy.bind("SharingWizard.enterModuleNameDescription"));
                this.addPage((IWizardPage)this.modulePage);
                this.finishPage = new SharingWizardFinishPage("finishPage", Policy.bind("SharingWizard.readyToFinish"), sharingImage);
                this.finishPage.setDescription(Policy.bind("SharingWizard.readyToFinishDescription"));
                this.addPage((IWizardPage)this.finishPage);
            }
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.locationPage) {
            if (this.locationPage.getLocation() == null) {
                return this.createLocationPage.isPageComplete();
            }
            return this.modulePage.useProjectName() || this.modulePage.getModuleName() != null;
        }
        if (page == this.modulePage) {
            return this.modulePage.useProjectName() || this.modulePage.getModuleName() != null;
        }
        if (page == this.finishPage) {
            return true;
        }
        return super.canFinish();
    }

    protected String getMainPageDescription() {
        return Policy.bind("SharingWizard.description");
    }

    protected String getMainPageTitle() {
        return Policy.bind("SharingWizard.heading");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.autoconnectPage) {
            return null;
        }
        if (page == this.locationPage) {
            if (this.locationPage.getLocation() == null) {
                return this.createLocationPage;
            }
            return this.modulePage;
        }
        if (page == this.createLocationPage) {
            return this.modulePage;
        }
        if (page == this.modulePage) {
            return this.finishPage;
        }
        return null;
    }

    public boolean performFinish() {
        boolean[] result;
        block9: {
            result = new boolean[]{true};
            try {
                final boolean[] doSync = new boolean[1];
                final boolean[] projectExists = new boolean[1];
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        block21: {
                            block23: {
                                block19: {
                                    try {
                                        try {
                                            boolean isKnown;
                                            ICVSRepositoryLocation location;
                                            block22: {
                                                monitor.beginTask("", 100);
                                                if (SharingWizard.this.autoconnectPage != null && SharingWizard.this.doesCVSDirectoryExist()) {
                                                    FolderSyncInfo info;
                                                    block20: {
                                                        info = SharingWizard.this.autoconnectPage.getFolderSyncInfo();
                                                        if (info == null) {
                                                            Object var9_5 = null;
                                                            break block19;
                                                        }
                                                        boolean isPreviouslyKnown = CVSProviderPlugin.getPlugin().isKnownRepository(info.getRoot());
                                                        ICVSRepositoryLocation location2 = CVSProviderPlugin.getPlugin().getRepository(info.getRoot());
                                                        boolean validate = SharingWizard.this.autoconnectPage.getValidate();
                                                        if (validate) {
                                                            try {
                                                                location2.validateConnection((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                                            }
                                                            catch (TeamException e) {
                                                                boolean[] keep = new boolean[1];
                                                                SharingWizard.this.getShell().getDisplay().syncExec(new Runnable(this, keep, e){
                                                                    final /* synthetic */ 1 this$1;
                                                                    private final /* synthetic */ boolean[] val$keep;
                                                                    private final /* synthetic */ TeamException val$e;
                                                                    {
                                                                        this.this$1 = var1_1;
                                                                        this.val$keep = blArray;
                                                                        this.val$e = teamException;
                                                                    }

                                                                    public void run() {
                                                                        this.val$keep[0] = MessageDialog.openQuestion((Shell)1.access$0(this.this$1).getContainer().getShell(), (String)Policy.bind("SharingWizard.validationFailedTitle"), (String)Policy.bind("SharingWizard.validationFailedText", new Object[]{this.val$e.getStatus().getMessage()}));
                                                                    }
                                                                });
                                                                if (keep[0]) break block20;
                                                                try {
                                                                    if (!isPreviouslyKnown) {
                                                                        CVSProviderPlugin.getPlugin().disposeRepository(location2);
                                                                    }
                                                                }
                                                                catch (TeamException e1) {
                                                                    CVSUIPlugin.openError(SharingWizard.this.getContainer().getShell(), Policy.bind("exception"), null, e1, 1);
                                                                }
                                                                result[0] = false;
                                                                Object var9_6 = null;
                                                                monitor.done();
                                                                return;
                                                            }
                                                        }
                                                    }
                                                    CVSWorkspaceRoot.setSharing((IProject)SharingWizard.this.project, (FolderSyncInfo)info, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                                    break block21;
                                                }
                                                doSync[0] = true;
                                                location = null;
                                                isKnown = false;
                                                try {
                                                    location = SharingWizard.this.getLocation();
                                                    isKnown = CVSProviderPlugin.getPlugin().isKnownRepository(location.getLocation());
                                                    location.validateConnection(monitor);
                                                    SharingWizard.this.purgeAnyCVSFolders();
                                                    String moduleName = SharingWizard.this.getModuleName();
                                                    ICVSRemoteFolder folder = location.getRemoteFolder(moduleName, null);
                                                    if (!folder.exists((IProgressMonitor)new SubProgressMonitor(monitor, 50))) break block22;
                                                    projectExists[0] = true;
                                                    boolean[] sync = new boolean[]{true};
                                                    if (SharingWizard.this.autoconnectPage == null) {
                                                        SharingWizard.this.getShell().getDisplay().syncExec(new Runnable(this, sync){
                                                            final /* synthetic */ 1 this$1;
                                                            private final /* synthetic */ boolean[] val$sync;
                                                            {
                                                                this.this$1 = var1_1;
                                                                this.val$sync = blArray;
                                                            }

                                                            public void run() {
                                                                this.val$sync[0] = MessageDialog.openQuestion((Shell)1.access$0(this.this$1).getShell(), (String)Policy.bind("SharingWizard.couldNotImport"), (String)Policy.bind("SharingWizard.couldNotImportLong", SharingWizard.access$5(1.access$0(this.this$1))));
                                                            }
                                                        });
                                                    }
                                                    result[0] = sync[0];
                                                    doSync[0] = sync[0];
                                                    break block23;
                                                }
                                                catch (TeamException e) {
                                                    CVSUIPlugin.openError(SharingWizard.this.getShell(), null, null, e, 1);
                                                    if (!isKnown && location != null) {
                                                        location.flushUserInfo();
                                                    }
                                                    result[0] = false;
                                                    doSync[0] = false;
                                                    Object var9_8 = null;
                                                    monitor.done();
                                                    return;
                                                }
                                            }
                                            if (!isKnown) {
                                                CVSProviderPlugin.getPlugin().addRepository(location);
                                            }
                                            ShareProjectOperation op = new ShareProjectOperation(SharingWizard.this.getShell(), location, SharingWizard.this.project, SharingWizard.this.getModuleName());
                                            op.run((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                            break block21;
                                        }
                                        catch (TeamException e) {
                                            throw new InvocationTargetException(e);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            Object var9_9 = null;
                                            monitor.done();
                                            return;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_10 = null;
                                        monitor.done();
                                        throw throwable;
                                    }
                                }
                                monitor.done();
                                return;
                            }
                            Object var9_7 = null;
                            monitor.done();
                            return;
                        }
                        Object var9_11 = null;
                        monitor.done();
                    }

                    static /* synthetic */ SharingWizard access$0(1 var0) {
                        return var0.SharingWizard.this;
                    }
                });
                if (!doSync[0]) break block9;
                if (projectExists[0]) {
                    try {
                        CVSEntryLineTag tag;
                        String moduleName = this.getModuleName();
                        if (this.autoconnectPage == null) {
                            TagSelectionDialog dialog = new TagSelectionDialog(this.getShell(), new ICVSFolder[]{(ICVSFolder)this.getLocation().getRemoteFolder(moduleName, null)}, Policy.bind("SharingWizard.selectTagTitle"), Policy.bind("SharingWizard.selectTag"), 5, false, "org.eclipse.team.cvs.ui.share_with_existing_tag_selection_dialog_context");
                            dialog.setBlockOnOpen(true);
                            if (dialog.open() == 1) {
                                return false;
                            }
                            tag = dialog.getResult();
                        } else {
                            tag = this.autoconnectPage.getSharing().getTag();
                        }
                        this.mapProject(moduleName, (CVSTag)tag);
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                IWorkingSet workingSet = CVSUIPlugin.getWorkingSet(new IResource[]{this.project}, Policy.bind("SyncAction.workingSetName"));
                CVSUIPlugin.showInSyncView(this.getContainer().getShell(), null, workingSet, 2);
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(this.getContainer().getShell(), null, null, e);
            }
        }
        return result[0];
    }

    private void mapProject(String moduleName, CVSTag tag) throws InvocationTargetException, InterruptedException {
        try {
            RemoteFolder remote = new RemoteFolder(null, this.getLocation(), moduleName, tag);
            new ReconcileProjectOperation(this.getShell(), this.project, (ICVSRemoteFolder)remote).run();
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
    }

    private ICVSRepositoryLocation getLocation() throws TeamException {
        ICVSRepositoryLocation location;
        if (this.autoconnectPage != null) {
            return this.autoconnectPage.getLocation();
        }
        if (this.locationPage != null && (location = this.locationPage.getLocation()) != null) {
            return location;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                SharingWizard.this.createLocationPage.finish((IProgressMonitor)new NullProgressMonitor());
            }
        });
        Properties properties = this.createLocationPage.getProperties();
        ICVSRepositoryLocation location2 = CVSProviderPlugin.getPlugin().createRepository(properties);
        return location2;
    }

    private String getModuleName() {
        if (this.autoconnectPage != null) {
            return this.autoconnectPage.getSharing().getRepository();
        }
        String moduleName = this.modulePage.getModuleName();
        if (moduleName == null) {
            moduleName = this.project.getName();
        }
        return moduleName;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
    }

    private boolean doesCVSDirectoryExist() {
        Shell shell = null;
        if (this.getContainer() != null) {
            shell = this.getContainer().getShell();
        }
        final boolean[] isCVSFolder = new boolean[1];
        try {
            CVSUIPlugin.runWithRefresh(shell, new IResource[]{this.project}, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)SharingWizard.this.project);
                        FolderSyncInfo info = folder.getFolderSyncInfo();
                        isCVSFolder[0] = info != null;
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, null);
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(shell, null, null, e);
        }
        catch (InterruptedException interruptedException) {}
        return isCVSFolder[0];
    }

    private FolderSyncInfo getRepositoryInfoFromOneO(IProject project) {
        try {
            QualifiedName key = new QualifiedName("org.eclipse.vcm.core", "Sharing");
            byte[] syncBytes = ResourcesPlugin.getWorkspace().getSynchronizer().getSyncInfo(key, (IResource)project);
            if (syncBytes != null) {
                DataInputStream reader = new DataInputStream(new ByteArrayInputStream(syncBytes));
                String repoType = reader.readUTF();
                String repoLocation = reader.readUTF();
                String stream = reader.readUTF();
                reader.close();
                ResourcesPlugin.getWorkspace().getSynchronizer().flushSyncInfo(key, (IResource)project, 2);
                if (repoType.equals("CVS")) {
                    CVSProviderPlugin.getPlugin().getRepository(repoLocation);
                    CVSTag tag = stream.equals("HEAD") ? CVSTag.DEFAULT : new CVSTag(stream, 1);
                    return new FolderSyncInfo(project.getName(), repoLocation, tag, false);
                }
            }
        }
        catch (CVSException ex) {
            CVSUIPlugin.log((CoreException)((Object)ex));
        }
        catch (CoreException coreException) {
        }
        catch (IOException ex) {
            CVSUIPlugin.log((CoreException)((Object)CVSException.wrapException((Exception)ex)));
        }
        return null;
    }

    private void purgeAnyCVSFolders() {
        try {
            ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project);
            folder.accept(new ICVSResourceVisitor(){

                public void visitFile(ICVSFile file) throws CVSException {
                }

                public void visitFolder(ICVSFolder folder) throws CVSException {
                    if (folder.isCVSFolder()) {
                        folder.unmanage(null);
                    }
                }
            }, true);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }
}

