/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutIntoOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutMultipleProjectsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutSingleProjectOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsLocationSelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsMainPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsProjectSelectionPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class CheckoutAsWizard
extends Wizard {
    private ICVSRemoteFolder[] remoteFolders;
    private boolean allowProjectConfiguration;
    private CheckoutAsMainPage mainPage;
    private CheckoutAsProjectSelectionPage projectSelectionPage;
    private CheckoutAsLocationSelectionPage locationSelectionPage;

    public CheckoutAsWizard(ICVSRemoteFolder[] remoteFolders, boolean allowProjectConfiguration) {
        this.remoteFolders = remoteFolders;
        this.setWindowTitle(Policy.bind("CheckoutAsWizard.title"));
        this.allowProjectConfiguration = allowProjectConfiguration;
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif");
        this.mainPage = new CheckoutAsMainPage(substImage, this.remoteFolders, this.allowProjectConfiguration);
        this.addPage((IWizardPage)this.mainPage);
        this.projectSelectionPage = new CheckoutAsProjectSelectionPage(substImage, this.remoteFolders);
        this.addPage((IWizardPage)this.projectSelectionPage);
        this.locationSelectionPage = new CheckoutAsLocationSelectionPage(substImage, this.remoteFolders);
        this.addPage((IWizardPage)this.locationSelectionPage);
    }

    public boolean performFinish() {
        try {
            if (this.mainPage.isPerformConfigure()) {
                return this.performConfigureAndCheckout();
            }
            if (this.mainPage.isPerformCheckoutAs()) {
                if (this.isSingleFolder()) {
                    return this.performSingleCheckoutAs();
                }
                return this.performMultipleCheckoutAs();
            }
            if (this.mainPage.isPerformCheckoutInto()) {
                return this.performCheckoutInto();
            }
        }
        catch (CVSException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private boolean isSingleFolder() {
        return this.remoteFolders.length == 1;
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete() && (this.mainPage.isPerformConfigure() || this.mainPage.isPerformCheckoutInto() && this.projectSelectionPage.isPageComplete() || this.mainPage.isPerformCheckoutAs() && this.locationSelectionPage.isPageComplete());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage) {
            if (this.mainPage.isPerformConfigure()) {
                return null;
            }
            if (this.mainPage.isPerformCheckoutInto()) {
                return this.projectSelectionPage;
            }
            if (this.mainPage.isPerformCheckoutAs()) {
                if (this.isSingleFolder()) {
                    this.locationSelectionPage.setProjectName(this.mainPage.getProjectName());
                } else {
                    this.locationSelectionPage.setProject(null);
                }
                return this.locationSelectionPage;
            }
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.mainPage) {
            return null;
        }
        return this.mainPage;
    }

    private void handle(Throwable e) {
        CVSUIPlugin.openError(this.getShell(), Policy.bind("CheckoutAsWizard.error"), null, e);
    }

    private boolean performConfigureAndCheckout() throws CVSException, InterruptedException {
        IProject newProject = this.getNewProject();
        if (newProject == null) {
            return false;
        }
        new CheckoutSingleProjectOperation(this.getShell(), this.remoteFolders[0], newProject, null, true).run();
        return true;
    }

    private boolean performSingleCheckoutAs() throws CVSException, InterruptedException {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mainPage.getProjectName());
        String targetLocation = this.locationSelectionPage.getTargetLocation();
        new CheckoutSingleProjectOperation(this.getShell(), this.remoteFolders[0], newProject, targetLocation, false).run();
        return true;
    }

    private boolean performMultipleCheckoutAs() throws CVSException, InterruptedException {
        String targetLocation = this.locationSelectionPage.getTargetLocation();
        new CheckoutMultipleProjectsOperation(this.getShell(), this.remoteFolders, targetLocation).run();
        return true;
    }

    private boolean performCheckoutInto() throws CVSException, InterruptedException {
        boolean recursive = this.projectSelectionPage.isRecurse();
        CheckoutIntoOperation operation = this.isSingleFolder() ? new CheckoutIntoOperation(this.getShell(), this.remoteFolders[0], this.projectSelectionPage.getLocalFolder(), recursive) : new CheckoutIntoOperation(this.getShell(), this.remoteFolders, this.projectSelectionPage.getParentFolder(), recursive);
        operation.run();
        return true;
    }

    private IProject getNewProject() {
        NewProjectListener listener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject project = listener.getNewProject();
        return project;
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

