/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;

public class CheckoutAsMainPage
extends CVSWizardPage {
    private String newProjectName;
    private boolean allowProjectConfiguration;
    private Button intoProjectButton;
    private Button simpleProjectButton;
    private Button configuredProjectButton;
    private Text projectNameField;
    private ICVSRemoteFolder[] folders;
    public static final String NAME = "CheckoutAsMainPage";

    public CheckoutAsMainPage(ImageDescriptor titleImage, ICVSRemoteFolder[] folders, boolean allowProjectConfiguration) {
        super(NAME, Policy.bind("CheckoutAsMainPage.title"), titleImage, Policy.bind("CheckoutAsMainPage.description"));
        this.folders = folders;
        this.allowProjectConfiguration = allowProjectConfiguration;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.setControl((Control)composite);
        if (this.isSingleFolder()) {
            this.createSingleFolderArea(composite);
        } else {
            this.createMultipleFoldersArea(composite);
        }
        this.updateEnablements();
        Dialog.applyDialogFont((Control)parent);
    }

    private boolean isSingleFolder() {
        return this.folders.length == 1;
    }

    private String getFolderName() {
        return this.folders[0].getName();
    }

    private void createSingleFolderArea(Composite composite) {
        CVSWizardPage.createLabel(composite, Policy.bind("CheckoutAsMainPage.singleFolder", this.getFolderName()));
        if (this.allowProjectConfiguration) {
            this.configuredProjectButton = this.createRadioButton(composite, Policy.bind("CheckoutAsMainPage.asConfiguredProject"), 1);
        }
        this.createCheckoutAsProjectRadioArea(composite);
        this.createCheckoutIntoRadioArea(composite);
        if (this.allowProjectConfiguration) {
            this.configuredProjectButton.setSelection(true);
        } else {
            this.simpleProjectButton.setSelection(true);
        }
    }

    private void createMultipleFoldersArea(Composite composite) {
        CVSWizardPage.createLabel(composite, Policy.bind("CheckoutAsMainPage.multipleFolders", new Integer(this.folders.length).toString()));
        this.createCheckoutAsProjectRadioArea(composite);
        this.createCheckoutIntoRadioArea(composite);
        this.simpleProjectButton.setSelection(true);
    }

    private void createCheckoutAsProjectRadioArea(Composite composite) {
        if (this.isSingleFolder()) {
            this.simpleProjectButton = this.createRadioButton(composite, Policy.bind("CheckoutAsMainPage.asSimpleProject"), 1);
            this.createProjectNameGroup(composite);
        } else {
            this.simpleProjectButton = this.createRadioButton(composite, Policy.bind("CheckoutAsMainPage.asProjects"), 1);
        }
    }

    private void createCheckoutIntoRadioArea(Composite composite) {
        this.intoProjectButton = this.createRadioButton(composite, Policy.bind("CheckoutAsMainPage.intoProject"), 1);
    }

    private void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(Policy.bind("CheckoutAsMainPage.projectNameLabel"));
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        this.projectNameField.setLayoutData((Object)data);
        this.newProjectName = this.getFolderName();
        this.projectNameField.setText(this.newProjectName);
        this.projectNameField.selectAll();
        this.projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutAsMainPage.this.updateEnablements();
            }
        });
    }

    private void updateEnablements() {
        if (this.projectNameField != null) {
            this.projectNameField.setEnabled(this.simpleProjectButton.getSelection());
            if (this.projectNameField.isEnabled()) {
                this.newProjectName = this.projectNameField.getText();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus nameStatus = workspace.validateName(this.newProjectName, 4);
                if (!nameStatus.isOK()) {
                    this.setErrorMessage(nameStatus.getMessage());
                    this.setPageComplete(false);
                }
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getProjectName() {
        if (this.isSingleFolder() && this.simpleProjectButton.getSelection()) {
            return this.newProjectName;
        }
        return null;
    }

    public boolean isPerformConfigure() {
        if (this.configuredProjectButton == null) {
            return false;
        }
        return this.configuredProjectButton.getSelection();
    }

    public boolean isPerformCheckoutInto() {
        return this.intoProjectButton.getSelection();
    }

    public boolean isPerformCheckoutAs() {
        return this.simpleProjectButton.getSelection();
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button radio = super.createRadioButton(parent, label, span);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutAsMainPage.this.updateEnablements();
            }
        });
        return radio;
    }
}

