/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;

public class CheckoutAsLocationSelectionPage
extends CVSWizardPage {
    public static final String NAME = "CheckoutAsLocationSelectionPage";
    private Button browseButton;
    private Text locationPathField;
    private Label locationLabel;
    private boolean useDefaults = true;
    private ICVSRemoteFolder[] remoteFolders;
    private String targetLocation;
    private IProject singleProject;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public CheckoutAsLocationSelectionPage(ImageDescriptor titleImage, ICVSRemoteFolder[] remoteFolders) {
        super(NAME, Policy.bind("CheckoutAsLocationSelectionPage.title"), titleImage, Policy.bind("CheckoutAsLocationSelectionPage.description"));
        this.remoteFolders = remoteFolders;
    }

    private boolean isSingleFolder() {
        return this.remoteFolders.length == 1;
    }

    public void setProject(IProject project) {
        this.singleProject = project;
    }

    public void setProjectName(String string) {
        if (string == null) {
            return;
        }
        if (this.singleProject != null && this.singleProject.getName().equals(string)) {
            return;
        }
        this.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(string));
    }

    private IProject getSingleProject() {
        if (this.singleProject == null) {
            this.setProjectName(this.remoteFolders[0].getName());
        }
        return this.singleProject;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)composite);
        final Button useDefaultsButton = new Button(composite, 131104);
        useDefaultsButton.setText(Policy.bind("CheckoutAsLocationSelectionPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        this.createUserSpecifiedProjectLocationGroup(composite, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutAsLocationSelectionPage.this.useDefaults = useDefaultsButton.getSelection();
                CheckoutAsLocationSelectionPage.this.browseButton.setEnabled(!CheckoutAsLocationSelectionPage.this.useDefaults);
                CheckoutAsLocationSelectionPage.this.locationPathField.setEnabled(!CheckoutAsLocationSelectionPage.this.useDefaults);
                CheckoutAsLocationSelectionPage.this.locationLabel.setEnabled(!CheckoutAsLocationSelectionPage.this.useDefaults);
                CheckoutAsLocationSelectionPage.this.setLocationForSelection(true);
                CheckoutAsLocationSelectionPage.this.setErrorMessage(CheckoutAsLocationSelectionPage.this.useDefaults ? null : CheckoutAsLocationSelectionPage.this.checkValidLocation());
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
        Dialog.applyDialogFont((Control)parent);
    }

    private Composite createUserSpecifiedProjectLocationGroup(Composite parent, boolean enabled) {
        Composite projectGroup = this.createComposite(parent, 3);
        this.locationLabel = new Label(projectGroup, 0);
        if (this.isSingleFolder()) {
            this.locationLabel.setText(Policy.bind("CheckoutAsLocationSelectionPage.locationLabel"));
        } else {
            this.locationLabel.setText(Policy.bind("CheckoutAsLocationSelectionPage.parentDirectoryLabel"));
        }
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(Policy.bind("CheckoutAsLocationSelectionPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CheckoutAsLocationSelectionPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.setButtonLayoutData(this.browseButton);
        this.setLocationForSelection(true);
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutAsLocationSelectionPage.this.setErrorMessage(CheckoutAsLocationSelectionPage.this.checkValidLocation());
            }
        });
        return projectGroup;
    }

    private String checkValidLocation() {
        if (this.useDefaults) {
            this.targetLocation = null;
            return null;
        }
        this.targetLocation = this.locationPathField.getText();
        if (this.targetLocation.equals("")) {
            return Policy.bind("CheckoutAsLocationSelectionPage.locationEmpty");
        }
        Path path = new Path("");
        if (!path.isValidPath(this.targetLocation)) {
            return Policy.bind("CheckoutAsLocationSelectionPage.invalidLocation");
        }
        if (this.isSingleFolder()) {
            IStatus locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(this.getSingleProject(), (IPath)new Path(this.targetLocation));
            if (!locationStatus.isOK()) {
                return locationStatus.getMessage();
            }
        } else {
            int i = 0;
            while (i < this.remoteFolders.length) {
                String projectName = this.remoteFolders[i].getName();
                IStatus locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), new Path(this.targetLocation).append(projectName));
                if (!locationStatus.isOK()) {
                    return locationStatus.getMessage();
                }
                ++i;
            }
        }
        return null;
    }

    private void setLocationForSelection(boolean changed) {
        if (this.useDefaults) {
            IPath defaultPath = null;
            if (this.isSingleFolder()) {
                try {
                    defaultPath = this.getSingleProject().getDescription().getLocation();
                }
                catch (CoreException coreException) {}
                if (defaultPath == null) {
                    defaultPath = Platform.getLocation().append(this.getSingleProject().getName());
                }
            } else {
                defaultPath = Platform.getLocation();
            }
            this.locationPathField.setText(defaultPath.toOSString());
            this.targetLocation = null;
        } else if (changed) {
            IPath location = null;
            try {
                location = ResourcesPlugin.getWorkspace().getRoot().getProject(this.remoteFolders[0].getName()).getDescription().getLocation();
            }
            catch (CoreException coreException) {}
            if (location == null) {
                this.targetLocation = null;
                this.locationPathField.setText("");
            } else {
                this.targetLocation = this.isSingleFolder() ? location.toOSString() : location.removeLastSegments(1).toOSString();
                this.locationPathField.setText(this.targetLocation);
            }
        }
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        if (this.isSingleFolder()) {
            dialog.setMessage(Policy.bind("CheckoutAsLocationSelectionPage.messageForSingle", this.getSingleProject().getName()));
        } else {
            dialog.setMessage(Policy.bind("CheckoutAsLocationSelectionPage.messageForMulti", new Integer(this.remoteFolders.length).toString()));
        }
        String dirName = this.locationPathField.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            if (this.isSingleFolder()) {
                this.locationPathField.setText(new Path(selectedDirectory).append(this.getSingleProject().getName()).toOSString());
            } else {
                this.locationPathField.setText(new Path(selectedDirectory).toOSString());
            }
        }
        this.targetLocation = this.locationPathField.getText();
    }

    public String getTargetLocation() {
        if (this.isCustomLocationSpecified()) {
            return this.targetLocation;
        }
        return null;
    }

    private boolean isCustomLocationSpecified() {
        return !this.useDefaults;
    }
}

