/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncSet;
import org.eclipse.team.internal.ccvs.ui.sync.MergeAction;
import org.eclipse.team.internal.ccvs.ui.sync.ToolTipMessageDialog;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.TeamFile;

public class ForceCommitSyncAction
extends MergeAction {
    public ForceCommitSyncAction(CVSSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(model, sp, label, shell);
    }

    protected SyncSet run(SyncSet syncSet, IProgressMonitor monitor) {
        RepositoryManager manager;
        IResource[] toBeAdded;
        ITeamNode[] changed;
        boolean result = this.saveIfNecessary();
        if (!result) {
            return null;
        }
        if (syncSet.hasConflicts() || syncSet.hasIncomingChanges()) {
            switch (this.promptForConflicts(syncSet)) {
                case 0: {
                    break;
                }
                case 1: {
                    syncSet.removeConflictingNodes();
                    syncSet.removeIncomingNodes();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if ((changed = syncSet.getChangedNodes()).length == 0) {
            return syncSet;
        }
        IResource[] unadded = null;
        if (syncSet instanceof CVSSyncSet) {
            CVSSyncSet cvsSyncSet = (CVSSyncSet)syncSet;
            try {
                if (cvsSyncSet.hasNonAddedChanges()) {
                    ITeamNode[] nodes = cvsSyncSet.getNonAddedNodes();
                    unadded = new IResource[nodes.length];
                    int i = 0;
                    while (i < nodes.length) {
                        unadded[i] = nodes[i].getResource();
                        ++i;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        if ((toBeAdded = this.promptForResourcesToBeAdded(manager = CVSUIPlugin.getPlugin().getRepositoryManager(), unadded)) == null) {
            return null;
        }
        final String comment = this.promptForComment(manager, syncSet.getResources());
        if (comment == null) {
            return null;
        }
        if (unadded != null && unadded.length > 0) {
            ArrayList<IResource> resourcesToRemove = new ArrayList<IResource>(unadded.length);
            int i = 0;
            while (i < unadded.length) {
                IResource unaddedResource = unadded[i];
                boolean included = false;
                int j = 0;
                while (j < toBeAdded.length) {
                    IResource resourceToAdd = toBeAdded[j];
                    if (unaddedResource.equals((Object)resourceToAdd)) {
                        included = true;
                        break;
                    }
                    ++j;
                }
                if (!included) {
                    resourcesToRemove.add(unaddedResource);
                }
                ++i;
            }
            CVSSyncSet cvsSyncSet = (CVSSyncSet)syncSet;
            cvsSyncSet.removeNonAddedResources(resourcesToRemove.toArray(new IResource[resourcesToRemove.size()]));
            changed = syncSet.getChangedNodes();
            if (changed.length == 0) {
                return syncSet;
            }
        }
        final ArrayList<IResource> commits = new ArrayList<IResource>();
        final ArrayList<IResource> additions = new ArrayList<IResource>();
        final ArrayList<IResource> deletions = new ArrayList<IResource>();
        final ArrayList<IRemoteSyncElement> toMerge = new ArrayList<IRemoteSyncElement>();
        final ArrayList<ITeamNode> incoming = new ArrayList<ITeamNode>();
        final ArrayList<IDiffContainer> parentCreationElements = new ArrayList<IDiffContainer>();
        final ArrayList<IDiffContainer> parentConflictElements = new ArrayList<IDiffContainer>();
        int i = 0;
        while (i < changed.length) {
            IDiffContainer parent;
            int kind = changed[i].getKind();
            IResource resource = changed[i].getResource();
            if (resource.getType() == 1) {
                commits.add(resource);
            }
            if ((parent = changed[i].getParent()) != null) {
                int parentKind = changed[i].getParent().getKind();
                if ((parentKind & 3) == 1 && (parentKind & 0xC) == 8) {
                    parentCreationElements.add(parent);
                } else if ((parentKind & 0xC) == 12) {
                    parentConflictElements.add(parent);
                }
            }
            block6 : switch (kind & 0xC) {
                case 8: {
                    incoming.add(changed[i]);
                    break;
                }
                case 4: {
                    switch (kind & 3) {
                        case 1: {
                            additions.add(resource);
                            break block6;
                        }
                        case 2: {
                            deletions.add(resource);
                            break block6;
                        }
                    }
                    break;
                }
                case 12: {
                    if (!(changed[i] instanceof TeamFile)) break;
                    toMerge.add(((TeamFile)changed[i]).getMergeResource().getSyncElement());
                }
            }
            ++i;
        }
        try {
            CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()).run(new ICVSRunnable(){

                public void run(IProgressMonitor monitor) throws CVSException {
                    try {
                        ITeamNode node;
                        Iterator it;
                        if (parentCreationElements.size() > 0) {
                            it = parentCreationElements.iterator();
                            while (it.hasNext()) {
                                ForceCommitSyncAction.this.makeInSync((IDiffElement)it.next());
                            }
                        }
                        if (parentConflictElements.size() > 0) {
                            it = parentConflictElements.iterator();
                            while (it.hasNext()) {
                                ForceCommitSyncAction.this.makeInSync((IDiffElement)it.next());
                            }
                        }
                        it = incoming.iterator();
                        HashSet incomingDeletions = new HashSet(incoming.size());
                        while (it.hasNext()) {
                            node = (ITeamNode)it.next();
                            ForceCommitSyncAction.this.collectIncomingDeletions(node, incomingDeletions, monitor);
                            if (!(node instanceof TeamFile) || additions.contains(node)) continue;
                            CVSRemoteSyncElement element = (CVSRemoteSyncElement)((TeamFile)node).getMergeResource().getSyncElement();
                            element.makeOutgoing(monitor);
                        }
                        it = incomingDeletions.iterator();
                        while (it.hasNext()) {
                            node = (ITeamNode)it.next();
                            CVSRemoteSyncElement syncElement = node instanceof TeamFile ? (CVSRemoteSyncElement)((TeamFile)node).getMergeResource().getSyncElement() : (CVSRemoteSyncElement)((ChangedTeamContainer)node).getMergeResource().getSyncElement();
                            additions.add(syncElement.getLocal());
                            CVSWorkspaceRoot.getCVSResourceFor((IResource)syncElement.getLocal()).unmanage(null);
                        }
                        if (additions.size() != 0) {
                            manager.add(additions.toArray(new IResource[0]), monitor);
                        }
                        if (deletions.size() != 0) {
                            manager.delete(deletions.toArray(new IResource[0]), monitor);
                        }
                        if (toMerge.size() != 0) {
                            manager.merged(toMerge.toArray(new IRemoteSyncElement[0]));
                        }
                        manager.commit(commits.toArray(new IResource[commits.size()]), comment, monitor);
                    }
                    catch (TeamException e) {
                        throw CVSException.wrapException((CoreException)((Object)e));
                    }
                }
            }, monitor);
        }
        catch (CVSException e) {
            this.handle(e);
            return null;
        }
        return syncSet;
    }

    protected boolean isEnabled(ITeamNode node) {
        CVSSyncSet set = new CVSSyncSet((IStructuredSelection)new StructuredSelection((Object)node));
        if (this.syncMode == 2) {
            return set.hasConflicts() && this.hasRealChanges((IDiffElement)node, new int[]{12});
        }
        return (set.hasIncomingChanges() || set.hasConflicts()) && this.hasRealChanges((IDiffElement)node, new int[]{12, 8});
    }

    protected int promptForConflicts(SyncSet syncSet) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        String question = Policy.bind("CommitSyncAction.questionRelease");
        String title = Policy.bind("CommitSyncAction.titleRelease");
        String[] tips = new String[]{Policy.bind("CommitSyncAction.releaseAll"), Policy.bind("CommitSyncAction.releasePart"), Policy.bind("CommitSyncAction.cancelRelease")};
        Shell shell = this.getShell();
        final ToolTipMessageDialog dialog = new ToolTipMessageDialog(shell, title, null, question, 3, buttons, tips, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    protected String promptForComment(RepositoryManager manager, IResource[] resourcesToCommit) {
        return manager.promptForComment(this.getShell(), resourcesToCommit);
    }

    protected IResource[] promptForResourcesToBeAdded(RepositoryManager manager, IResource[] unadded) {
        return manager.promptForResourcesToBeAdded(this.getShell(), unadded);
    }

    protected void removeNonApplicableNodes(SyncSet set, int syncMode) {
        set.removeOutgoingNodes();
        if (syncMode != 3) {
            set.removeIncomingNodes();
        }
    }

    private void collectIncomingDeletions(ITeamNode node, Set additions, IProgressMonitor monitor) throws TeamException {
        if (this.isIncomingDeletion(node) && !additions.contains(node) && !this.existsRemotely(node, monitor)) {
            IDiffContainer parent = node.getParent();
            if (this.isIncomingDeletion((ITeamNode)parent)) {
                this.collectIncomingDeletions((ITeamNode)parent, additions, monitor);
            }
            additions.add(node);
        }
    }

    private boolean isIncomingDeletion(ITeamNode node) {
        return node.getChangeDirection() == 8 && node.getChangeType() == 2;
    }

    private boolean existsRemotely(ITeamNode node, IProgressMonitor monitor) throws TeamException {
        CVSRemoteSyncElement syncElement = node instanceof TeamFile ? (CVSRemoteSyncElement)((TeamFile)node).getMergeResource().getSyncElement() : (CVSRemoteSyncElement)((ChangedTeamContainer)node).getMergeResource().getSyncElement();
        if (syncElement.getRemote() != null) {
            return true;
        }
        if (syncElement.getLocal().getType() == 1) {
            return false;
        }
        return CVSWorkspaceRoot.getRemoteResourceFor((IResource)syncElement.getLocal()).exists(monitor);
    }

    protected String getHelpContextID() {
        return "org.eclipse.team.cvs.ui.sync_forced_commit_action_context";
    }

    protected String getErrorTitle() {
        return Policy.bind("CommitAction.commitFailed");
    }
}

