/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;

public class CVSSyncSet
extends SyncSet {
    public CVSSyncSet(IStructuredSelection nodeSelection) {
        super(nodeSelection);
    }

    public ITeamNode[] getNonAddedNodes() throws CVSException {
        ArrayList<ITeamNode> result = new ArrayList<ITeamNode>();
        ITeamNode[] changedNodes = this.getChangedNodes();
        int i = 0;
        while (i < changedNodes.length) {
            ITeamNode node = changedNodes[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)node.getResource());
            if (cvsResource.isFolder()) {
                if (!((ICVSFolder)cvsResource).isCVSFolder()) {
                    result.add(node);
                }
            } else if (!cvsResource.isManaged()) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ITeamNode[result.size()]);
    }

    public boolean hasNonAddedChanges() throws CVSException {
        ITeamNode[] changedNodes = this.getChangedNodes();
        int i = 0;
        while (i < changedNodes.length) {
            ITeamNode node = changedNodes[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)node.getResource());
            if (cvsResource.exists() && (cvsResource.isFolder() ? !((ICVSFolder)cvsResource).isCVSFolder() : !cvsResource.isManaged())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeNonAddedChanges() {
        Iterator it = this.getSyncSet().iterator();
        while (it.hasNext()) {
            try {
                ITeamNode node = (ITeamNode)it.next();
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)node.getResource());
                if (!cvsResource.exists()) continue;
                if (cvsResource.isFolder()) {
                    if (((ICVSFolder)cvsResource).isCVSFolder()) continue;
                    it.remove();
                    continue;
                }
                if (cvsResource.isManaged()) continue;
                it.remove();
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return false;
    }

    public boolean removeNonAddedResources(IResource[] remove) {
        Iterator it = this.getSyncSet().iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            IResource resource = node.getResource();
            boolean included = false;
            int j = 0;
            while (j < remove.length) {
                IResource resourceToRemove = remove[j];
                if (resource.equals((Object)resourceToRemove)) {
                    included = true;
                    break;
                }
                ++j;
            }
            if (!included) continue;
            it.remove();
        }
        return false;
    }

    public boolean removeAddedChanges() {
        Iterator it = this.getSyncSet().iterator();
        while (it.hasNext()) {
            try {
                ITeamNode node = (ITeamNode)it.next();
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)node.getResource());
                if (cvsResource.isFolder()) {
                    if (!((ICVSFolder)cvsResource).isCVSFolder()) continue;
                    it.remove();
                    continue;
                }
                if (!cvsResource.isManaged()) continue;
                it.remove();
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return false;
    }

    public String getStatusLineMessage() {
        int incoming = 0;
        int outgoing = 0;
        int conflicts = 0;
        int newResources = 0;
        ITeamNode[] nodes = this.getChangedNodes();
        int i = 0;
        while (i < nodes.length) {
            ITeamNode next = nodes[i];
            switch (next.getChangeDirection()) {
                case 8: {
                    ++incoming;
                    break;
                }
                case 4: {
                    ++outgoing;
                    ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)next.getResource());
                    try {
                        if (!cvsResource.exists()) break;
                        if (cvsResource.isFolder()) {
                            if (((ICVSFolder)cvsResource).isCVSFolder()) break;
                            ++newResources;
                            break;
                        }
                        if (cvsResource.isManaged()) break;
                        ++newResources;
                    }
                    catch (CVSException e) {
                        CVSUIPlugin.log((CoreException)((Object)e));
                    }
                    break;
                }
                case 12: {
                    ++conflicts;
                }
            }
            ++i;
        }
        StringBuffer result = new StringBuffer();
        if (conflicts == 0) {
            result.append(Policy.bind("CVSSyncSet.noConflicts"));
        } else {
            result.append(Policy.bind("CVSSyncSet.conflicts", new Object[]{Integer.toString(conflicts)}));
        }
        if (incoming == 0) {
            result.append(Policy.bind("CVSSyncSet.noIncomings"));
        } else {
            result.append(Policy.bind("CVSSyncSet.incomings", new Object[]{Integer.toString(incoming)}));
        }
        if (outgoing == 0) {
            result.append(Policy.bind("CVSSyncSet.noOutgoings"));
        } else {
            result.append(Policy.bind("CVSSyncSet.outgoings", new Object[]{Integer.toString(outgoing)}));
        }
        if (newResources == 0) {
            result.append(Policy.bind("CVSSyncSet.noNew"));
        } else {
            result.append(Policy.bind("CVSSyncSet.new", new Object[]{Integer.toString(newResources)}));
        }
        return result.toString();
    }
}

