/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.AvoidableMessageDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.sync.CVSCatchupReleaseViewer;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncSet;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.TeamFile;

public class CVSSyncCompareInput
extends SyncCompareInput {
    private IResource[] resources;
    private boolean onlyOutgoing = false;

    public CVSSyncCompareInput(IResource[] resources) {
        this(resources, false);
    }

    protected CVSSyncCompareInput(IResource[] resources, int granularity) {
        super(granularity);
        this.resources = this.getNonOverlapping(resources);
    }

    public CVSSyncCompareInput(IResource[] resources, boolean onlyOutgoing) {
        super(CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_consider_contents") ? 2 : 1);
        this.onlyOutgoing = onlyOutgoing;
        this.resources = this.getNonOverlapping(resources);
    }

    private IResource[] getNonOverlapping(IResource[] resources) {
        ArrayList<IResource> sorted = new ArrayList<IResource>();
        sorted.addAll(Arrays.asList(resources));
        Collections.sort(sorted, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IResource resource0 = (IResource)arg0;
                IResource resource1 = (IResource)arg1;
                return resource0.getFullPath().segmentCount() - resource1.getFullPath().segmentCount();
            }

            public boolean equals(Object arg0) {
                return false;
            }
        });
        ArrayList<IPath> coveredPaths = new ArrayList<IPath>();
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IPath resourceFullPath = resource.getFullPath();
            boolean covered = false;
            Iterator it = coveredPaths.iterator();
            while (it.hasNext()) {
                IPath path = (IPath)it.next();
                if (!path.isPrefixOf(resourceFullPath)) continue;
                covered = true;
            }
            if (covered) {
                iter.remove();
                continue;
            }
            if (resource.getType() != 2) continue;
            coveredPaths.add(resource.getFullPath());
        }
        return sorted.toArray(new IResource[sorted.size()]);
    }

    public Viewer createDiffViewer(Composite parent) {
        CVSCatchupReleaseViewer catchupReleaseViewer = new CVSCatchupReleaseViewer(parent, this);
        this.setViewer(catchupReleaseViewer);
        return catchupReleaseViewer;
    }

    protected IRemoteSyncElement[] createSyncElements(IProgressMonitor monitor) throws TeamException {
        IResource[] resourcesToSync;
        int i = 0;
        while (i < this.resources.length) {
            IResource resource = this.resources[i];
            if (!resource.getProject().exists()) {
                throw new CVSException(Policy.bind("CVSSyncCompareInput.projectDeleted", resource.getProject().getName()));
            }
            ++i;
        }
        monitor.beginTask(null, 1000 + (this.onlyOutgoing ? 10 : 0));
        if (this.onlyOutgoing) {
            List filteredResources = Arrays.asList(this.resources);
            filteredResources = this.filterOutgoingChangesSet(filteredResources, Policy.subMonitorFor(monitor, 10));
            resourcesToSync = filteredResources.toArray(new IResource[filteredResources.size()]);
        } else {
            resourcesToSync = this.resources;
        }
        return this.buildSyncTrees(resourcesToSync, Policy.subMonitorFor(monitor, 1000));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRemoteSyncElement[] buildSyncTrees(IResource[] resourcesToSync, IProgressMonitor monitor) throws TeamException {
        IRemoteSyncElement[] trees = new IRemoteSyncElement[resourcesToSync.length];
        int work = 1000 * resourcesToSync.length;
        monitor.beginTask(null, work);
        try {
            int i = 0;
            while (i < trees.length) {
                trees[i] = CVSWorkspaceRoot.getRemoteSyncTree((IResource)resourcesToSync[i], null, (IProgressMonitor)Policy.subMonitorFor(monitor, 1000));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
        return trees;
    }

    protected void updateView() {
        if (this.getDiffRoot().hasChildren()) {
            this.getViewer().refresh();
        } else {
            this.getViewer().setInput(null);
        }
        this.updateStatusLine();
    }

    protected void compareInputChanged(ICompareInput source) {
        super.compareInputChanged(source);
        this.updateView();
        Shell shell = this.getShell();
        if (shell != null && source instanceof TeamFile) {
            TeamFile file = (TeamFile)source;
            int direction = file.getChangeDirection();
            file.getChangeType();
            if (direction == 8 || direction == 12) {
                this.promptForConfirmMerge(this.getShell());
            }
        }
    }

    public static CVSRemoteSyncElement getSyncElementFrom(Object node) {
        CVSRemoteSyncElement element = null;
        if (node instanceof TeamFile) {
            element = (CVSRemoteSyncElement)((TeamFile)node).getMergeResource().getSyncElement();
        } else if (node instanceof ChangedTeamContainer) {
            element = (CVSRemoteSyncElement)((ChangedTeamContainer)node).getMergeResource().getSyncElement();
        }
        return element;
    }

    public IResource[] getResources() {
        return this.resources;
    }

    private void promptForConfirmMerge(final Shell shell) {
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        if (!store.getBoolean("pref_prompt_on_saving_in_sync")) {
            return;
        }
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                AvoidableMessageDialog dialog = new AvoidableMessageDialog(shell, Policy.bind("CVSSyncCompareInput.confirmMergeMessageTitle"), null, Policy.bind("CVSSyncCompareInput.confirmMergeMessage"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
                if (dialog.isDontShowAgain()) {
                    store.setValue("pref_prompt_on_saving_in_sync", false);
                }
            }
        });
    }

    public Object prepareInput(IProgressMonitor pm) throws InterruptedException, InvocationTargetException {
        final Object[] result = new Object[1];
        CVSUIPlugin.runWithRefresh(this.getShell(), this.resources, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                result[0] = CVSSyncCompareInput.super.prepareInput(monitor);
            }
        }, pm);
        if (this.hasDifferences(result[0])) {
            return result[0];
        }
        return null;
    }

    private boolean hasDifferences(Object object) {
        if (object instanceof IDiffElement) {
            IDiffContainer container;
            IDiffElement element = (IDiffElement)object;
            if (element.getKind() != 0) {
                return true;
            }
            if (object instanceof IDiffContainer && (container = (IDiffContainer)object).hasChildren()) {
                IDiffElement[] children = container.getChildren();
                int i = 0;
                while (i < children.length) {
                    IDiffElement child = children[i];
                    if (this.hasDifferences(child)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean hasIncomingChanges(ChangedTeamContainer container) {
        IDiffElement[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            boolean hasIncomingChanges;
            IDiffElement element = children[i];
            int direction = element.getKind() & 0xC;
            if (direction == 12 || direction == 8) {
                return true;
            }
            if (element instanceof ChangedTeamContainer && (hasIncomingChanges = this.hasIncomingChanges((ChangedTeamContainer)element))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Map getProviderMapping(IResource[] resources) {
        HashMap<RepositoryProvider, ArrayList<IResource>> result = new HashMap<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    protected SyncSet getSyncSet(IStructuredSelection selection) {
        return new CVSSyncSet(selection);
    }

    private List filterOutgoingChangesSet(List resources, IProgressMonitor monitor) throws CVSException {
        ArrayList<IResource> arrayList;
        try {
            monitor.beginTask(null, 100 * resources.size());
            monitor.subTask(Policy.bind("CVSSyncCompareInput.filteringOutgoingChanges"));
            ArrayList<IResource> result = new ArrayList<IResource>();
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                IResource resource = (IResource)iter.next();
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                if (cvsResource.isIgnored() || !cvsResource.isModified(Policy.subMonitorFor(monitor, 100))) continue;
                result.add(resource);
            }
            arrayList = result;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return arrayList;
    }
}

