/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.sync;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.HistoryView;
import org.eclipse.team.internal.ccvs.ui.OverlayIconCache;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.merge.OverrideUpdateMergeAction;
import org.eclipse.team.internal.ccvs.ui.merge.UpdateMergeAction;
import org.eclipse.team.internal.ccvs.ui.merge.UpdateWithForcedJoinAction;
import org.eclipse.team.internal.ccvs.ui.sync.AddSyncAction;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncSet;
import org.eclipse.team.internal.ccvs.ui.sync.CommitSyncAction;
import org.eclipse.team.internal.ccvs.ui.sync.ForceCommitSyncAction;
import org.eclipse.team.internal.ccvs.ui.sync.ForceUpdateSyncAction;
import org.eclipse.team.internal.ccvs.ui.sync.IgnoreAction;
import org.eclipse.team.internal.ccvs.ui.sync.UpdateSyncAction;
import org.eclipse.team.internal.ui.OverlayIcon;
import org.eclipse.team.internal.ui.sync.CatchupReleaseViewer;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.MergeResource;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.team.internal.ui.sync.TeamFile;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSCatchupReleaseViewer
extends CatchupReleaseViewer {
    private UpdateSyncAction updateAction;
    private ForceUpdateSyncAction forceUpdateAction;
    private CommitSyncAction commitAction;
    private ForceCommitSyncAction forceCommitAction;
    private UpdateMergeAction updateMergeAction;
    private UpdateWithForcedJoinAction updateWithJoinAction;
    private OverrideUpdateMergeAction forceUpdateMergeAction;
    private IgnoreAction ignoreAction;
    private HistoryAction showInHistory;
    private Action confirmMerge;
    private AddSyncAction addAction;
    private Action selectAdditions;
    private Image conflictImage;

    public CVSCatchupReleaseViewer(Composite parent, CVSSyncCompareInput model) {
        super(parent, (SyncCompareInput)model);
        this.initializeActions(model);
        this.initializeLabelProvider();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.team.cvs.ui.catchup_release_viewer_context");
    }

    private Image getConflictImage() {
        if (this.conflictImage != null) {
            return this.conflictImage;
        }
        ImageDescriptor conflictDescriptor = CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/confauto_ov.gif");
        this.conflictImage = conflictDescriptor.createImage();
        return this.conflictImage;
    }

    private void initializeLabelProvider() {
        final LabelProvider oldProvider = (LabelProvider)this.getLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private OverlayIconCache iconCache = new OverlayIconCache();

            public void dispose() {
                this.iconCache.disposeAll();
                oldProvider.dispose();
                if (CVSCatchupReleaseViewer.this.conflictImage != null) {
                    CVSCatchupReleaseViewer.this.conflictImage.dispose();
                }
            }

            public Image getImage(Object element) {
                boolean conflict;
                Image image = oldProvider.getImage(element);
                if (!(element instanceof ITeamNode)) {
                    return image;
                }
                ITeamNode node = (ITeamNode)element;
                IResource resource = node.getResource();
                if (!resource.exists()) {
                    return image;
                }
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
                ArrayList<ImageDescriptor> overlays = new ArrayList<ImageDescriptor>();
                ArrayList<Integer> locations = new ArrayList<Integer>();
                ImageDescriptor resourceOverlay = CVSLightweightDecorator.getOverlay(node.getResource(), false, provider);
                int kind = node.getKind();
                boolean bl = conflict = (kind & 0x20) != 0;
                if (resourceOverlay != null) {
                    overlays.add(resourceOverlay);
                    locations.add(new Integer(3));
                }
                if (conflict) {
                    overlays.add(CVSUIPlugin.getPlugin().getImageDescriptor("ovr16/confauto_ov.gif"));
                    locations.add(new Integer(0));
                }
                if (overlays.isEmpty()) {
                    return image;
                }
                Integer[] integers = locations.toArray(new Integer[locations.size()]);
                int[] locs = new int[integers.length];
                int i = 0;
                while (i < integers.length) {
                    locs[i] = integers[i];
                    ++i;
                }
                return this.iconCache.getImageFor(new DiffOverlayIcon(image, overlays.toArray(new ImageDescriptor[overlays.size()]), locs));
            }

            public String getText(Object element) {
                String label = oldProvider.getText(element);
                if (!(element instanceof ITeamNode)) {
                    return label;
                }
                ITeamNode node = (ITeamNode)element;
                IResource resource = node.getResource();
                if (resource.exists()) {
                    Decoration decoration = new Decoration();
                    CVSLightweightDecorator.decorateTextLabel(resource, decoration, false, false);
                    label = String.valueOf(decoration.prefix) + label + decoration.suffix;
                }
                return label;
            }
        });
    }

    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        if (this.showInHistory != null) {
            manager.add((IAction)this.showInHistory);
        }
        manager.add((IContributionItem)new Separator());
        switch (this.getSyncMode()) {
            case 1: {
                this.updateAction.update(1);
                manager.add((IAction)this.updateAction);
                this.forceUpdateAction.update(1);
                manager.add((IAction)this.forceUpdateAction);
                manager.add((IContributionItem)new Separator());
                this.confirmMerge.setEnabled(this.confirmMerge.isEnabled());
                manager.add((IAction)this.confirmMerge);
                break;
            }
            case 2: {
                this.addAction.update(2);
                manager.add((IAction)this.addAction);
                this.commitAction.update(2);
                manager.add((IAction)this.commitAction);
                this.forceCommitAction.update(2);
                manager.add((IAction)this.forceCommitAction);
                this.ignoreAction.update();
                manager.add((IAction)this.ignoreAction);
                manager.add((IContributionItem)new Separator());
                this.confirmMerge.setEnabled(this.confirmMerge.isEnabled());
                manager.add((IAction)this.confirmMerge);
                this.selectAdditions.setEnabled(this.selectAdditions.isEnabled());
                manager.add((IAction)this.selectAdditions);
                break;
            }
            case 3: {
                this.addAction.update(3);
                manager.add((IAction)this.addAction);
                this.commitAction.update(3);
                manager.add((IAction)this.commitAction);
                this.updateAction.update(3);
                manager.add((IAction)this.updateAction);
                this.ignoreAction.update();
                manager.add((IAction)this.ignoreAction);
                manager.add((IContributionItem)new Separator());
                this.forceCommitAction.update(3);
                manager.add((IAction)this.forceCommitAction);
                this.forceUpdateAction.update(3);
                manager.add((IAction)this.forceUpdateAction);
                manager.add((IContributionItem)new Separator());
                this.confirmMerge.setEnabled(this.confirmMerge.isEnabled());
                manager.add((IAction)this.confirmMerge);
                break;
            }
            case 4: {
                this.updateMergeAction.update(1);
                this.forceUpdateMergeAction.update(1);
                this.updateWithJoinAction.update(1);
                manager.add((IAction)this.updateMergeAction);
                manager.add((IAction)this.forceUpdateMergeAction);
                manager.add((IAction)this.updateWithJoinAction);
            }
        }
    }

    private void initializeActions(final CVSSyncCompareInput diffModel) {
        Shell shell = this.getControl().getShell();
        this.commitAction = new CommitSyncAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.commit"), shell);
        this.forceCommitAction = new ForceCommitSyncAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.forceCommit"), shell);
        this.updateAction = new UpdateSyncAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.update"), shell);
        this.forceUpdateAction = new ForceUpdateSyncAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.forceUpdate"), shell);
        this.updateMergeAction = new UpdateMergeAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.update"), shell);
        this.ignoreAction = new IgnoreAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.ignore"), shell);
        this.updateWithJoinAction = new UpdateWithForcedJoinAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.mergeUpdate"), shell);
        this.forceUpdateMergeAction = new OverrideUpdateMergeAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.forceUpdate"), shell);
        this.addAction = new AddSyncAction(diffModel, (ISelectionProvider)this, Policy.bind("CVSCatchupReleaseViewer.addAction"), shell);
        this.showInHistory = new HistoryAction(Policy.bind("CVSCatchupReleaseViewer.showInHistory"));
        WorkbenchHelp.setHelp((IAction)this.showInHistory, (String)"org.eclipse.team.cvs.ui.show_in_history_action_context");
        this.addSelectionChangedListener(this.showInHistory);
        this.selectAdditions = new Action(Policy.bind("CVSCatchupReleaseViewer.Select_&Outgoing_Additions_1"), null){

            public boolean isEnabled() {
                DiffNode node = diffModel.getDiffRoot();
                IDiffElement[] elements = node.getChildren();
                int i = 0;
                while (i < elements.length) {
                    block5: {
                        IDiffElement element = elements[i];
                        if (element instanceof ITeamNode) {
                            CVSSyncSet set = new CVSSyncSet((IStructuredSelection)new StructuredSelection((Object)element));
                            try {
                                if (set.hasNonAddedChanges()) {
                                    return true;
                                }
                                break block5;
                            }
                            catch (CVSException e) {
                                CVSUIPlugin.log((CoreException)((Object)e));
                                return true;
                            }
                        }
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public void run() {
                ArrayList additions = new ArrayList();
                DiffNode root = diffModel.getDiffRoot();
                this.visit((IDiffElement)root, additions);
                CVSCatchupReleaseViewer.this.setSelection((ISelection)new StructuredSelection(additions));
            }

            private void visit(IDiffElement node, List additions) {
                try {
                    ICVSResource cvsResource;
                    ChangedTeamContainer container;
                    if (node instanceof TeamFile) {
                        TeamFile file = (TeamFile)node;
                        if (file.getChangeDirection() == 4 && file.getChangeType() == 1) {
                            ICVSResource cvsResource2 = CVSWorkspaceRoot.getCVSResourceFor((IResource)file.getResource());
                            if (cvsResource2.isManaged()) {
                                return;
                            }
                            additions.add(node);
                        }
                        return;
                    }
                    if (node instanceof ChangedTeamContainer && (container = (ChangedTeamContainer)node).getChangeDirection() == 4 && container.getChangeType() == 1 && !((ICVSFolder)(cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)container.getResource()))).isCVSFolder()) {
                        additions.add(node);
                    }
                    if (node instanceof DiffContainer) {
                        IDiffElement[] children = ((DiffContainer)node).getChildren();
                        int i = 0;
                        while (i < children.length) {
                            this.visit(children[i], additions);
                            ++i;
                        }
                    }
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
        };
        WorkbenchHelp.setHelp((IAction)this.selectAdditions, (String)"org.eclipse.team.cvs.ui.select_new_action_context");
        this.confirmMerge = new Action(Policy.bind("CVSCatchupReleaseViewer.confirmMerge"), null){

            public void run() {
                ISelection s = CVSCatchupReleaseViewer.this.getSelection();
                if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
                    return;
                }
                ArrayList needsMerge = new ArrayList();
                Iterator it = ((IStructuredSelection)s).iterator();
                while (it.hasNext()) {
                    Object element = it.next();
                    if (!(element instanceof DiffElement)) continue;
                    CVSCatchupReleaseViewer.this.mergeRecursive((IDiffElement)element, needsMerge);
                }
                TeamFile[] files = needsMerge.toArray(new TeamFile[needsMerge.size()]);
                if (files.length != 0) {
                    try {
                        int i = 0;
                        while (i < files.length) {
                            TeamFile teamFile = files[i];
                            CVSUIPlugin.getPlugin().getRepositoryManager().merged(new IRemoteSyncElement[]{teamFile.getMergeResource().getSyncElement()});
                            teamFile.merged();
                            ++i;
                        }
                    }
                    catch (TeamException e) {
                        CVSUIPlugin.openError(CVSCatchupReleaseViewer.this.getControl().getShell(), null, null, e);
                    }
                }
                CVSCatchupReleaseViewer.this.refresh();
                diffModel.updateStatusLine();
            }

            public boolean isEnabled() {
                ISelection s = CVSCatchupReleaseViewer.this.getSelection();
                if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
                    return false;
                }
                Iterator it = ((IStructuredSelection)s).iterator();
                while (it.hasNext()) {
                    Object element = it.next();
                    if (element instanceof TeamFile) {
                        TeamFile file = (TeamFile)element;
                        int direction = file.getChangeDirection();
                        file.getChangeType();
                        if (direction == 8 || direction == 12) continue;
                    }
                    return false;
                }
                return true;
            }
        };
        WorkbenchHelp.setHelp((IAction)this.confirmMerge, (String)"org.eclipse.team.cvs.ui.confirm_merge_action_context");
    }

    protected void mergeRecursive(IDiffElement element, List needsMerge) {
        if (element instanceof DiffContainer) {
            DiffContainer container = (DiffContainer)element;
            IDiffElement[] children = container.getChildren();
            int i = 0;
            while (i < children.length) {
                this.mergeRecursive(children[i], needsMerge);
                ++i;
            }
        } else if (element instanceof TeamFile) {
            TeamFile file = (TeamFile)element;
            needsMerge.add(file);
        }
    }

    protected void updateLabels(MergeResource resource) {
        String revision;
        CompareConfiguration config = this.getCompareConfiguration();
        String name = resource.getName();
        config.setLeftLabel(Policy.bind("CVSCatchupReleaseViewer.workspaceFile", name));
        IRemoteSyncElement syncTree = resource.getSyncElement();
        IRemoteResource remote = syncTree.getRemote();
        if (remote != null) {
            try {
                String[] author;
                block20: {
                    final ICVSRemoteFile remoteFile = (ICVSRemoteFile)remote;
                    revision = remoteFile.getRevision();
                    author = new String[]{""};
                    try {
                        CVSUIPlugin.runWithProgress(this.getTree().getShell(), true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    ILogEntry logEntry = remoteFile.getLogEntry(monitor);
                                    if (logEntry != null) {
                                        author[0] = logEntry.getAuthor();
                                    }
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (!(t instanceof TeamException)) break block20;
                        throw (TeamException)t;
                    }
                }
                config.setRightLabel(Policy.bind("CVSCatchupReleaseViewer.repositoryFileRevision", new Object[]{name, revision, author[0]}));
            }
            catch (TeamException e) {
                CVSUIPlugin.openError(this.getControl().getShell(), null, null, e);
                config.setRightLabel(Policy.bind("CVSCatchupReleaseViewer.repositoryFile", name));
            }
        } else {
            config.setRightLabel(Policy.bind("CVSCatchupReleaseViewer.noRepositoryFile"));
        }
        IRemoteResource base = syncTree.getBase();
        if (base != null) {
            try {
                revision = ((ICVSRemoteFile)base).getRevision();
                config.setAncestorLabel(Policy.bind("CVSCatchupReleaseViewer.commonFileRevision", new Object[]{name, revision}));
            }
            catch (TeamException e) {
                CVSUIPlugin.openError(this.getControl().getShell(), null, null, e);
                config.setRightLabel(Policy.bind("CVSCatchupReleaseViewer.commonFile", name));
            }
        } else {
            config.setAncestorLabel(Policy.bind("CVSCatchupReleaseViewer.noCommonFile"));
        }
        IResource local = syncTree.getLocal();
        if (local != null) {
            if (!local.exists()) {
                config.setLeftLabel(Policy.bind("CVSCatchupReleaseViewer.No_workspace_file_1"));
            } else {
                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)local));
                ResourceSyncInfo info = null;
                try {
                    info = cvsFile.getSyncInfo();
                    name = local.getName();
                    String revision2 = null;
                    if (info != null) {
                        revision2 = info.getRevision();
                        if (info.isAdded() || info.isDeleted()) {
                            revision2 = null;
                        }
                    }
                    if (revision2 != null) {
                        config.setLeftLabel(Policy.bind("CVSCatchupReleaseViewer.commonFileRevision", name, revision2));
                    } else {
                        config.setLeftLabel(Policy.bind("CVSCatchupReleaseViewer.commonFile", name));
                    }
                }
                catch (CVSException e) {
                    CVSUIPlugin.openError(this.getControl().getShell(), null, null, e);
                    config.setLeftLabel(Policy.bind("CVSCatchupReleaseViewer.commonFile", name));
                }
            }
        }
    }

    private static class DiffOverlayIcon
    extends OverlayIcon {
        private static final int HEIGHT = 16;
        private static final int WIDTH = 22;

        public DiffOverlayIcon(Image baseImage, ImageDescriptor[] overlays, int[] locations) {
            super(baseImage, overlays, locations, new Point(22, 16));
        }

        protected void drawOverlays(ImageDescriptor[] overlays, int[] locations) {
            Point size = this.getSize();
            int i = 0;
            while (i < overlays.length) {
                ImageDescriptor overlay = overlays[i];
                ImageData overlayData = overlay.getImageData();
                switch (locations[i]) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, size.x - overlayData.width, size.y - overlayData.height);
                    }
                }
                ++i;
            }
        }
    }

    private static class HistoryAction
    extends Action
    implements ISelectionChangedListener {
        IStructuredSelection selection;

        public HistoryAction(String label) {
            super(label);
        }

        public void run() {
            if (this.selection.isEmpty()) {
                return;
            }
            HistoryView view = HistoryView.openInActivePerspective();
            if (view == null) {
                return;
            }
            ITeamNode node = (ITeamNode)this.selection.getFirstElement();
            IRemoteSyncElement remoteSyncElement = ((TeamFile)node).getMergeResource().getSyncElement();
            ICVSRemoteFile remoteFile = (ICVSRemoteFile)remoteSyncElement.getRemote();
            IResource local = remoteSyncElement.getLocal();
            ICVSRemoteFile baseFile = (ICVSRemoteFile)remoteSyncElement.getBase();
            if (baseFile == null) {
                try {
                    baseFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)local);
                }
                catch (CVSException cVSException) {
                    baseFile = null;
                }
            }
            if (local.exists()) {
                view.showHistory(local);
            } else if (baseFile != null) {
                view.showHistory(baseFile);
            } else if (remoteFile != null) {
                view.showHistory(remoteFile);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                this.setEnabled(false);
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() != 1) {
                this.setEnabled(false);
                return;
            }
            ITeamNode first = (ITeamNode)ss.getFirstElement();
            if (first instanceof TeamFile) {
                this.selection = ss;
                IRemoteSyncElement remoteSyncElement = ((TeamFile)first).getMergeResource().getSyncElement();
                if (remoteSyncElement.getRemote() != null || remoteSyncElement.getBase() != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.selection = null;
                this.setEnabled(false);
            }
        }
    }

    private static class Decoration
    implements IDecoration {
        public String prefix = "";
        public String suffix = "";
        public ImageDescriptor overlay;

        Decoration() {
        }

        public void addPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void addSuffix(String suffix) {
            this.suffix = suffix;
        }

        public void addOverlay(ImageDescriptor overlay) {
            this.overlay = overlay;
        }
    }
}

