/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberAction;
import org.eclipse.team.internal.ccvs.ui.sync.ToolTipMessageDialog;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.team.ui.synchronize.actions.SyncInfoSet;

public class SubscriberCommitAction
extends CVSSubscriberAction {
    private String comment;

    protected SyncInfoFilter getSyncInfoFilter() {
        return new SyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
    }

    protected SyncInfoSet getFilteredSyncInfoSet(SyncInfo[] selectedResources) {
        SyncInfoSet syncSet = super.getFilteredSyncInfoSet(selectedResources);
        if (!this.promptForConflictHandling(syncSet)) {
            return null;
        }
        try {
            if (!this.promptForUnaddedHandling(syncSet)) {
                return null;
            }
        }
        catch (CVSException e) {
            Utils.handle((Throwable)e);
        }
        return syncSet;
    }

    protected boolean promptForConflictHandling(SyncInfoSet syncSet) {
        if (syncSet.hasConflicts() || syncSet.hasIncomingChanges()) {
            syncSet.removeConflictingNodes();
            syncSet.removeIncomingNodes();
        }
        return true;
    }

    private boolean promptForUnaddedHandling(SyncInfoSet syncSet) throws CVSException {
        if (syncSet.isEmpty()) {
            return false;
        }
        IResource[] unadded = this.getUnaddedResources(syncSet);
        RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        IResource[] toBeAdded = this.promptForResourcesToBeAdded(manager, unadded);
        if (toBeAdded == null) {
            return false;
        }
        this.comment = this.promptForComment(manager, syncSet.getResources());
        if (this.comment == null) {
            return false;
        }
        if (unadded != null && unadded.length > 0) {
            ArrayList<IResource> resourcesToRemove = new ArrayList<IResource>(unadded.length);
            int i = 0;
            while (i < unadded.length) {
                IResource unaddedResource = unadded[i];
                boolean included = false;
                int j = 0;
                while (j < toBeAdded.length) {
                    IResource resourceToAdd = toBeAdded[j];
                    if (unaddedResource.equals((Object)resourceToAdd)) {
                        included = true;
                        break;
                    }
                    ++j;
                }
                if (!included) {
                    resourcesToRemove.add(unaddedResource);
                }
                ++i;
            }
            syncSet.removeResources(resourcesToRemove.toArray(new IResource[resourcesToRemove.size()]));
        }
        return true;
    }

    private IResource[] getUnaddedResources(SyncInfoSet syncSet) throws CVSException {
        IResource[] resources = syncSet.getResources();
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!this.isAdded(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isAdded(IResource resource) throws CVSException {
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        if (cvsResource.isFolder()) {
            return ((ICVSFolder)cvsResource).isCVSFolder();
        }
        return cvsResource.isManaged();
    }

    private boolean isRemoved(IResource resource) throws CVSException {
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        if (!cvsResource.isFolder()) {
            byte[] syncBytes = ((ICVSFile)cvsResource).getSyncBytes();
            if (syncBytes == null) {
                return true;
            }
            return ResourceSyncInfo.isDeletion((byte[])syncBytes);
        }
        return true;
    }

    public void run(SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] changed = syncSet.getSyncInfos();
        if (changed.length == 0) {
            return;
        }
        ArrayList<IResource> commits = new ArrayList<IResource>();
        ArrayList<IResource> additions = new ArrayList<IResource>();
        ArrayList<IResource> deletions = new ArrayList<IResource>();
        ArrayList<SyncInfo> makeOutgoing = new ArrayList<SyncInfo>();
        ArrayList<SyncInfo> makeInSync = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < changed.length) {
            SyncInfo changedNode = changed[i];
            int kind = changedNode.getKind();
            IResource resource = changedNode.getLocal();
            SyncInfo parent = this.getParent(changedNode);
            if (parent != null && this.isOutOfSync(parent)) {
                makeInSync.add(parent);
            }
            if (resource.getType() == 1) {
                commits.add(resource);
                block1 : switch (kind & 0xC) {
                    case 8: {
                        makeOutgoing.add(changedNode);
                        break;
                    }
                    case 4: {
                        switch (kind & 3) {
                            case 1: {
                                if (this.isAdded(resource)) break;
                                additions.add(resource);
                                break block1;
                            }
                            case 2: {
                                if (this.isRemoved(resource)) break;
                                deletions.add(resource);
                                break block1;
                            }
                        }
                        break;
                    }
                    case 12: {
                        makeOutgoing.add(changedNode);
                    }
                }
            } else if ((kind & 0xC) == 4 && (kind & 3) == 1) {
                additions.add(changedNode.getLocal());
            } else if (this.isOutOfSync(changedNode)) {
                makeInSync.add(changedNode);
            }
            ++i;
        }
        try {
            int work = (makeOutgoing.size() + additions.size() + deletions.size() + commits.size()) * 100;
            monitor.beginTask(null, work);
            if (makeInSync.size() > 0) {
                this.makeInSync(makeInSync.toArray(new SyncInfo[makeInSync.size()]));
            }
            if (makeOutgoing.size() > 0) {
                this.makeOutgoing(makeOutgoing.toArray(new SyncInfo[makeInSync.size()]), Policy.subMonitorFor(monitor, makeOutgoing.size() * 100));
            }
            RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
            if (additions.size() != 0) {
                manager.add(additions.toArray(new IResource[0]), Policy.subMonitorFor(monitor, additions.size() * 100));
            }
            if (deletions.size() != 0) {
                manager.delete(deletions.toArray(new IResource[0]), Policy.subMonitorFor(monitor, deletions.size() * 100));
            }
            manager.commit(commits.toArray(new IResource[commits.size()]), this.comment, Policy.subMonitorFor(monitor, commits.size() * 100));
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
    }

    protected int promptForConflicts(SyncInfoSet syncSet) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        String question = Policy.bind("CommitSyncAction.questionRelease");
        String title = Policy.bind("CommitSyncAction.titleRelease");
        String[] tips = new String[]{Policy.bind("CommitSyncAction.releaseAll"), Policy.bind("CommitSyncAction.releasePart"), Policy.bind("CommitSyncAction.cancelRelease")};
        Shell shell = this.getShell();
        final ToolTipMessageDialog dialog = new ToolTipMessageDialog(shell, title, null, question, 3, buttons, tips, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    protected String promptForComment(RepositoryManager manager, IResource[] resourcesToCommit) {
        return manager.promptForComment(this.getShell(), resourcesToCommit);
    }

    protected IResource[] promptForResourcesToBeAdded(RepositoryManager manager, IResource[] unadded) {
        return manager.promptForResourcesToBeAdded(this.getShell(), unadded);
    }

    protected String getErrorTitle() {
        return Policy.bind("CommitAction.commitFailed");
    }

    protected String getJobName(SyncInfoSet syncSet) {
        return Policy.bind("CommitAction.jobName", new Integer(syncSet.size()).toString());
    }
}

