/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOnlyMergableOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberAction;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.team.ui.synchronize.actions.SyncInfoSet;

public abstract class SafeUpdateAction
extends CVSSubscriberAction {
    private List skippedFiles = new ArrayList();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        try {
            SyncInfoFilter failFilter = this.getKnownFailureCases();
            SyncInfo[] willFail = syncSet.getNodes(failFilter);
            syncSet.rejectNodes(failFilter);
            this.skippedFiles.clear();
            monitor.beginTask(null, (syncSet.size() + willFail.length) * 100);
            this.safeUpdate(syncSet, Policy.subMonitorFor(monitor, syncSet.size() * 100));
            final SyncInfoSet failedSet = this.createFailedSet(syncSet, willFail, this.skippedFiles.toArray(new IFile[this.skippedFiles.size()]));
            syncSet.rejectNodes(new SyncInfoFilter(){

                public boolean select(SyncInfo info) {
                    return failedSet.getNodeFor(info.getLocal()) != null;
                }
            });
            if (!failedSet.isEmpty()) {
                if (this.getOverwriteLocalChanges()) {
                    if (this.promptForOverwrite(failedSet)) {
                        this.overwriteUpdate(failedSet, Policy.subMonitorFor(monitor, willFail.length * 100));
                        syncSet.addAll(failedSet);
                    }
                } else {
                    this.warnAboutFailedResources(failedSet);
                }
            }
            this.updated(syncSet.getResources());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    protected boolean getOverwriteLocalChanges() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void safeUpdate(SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        Object var8_8;
        SyncInfo[] changed = syncSet.getSyncInfos();
        if (changed.length == 0) {
            return;
        }
        ArrayList<SyncInfo> updateShallow = new ArrayList<SyncInfo>();
        HashSet<SyncInfo> parentCreationElements = new HashSet<SyncInfo>();
        ArrayList<SyncInfo> updateDeletions = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < changed.length) {
            SyncInfo changedNode = changed[i];
            SyncInfo parent = this.getParent(changedNode);
            if (parent != null && this.isOutOfSync(parent)) {
                parentCreationElements.add(parent);
            }
            IResource resource = changedNode.getLocal();
            int kind = changedNode.getKind();
            boolean willBeAttempted = false;
            if (resource.getType() == 1) {
                block2 : switch (kind & 0xC) {
                    case 8: {
                        switch (kind & 3) {
                            case 2: {
                                updateDeletions.add(changedNode);
                                willBeAttempted = true;
                                break block2;
                            }
                        }
                        updateShallow.add(changedNode);
                        willBeAttempted = true;
                        break;
                    }
                    case 12: {
                        switch (kind & 3) {
                            case 3: {
                                updateShallow.add(changedNode);
                                willBeAttempted = true;
                            }
                        }
                        break;
                    }
                }
                if (!willBeAttempted) {
                    this.skippedFiles.add(resource);
                }
            } else if (this.isOutOfSync(changedNode)) {
                parentCreationElements.add(changedNode);
            }
            ++i;
        }
        try {
            int work = (updateDeletions.size() + updateShallow.size()) * 100;
            monitor.beginTask(null, work);
            if (parentCreationElements.size() > 0) {
                this.makeInSync(parentCreationElements.toArray(new SyncInfo[parentCreationElements.size()]));
            }
            if (updateDeletions.size() > 0) {
                this.runUpdateDeletions(updateDeletions.toArray(new SyncInfo[updateDeletions.size()]), Policy.subMonitorFor(monitor, updateDeletions.size() * 100));
            }
            if (updateShallow.size() > 0) {
                this.runSafeUpdate(updateShallow.toArray(new SyncInfo[updateShallow.size()]), Policy.subMonitorFor(monitor, updateShallow.size() * 100));
            }
            var8_8 = null;
        }
        catch (Throwable throwable) {
            var8_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected abstract void overwriteUpdate(SyncInfoSet var1, IProgressMonitor var2) throws TeamException;

    protected SyncInfoFilter getKnownFailureCases() {
        return new SyncInfoFilter.OrSyncInfoFilter(new SyncInfoFilter[]{new SyncInfoFilter.AndSyncInfoFilter(new SyncInfoFilter[]{SyncInfoFilter.getDirectionAndChangeFilter((int)12, (int)1), new SyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return info.getLocal().getType() == 1;
            }
        }}), new SyncInfoFilter.AndSyncInfoFilter(new SyncInfoFilter[]{SyncInfoFilter.getDirectionAndChangeFilter((int)12, (int)3), new SyncInfoFilter(){

            public boolean select(SyncInfo info) {
                IRemoteResource remote = info.getRemote();
                IRemoteResource base = info.getBase();
                if (info.getLocal().exists()) {
                    return base != null && remote == null;
                }
                return base != null && remote != null && !base.equals(remote);
            }
        }}), new SyncInfoFilter.AndSyncInfoFilter(new SyncInfoFilter[]{SyncInfoFilter.getDirectionAndChangeFilter((int)12, (int)3), new SyncInfoFilter(){

            public boolean select(SyncInfo info) {
                IResource local = info.getLocal();
                if (local.getType() == 1) {
                    try {
                        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)local));
                        byte[] syncBytes = file.getSyncBytes();
                        if (syncBytes != null) {
                            return ResourceSyncInfo.isBinary((byte[])syncBytes);
                        }
                    }
                    catch (CVSException e) {
                        CVSProviderPlugin.log((CoreException)((Object)e));
                        return true;
                    }
                }
                return false;
            }
        }}), new SyncInfoFilter.SyncInfoDirectionFilter(4)});
    }

    private SyncInfoSet createFailedSet(SyncInfoSet syncSet, SyncInfo[] willFail, IFile[] files) {
        ArrayList<SyncInfo> result = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            SyncInfo resource = syncSet.getNodeFor((IResource)file);
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        i = 0;
        while (i < willFail.length) {
            result.add(willFail[i]);
            ++i;
        }
        return new SyncInfoSet(result.toArray(new SyncInfo[result.size()]));
    }

    protected void warnAboutFailedResources(SyncInfoSet syncSet) {
        (new int[1])[0] = 1;
        TeamUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)((TeamAction)SafeUpdateAction.this).shell, (String)Policy.bind("SafeUpdateAction.warnFilesWithConflictsTitle"), (String)Policy.bind("SafeUpdateAction.warnFilesWithConflictsDescription"));
            }
        });
    }

    protected abstract void runUpdateDeletions(SyncInfo[] var1, IProgressMonitor var2) throws TeamException;

    protected abstract void runSafeUpdate(SyncInfo[] var1, IProgressMonitor var2) throws TeamException;

    protected void safeUpdate(IResource[] resources, Command.LocalOption[] localOptions, IProgressMonitor monitor) throws TeamException {
        try {
            UpdateOnlyMergableOperation operation = new UpdateOnlyMergableOperation(this.getShell(), resources, localOptions);
            operation.run(monitor);
            this.addSkippedFiles(operation.getSkippedFiles());
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Policy.cancelOperation();
        }
    }

    protected abstract void updated(IResource[] var1) throws TeamException;

    private void addSkippedFiles(IFile[] files) {
        this.skippedFiles.addAll(Arrays.asList(files));
    }

    protected String getErrorTitle() {
        return Policy.bind("UpdateAction.update");
    }

    protected String getJobName(SyncInfoSet syncSet) {
        return Policy.bind("UpdateAction.jobName", new Integer(syncSet.size()).toString());
    }
}

