/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.OverrideAndUpdateOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberAction;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.team.ui.synchronize.actions.SyncInfoSet;

public class OverrideAndUpdateAction
extends CVSSubscriberAction {
    protected SyncInfoFilter getSyncInfoFilter() {
        return new SyncInfoFilter.SyncInfoDirectionFilter(new int[]{12, 4});
    }

    private SyncInfoFilter getConflictingAdditionFilter() {
        return new SyncInfoFilter.AndSyncInfoFilter(new SyncInfoFilter[]{new SyncInfoFilter.SyncInfoDirectionFilter(new int[]{12}), new SyncInfoFilter.SyncInfoChangeTypeFilter(new int[]{1})});
    }

    protected void run(SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        try {
            if (this.promptForOverwrite(syncSet)) {
                SyncInfo[] conflicts = syncSet.getNodes(this.getConflictingAdditionFilter());
                ArrayList<IResource> conflictingResources = new ArrayList<IResource>();
                int i = 0;
                while (i < conflicts.length) {
                    SyncInfo info = conflicts[i];
                    conflictingResources.add(info.getLocal());
                    ++i;
                }
                new OverrideAndUpdateOperation(this.getShell(), syncSet.getResources(), conflictingResources.toArray(new IResource[conflictingResources.size()]), null, false).run(monitor);
            }
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Policy.cancelOperation();
        }
    }

    protected String getJobName(SyncInfoSet syncSet) {
        return Policy.bind("OverrideAndUpdateAction.jobName", new Integer(syncSet.size()).toString());
    }
}

