/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.SafeUpdateAction;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.team.ui.synchronize.actions.SyncInfoSet;

public class MergeUpdateAction
extends SafeUpdateAction {
    TeamSubscriber currentSubcriber = null;

    protected boolean getOverwriteLocalChanges() {
        return true;
    }

    protected SyncInfoFilter getSyncInfoFilter() {
        return new SyncInfoFilter.OrSyncInfoFilter(new SyncInfoFilter[]{new SyncInfoFilter.SyncInfoDirectionFilter(8), new SyncInfoFilter.SyncInfoDirectionFilter(12)});
    }

    protected void updated(IResource[] resources) throws TeamException {
        if (resources.length > 0 && this.currentSubcriber != null) {
            ((CVSMergeSubscriber)this.currentSubcriber).merged(resources);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runUpdateDeletions(SyncInfo[] nodes, IProgressMonitor monitor) throws TeamException {
        try {
            try {
                monitor.beginTask(null, 100 * nodes.length);
                int i = 0;
                while (i < nodes.length) {
                    IResource resource = nodes[i].getLocal();
                    if (resource.getType() == 1) {
                        ((IFile)resource).delete(false, true, Policy.subMonitorFor(monitor, 100));
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runSafeUpdate(SyncInfo[] nodes, IProgressMonitor monitor) throws TeamException {
        if (nodes.length <= 0) return;
        this.currentSubcriber = nodes[0].getSubscriber();
        if (!(this.currentSubcriber instanceof CVSMergeSubscriber)) {
            throw new CVSException(Policy.bind("MergeUpdateAction.invalidSubscriber", this.currentSubcriber.toString()));
        }
        CVSTag startTag = ((CVSMergeSubscriber)this.currentSubcriber).getStartTag();
        CVSTag endTag = ((CVSMergeSubscriber)this.currentSubcriber).getEndTag();
        ArrayList<SyncInfo> additions = new ArrayList<SyncInfo>();
        ArrayList<SyncInfo> changes = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < nodes.length) {
            SyncInfo resource = nodes[i];
            int kind = resource.getKind();
            if ((kind & 3) == 1) {
                additions.add(resource);
            } else {
                changes.add(resource);
            }
            ++i;
        }
        try {
            monitor.beginTask(null, (additions.size() + changes.size()) * 100);
            if (!additions.isEmpty()) {
                this.safeUpdate(this.getIResourcesFrom(additions.toArray(new SyncInfo[additions.size()])), new Command.LocalOption[]{Command.DO_NOT_RECURSE, Update.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)endTag.getName())}, Policy.subMonitorFor(monitor, additions.size() * 100));
            }
            if (!changes.isEmpty()) {
                this.safeUpdate(this.getIResourcesFrom(changes.toArray(new SyncInfo[changes.size()])), new Command.LocalOption[]{Command.DO_NOT_RECURSE, Update.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)startTag.getName()), Update.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)endTag.getName())}, Policy.subMonitorFor(monitor, changes.size() * 100));
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void overwriteUpdate(SyncInfoSet set, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] nodes = set.getSyncInfos();
        monitor.beginTask(null, 1000 * nodes.length);
        try {
            int i = 0;
            while (i < nodes.length) {
                this.makeRemoteLocal(nodes[i], Policy.subMonitorFor(monitor, 1000));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeRemoteLocal(SyncInfo info, IProgressMonitor monitor) throws TeamException {
        IRemoteResource remote = info.getRemote();
        IResource local = info.getLocal();
        try {
            if (remote == null) {
                local.delete(false, monitor);
                return;
            }
            if (remote.isContainer()) {
                this.ensureContainerExists(info);
                return;
            }
            monitor.beginTask(null, 200);
            try {
                IFile localFile = (IFile)local;
                if (local.exists()) {
                    localFile.setContents(remote.getContents(Policy.subMonitorFor(monitor, 100)), false, true, Policy.subMonitorFor(monitor, 100));
                } else {
                    this.ensureContainerExists(this.getParent(info));
                    localFile.create(remote.getContents(Policy.subMonitorFor(monitor, 100)), false, Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var6_9 = null;
                monitor.done();
                return;
            }
        }
        catch (CoreException e) {
            throw new CVSException(Policy.bind("UpdateMergeActionProblems_merging_remote_resources_into_workspace_1"), (Throwable)e);
        }
    }

    private boolean ensureContainerExists(SyncInfo info) throws TeamException {
        CVSSyncInfo cvsInfo;
        IStatus status;
        IResource local = info.getLocal();
        if (!local.exists() && !this.ensureContainerExists(this.getParent(info))) {
            return false;
        }
        if (this.isOutOfSync(info) && info instanceof CVSSyncInfo && (status = (cvsInfo = (CVSSyncInfo)info).makeInSync()).getSeverity() == 4) {
            this.logError(status);
            return false;
        }
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)local));
        if (!cvsFolder.exists()) {
            cvsFolder.mkdir();
        }
        return true;
    }

    protected String getJobName(SyncInfoSet syncSet) {
        return Policy.bind("MergeUpdateAction.jobName", new Integer(syncSet.size()).toString());
    }
}

