/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.MergeSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;

public class MergeSynchronizeParticipant
extends TeamSubscriberParticipant {
    private static final String CTX_QUALIFIER = "qualifier";
    private static final String CTX_LOCALNAME = "localname";
    private static final String CTX_ROOT = "root";
    private static final String CTX_ROOT_PATH = "root_resource";
    private static final String CTX_START_TAG = "start_tag";
    private static final String CTX_START_TAG_TYPE = "start_tag_type";
    private static final String CTX_END_TAG = "end_tag";
    private static final String CTX_END_TAG_TYPE = "end_tag_type";

    public MergeSynchronizeParticipant() {
    }

    public MergeSynchronizeParticipant(CVSMergeSubscriber subscriber) {
        this.setSubscriber((TeamSubscriber)subscriber);
    }

    protected void setSubscriber(TeamSubscriber subscriber) {
        super.setSubscriber(subscriber);
        String id = "org.eclipse.team.cvs.ui.cvsmerge-participant";
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(id);
            this.setInitializationData(descriptor);
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
    }

    public void init(IMemento memento) throws PartInitException {
        super.init(memento);
        if (memento != null) {
            String qualifier = memento.getString(CTX_QUALIFIER);
            String localname = memento.getString(CTX_LOCALNAME);
            if (qualifier == null || localname == null) {
                throw new PartInitException(Policy.bind("MergeSynchronizeParticipant.8"));
            }
            try {
                this.setSubscriber((TeamSubscriber)this.read(new QualifiedName(qualifier, localname), memento));
            }
            catch (CVSException e) {
                throw new PartInitException(Policy.bind("MergeSynchronizeParticipant.9"), (Throwable)e);
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        SubscriberInput input = this.getInput();
        CVSMergeSubscriber s = (CVSMergeSubscriber)input.getSubscriber();
        QualifiedName sId = s.getId();
        memento.putString(CTX_QUALIFIER, sId.getQualifier());
        memento.putString(CTX_LOCALNAME, sId.getLocalName());
        this.write(s, memento);
    }

    public void dispose() {
        super.dispose();
        ((CVSMergeSubscriber)this.getInput().getSubscriber()).cancel();
    }

    public IPageBookViewPage createPage(ISynchronizeView view) {
        return new MergeSynchronizePage(this, view, this.getInput());
    }

    public String getName() {
        return ((CVSMergeSubscriber)this.getInput().getSubscriber()).getName();
    }

    private void write(CVSMergeSubscriber s, IMemento memento) {
        CVSTag start = s.getStartTag();
        CVSTag end = s.getEndTag();
        memento.putString(CTX_START_TAG, start.getName());
        memento.putInteger(CTX_START_TAG_TYPE, start.getType());
        memento.putString(CTX_END_TAG, end.getName());
        memento.putInteger(CTX_END_TAG_TYPE, end.getType());
        IResource[] roots = s.roots();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            IMemento rootNode = memento.createChild(CTX_ROOT);
            rootNode.putString(CTX_ROOT_PATH, resource.getFullPath().toString());
            ++i;
        }
    }

    private CVSMergeSubscriber read(QualifiedName id, IMemento memento) throws CVSException {
        CVSTag start = new CVSTag(memento.getString(CTX_START_TAG), memento.getInteger(CTX_START_TAG_TYPE).intValue());
        CVSTag end = new CVSTag(memento.getString(CTX_END_TAG), memento.getInteger(CTX_END_TAG_TYPE).intValue());
        IMemento[] rootNodes = memento.getChildren(CTX_ROOT);
        if (rootNodes == null || rootNodes.length == 0) {
            throw new CVSException(Policy.bind("MergeSynchronizeParticipant.10", id.toString()));
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < rootNodes.length) {
            IMemento rootNode = rootNodes[i];
            Path path = new Path(rootNode.getString(CTX_ROOT_PATH));
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path, true);
            if (resource != null) {
                resources.add(resource);
            } else {
                CVSProviderPlugin.log((int)1, (String)Policy.bind("MergeSynchronizeParticipant.11", path.toString()), null);
            }
            ++i;
        }
        if (resources.isEmpty()) {
            throw new CVSException(Policy.bind("MergeSynchronizeParticipant.12", id.toString()));
        }
        IResource[] roots = resources.toArray(new IResource[resources.size()]);
        return new CVSMergeSubscriber(id, roots, start, end);
    }
}

