/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.synchronize.sets.ISyncSetChangedListener;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantLabelProvider;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantPage;
import org.eclipse.ui.IActionDelegate;

public class CVSSynchronizeViewPage
extends TeamSubscriberParticipantPage
implements ISyncSetChangedListener {
    private List delegates = new ArrayList(2);

    public CVSSynchronizeViewPage(TeamSubscriberParticipant page, ISynchronizeView view, SubscriberInput input) {
        super(page, view, input);
    }

    public void dispose() {
        super.dispose();
        this.getInput().getFilteredSyncSet().removeSyncSetChangedListener((ISyncSetChangedListener)this);
        CVSUIPlugin.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void syncSetChanged(SyncSetChangedEvent event) {
        StructuredViewer viewer = this.getViewer();
        if (viewer != null && this.getInput() != null) {
            IStructuredContentProvider cp = (IStructuredContentProvider)viewer.getContentProvider();
            StructuredSelection selection = new StructuredSelection(cp.getElements((Object)this.getInput()));
            Iterator it = this.delegates.iterator();
            while (it.hasNext()) {
                CVSActionDelegate delegate = (CVSActionDelegate)((Object)it.next());
                delegate.getDelegate().selectionChanged((IAction)delegate, (ISelection)selection);
            }
        }
    }

    private void addDelegate(CVSActionDelegate delagate) {
        this.delegates.add(delagate);
    }

    protected ILabelProvider getLabelProvider() {
        return new TeamSubscriberParticipantLabelProvider(){

            protected String decorateText(String input, Object resource) {
                if (resource instanceof IResource) {
                    CVSLightweightDecorator.Decoration decoration = new CVSLightweightDecorator.Decoration();
                    CVSLightweightDecorator.decorateTextLabel((IResource)resource, decoration, false, true);
                    StringBuffer output = new StringBuffer(25);
                    if (decoration.prefix != null) {
                        output.append(decoration.prefix);
                    }
                    output.append(input);
                    if (decoration.suffix != null) {
                        output.append(decoration.suffix);
                    }
                    return output.toString();
                }
                return input;
            }
        };
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        String prop = event.getProperty();
        if (prop.equals("org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED") && this.getViewer() != null && this.getInput() != null) {
            this.getViewer().refresh(true);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getInput().getFilteredSyncSet().addSyncSetChangedListener((ISyncSetChangedListener)this);
        CVSUIPlugin.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected class CVSActionDelegate
    extends Action {
        private IActionDelegate delegate;

        public CVSActionDelegate(IActionDelegate delegate) {
            this.delegate = delegate;
            CVSSynchronizeViewPage.this.addDelegate(this);
        }

        public void run() {
            IStructuredContentProvider cp = (IStructuredContentProvider)CVSSynchronizeViewPage.this.getViewer().getContentProvider();
            StructuredSelection selection = new StructuredSelection(cp.getElements((Object)CVSSynchronizeViewPage.this.getInput()));
            if (!selection.isEmpty()) {
                this.delegate.selectionChanged((IAction)this, (ISelection)selection);
                this.delegate.run((IAction)this);
            }
        }

        public IActionDelegate getDelegate() {
            return this.delegate;
        }
    }
}

