/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSBlockingRunnableContext;
import org.eclipse.team.internal.ccvs.ui.operations.CVSSubscriberNonblockingContext;
import org.eclipse.team.internal.ccvs.ui.operations.ICVSRunnableContext;
import org.eclipse.team.internal.ccvs.ui.subscriber.UpdateDialog;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.actions.SubscriberAction;
import org.eclipse.team.ui.synchronize.actions.SyncInfoSet;

public abstract class CVSSubscriberAction
extends SubscriberAction {
    protected boolean isOutOfSync(SyncInfo resource) {
        if (resource == null) {
            return false;
        }
        return resource.getKind() != 0 || !resource.getLocal().exists() && resource.getRemote() != null;
    }

    protected void makeInSync(SyncInfo[] folders) throws TeamException {
        int i = 0;
        while (i < folders.length) {
            SyncInfo resource = folders[i];
            this.makeInSync(resource);
            ++i;
        }
    }

    protected boolean makeInSync(SyncInfo info) throws TeamException {
        if (this.isOutOfSync(info)) {
            SyncInfo parent = this.getParent(info);
            if (parent == null) {
                if (info.getLocal().getType() == 8) {
                    return true;
                }
                CVSUIPlugin.log(2, Policy.bind("CVSSubscriberAction.0", info.getLocal().getFullPath().toString()), null);
                return false;
            }
            if (!this.makeInSync(parent)) {
                return false;
            }
            if (info instanceof CVSSyncInfo) {
                CVSSyncInfo cvsInfo = (CVSSyncInfo)info;
                IStatus status = cvsInfo.makeInSync();
                if (status.getSeverity() == 4) {
                    this.logError(status);
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void makeOutgoing(SyncInfo[] folders, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100 * folders.length);
        int i = 0;
        while (i < folders.length) {
            SyncInfo info = folders[i];
            this.makeOutgoing(info, Policy.subMonitorFor(monitor, 100));
            ++i;
        }
        monitor.done();
    }

    private void makeOutgoing(SyncInfo info, IProgressMonitor monitor) throws TeamException {
        CVSSyncInfo cvsInfo;
        IStatus status;
        if (info == null) {
            return;
        }
        if (info instanceof CVSSyncInfo && (status = (cvsInfo = (CVSSyncInfo)info).makeOutgoing(monitor)).getSeverity() == 4) {
            this.logError(status);
        }
    }

    protected void logError(IStatus status) {
        CVSUIPlugin.log(status);
    }

    protected void handle(Throwable t) {
        CVSUIPlugin.openError(this.getShell(), this.getErrorTitle(), null, t, 13);
    }

    protected String getErrorTitle() {
        return null;
    }

    public void run(IAction action) {
        SyncInfoSet syncSet = this.getFilteredSyncInfoSet(this.getFilteredSyncInfos());
        if (syncSet == null || syncSet.isEmpty()) {
            return;
        }
        try {
            this.getCVSRunnableContext().run(this.getJobName(syncSet), this.getSchedulingRule(syncSet), true, this.getRunnable(syncSet));
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    public IRunnableWithProgress getRunnable(final SyncInfoSet syncSet) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    EclipseSynchronizer.getInstance().run(CVSSubscriberAction.this.getSchedulingRule(syncSet), new ICVSRunnable(this, syncSet){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ SyncInfoSet val$syncSet;
                        {
                            this.this$1 = var1_1;
                            this.val$syncSet = syncInfoSet;
                        }

                        public void run(IProgressMonitor monitor) throws CVSException {
                            try {
                                1.access$0(this.this$1).run(this.val$syncSet, monitor);
                            }
                            catch (TeamException e) {
                                throw CVSException.wrapException((CoreException)((Object)e));
                            }
                        }
                    }, monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }

            static /* synthetic */ CVSSubscriberAction access$0(1 var0) {
                return var0.CVSSubscriberAction.this;
            }
        };
    }

    protected abstract void run(SyncInfoSet var1, IProgressMonitor var2) throws TeamException;

    private ICVSRunnableContext getCVSRunnableContext() {
        if (this.canRunAsJob() && this.areJobsEnabled()) {
            return new CVSSubscriberNonblockingContext();
        }
        return new CVSBlockingRunnableContext(this.shell);
    }

    protected boolean areJobsEnabled() {
        return true;
    }

    protected abstract String getJobName(SyncInfoSet var1);

    protected ISchedulingRule getSchedulingRule(SyncInfoSet syncSet) {
        IResource[] resources = syncSet.getResources();
        HashSet<IProject> set = new HashSet<IProject>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            set.add(resource.getProject());
            ++i;
        }
        IProject[] projects = set.toArray(new IProject[set.size()]);
        if (projects.length == 1) {
            return projects[0];
        }
        return new MultiRule((ISchedulingRule[])projects);
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected SyncInfoSet getFilteredSyncInfoSet(SyncInfo[] selectedResources) {
        return new SyncInfoSet(selectedResources);
    }

    protected void pruneEmptyParents(SyncInfo[] nodes) throws CVSException {
        if (!CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            return;
        }
        ICVSResource[] cvsResources = new ICVSResource[nodes.length];
        int i = 0;
        while (i < cvsResources.length) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)nodes[i].getLocal());
            ++i;
        }
        new PruneFolderVisitor().visit(CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()), cvsResources);
    }

    public CVSSyncInfo getCVSSyncInfo(SyncInfo info) {
        if (info instanceof CVSSyncInfo) {
            return (CVSSyncInfo)info;
        }
        return null;
    }

    protected SyncInfo getParent(SyncInfo info) throws TeamException {
        return info.getSubscriber().getSyncInfo((IResource)info.getLocal().getParent(), (IProgressMonitor)new NullProgressMonitor());
    }

    protected IResource[] getIResourcesFrom(SyncInfo[] nodes) {
        ArrayList<IResource> resources = new ArrayList<IResource>(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            resources.add(nodes[i].getLocal());
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected boolean promptForOverwrite(final SyncInfoSet syncSet) {
        final int[] result = new int[]{1};
        TeamUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                UpdateDialog dialog = new UpdateDialog(CVSSubscriberAction.this.getShell(), syncSet);
                result[0] = dialog.open();
            }
        });
        return result[0] == 2;
    }
}

