/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RefreshRemoteProjectSelectionPage;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;

public class RefreshRemoteProjectWizard
extends Wizard {
    private Dialog parentDialog;
    private ICVSRepositoryLocation root;
    private ICVSRemoteResource[] rootFolders;
    private RefreshRemoteProjectSelectionPage projectSelectionPage;
    private IDialogSettings settings;

    public static boolean execute(Shell shell, final ICVSRepositoryLocation root) {
        final ICVSRemoteResource[][] rootFolders = new ICVSRemoteResource[1][0];
        rootFolders[0] = null;
        try {
            new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        rootFolders[0] = CVSUIPlugin.getPlugin().getRepositoryManager().getFoldersForTag(root, CVSTag.DEFAULT, monitor);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(shell, null, null, e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        RefreshRemoteProjectWizard wizard = new RefreshRemoteProjectWizard(root, rootFolders[0]);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        wizard.setParentDialog((Dialog)dialog);
        return dialog.open() == 0;
    }

    public RefreshRemoteProjectWizard(ICVSRepositoryLocation root, ICVSRemoteResource[] rootFolders) {
        this.root = root;
        this.rootFolders = rootFolders;
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("RefreshRemoteProjectWizard");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("RefreshRemoteProjectWizard");
        }
        this.setWindowTitle(Policy.bind("RefreshRemoteProjectWizard.title"));
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif");
        this.projectSelectionPage = new RefreshRemoteProjectSelectionPage("ProjectSelectionPage", Policy.bind("RefreshRemoteProjectSelectionPage.pageTitle"), substImage, Policy.bind("RefreshRemoteProjectSelectionPage.pageDescription"), this.parentDialog, this.settings, this.root, this.rootFolders);
        this.addPage((IWizardPage)this.projectSelectionPage);
    }

    public boolean performFinish() {
        final ICVSRemoteResource[] selectedFolders = this.projectSelectionPage.getSelectedRemoteProject();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(null, 100 * selectedFolders.length);
                    try {
                        try {
                            RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                            int i = 0;
                            while (i < selectedFolders.length) {
                                ICVSRemoteResource resource = selectedFolders[i];
                                if (resource instanceof ICVSFolder) {
                                    manager.refreshDefinedTags((ICVSFolder)resource, true, true, Policy.subMonitorFor(monitor, 100));
                                }
                                ++i;
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var5_8 = null;
                    }
                    monitor.done();
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void setParentDialog(Dialog parentDialog) {
        this.parentDialog = parentDialog;
    }
}

